/*
 * Decompiled with CFR 0.152.
 */
package nl.uu.cs.ape.constraints;

import java.util.ArrayList;
import java.util.List;
import nl.uu.cs.ape.models.Module;
import nl.uu.cs.ape.models.Type;
import nl.uu.cs.ape.models.logic.constructs.TaxonomyPredicate;
import nl.uu.cs.ape.utils.APEDimensionsException;
import nl.uu.cs.ape.utils.APEDomainSetup;
import nl.uu.cs.ape.utils.APEUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstraintTemplateParameter {
    private static final Logger log = LoggerFactory.getLogger(ConstraintTemplateParameter.class);
    private List<TaxonomyPredicate> parameterTypes;

    public ConstraintTemplateParameter(List<TaxonomyPredicate> parameterTypes) {
        this.parameterTypes = parameterTypes != null ? parameterTypes : new ArrayList<TaxonomyPredicate>();
    }

    public ConstraintTemplateParameter() {
        this.parameterTypes = new ArrayList<TaxonomyPredicate>();
    }

    public void addParameter(TaxonomyPredicate newParam) {
        if (newParam == null) {
            log.warn("Cannot add null as a dimension that characterises a Taxonomy Instance.");
        } else {
            this.parameterTypes.add(newParam);
        }
    }

    public List<TaxonomyPredicate> getParameterTemplateTypes() {
        return this.parameterTypes;
    }

    public String toString() {
        String print = "{";
        for (TaxonomyPredicate param : this.parameterTypes) {
            print = print.concat(param.getRootNodeID()).concat(":").concat(param.toShortString()).concat(",");
        }
        return APEUtils.removeLastChar(print) + "}";
    }

    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        for (TaxonomyPredicate predicate : this.parameterTypes) {
            json.put(predicate.getRootNodeID(), (Object)predicate.getPredicateID());
        }
        return json;
    }

    public TaxonomyPredicate readConstraintParameterFromJson(JSONObject jsonParam, APEDomainSetup domainSetup) throws JSONException, APEDimensionsException {
        if (this.parameterTypes.get(0) instanceof Type) {
            return Type.taxonomyInstanceFromJson(jsonParam, domainSetup, false);
        }
        return Module.taxonomyInstanceFromJson(jsonParam, domainSetup);
    }
}

