/*
 * Decompiled with CFR 0.152.
 */
package nl.uu.cs.ape.core.implSAT;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import nl.uu.cs.ape.automaton.Block;
import nl.uu.cs.ape.automaton.ModuleAutomaton;
import nl.uu.cs.ape.automaton.State;
import nl.uu.cs.ape.automaton.TypeAutomaton;
import nl.uu.cs.ape.core.implSAT.SATSynthesisEngine;
import nl.uu.cs.ape.models.AllModules;
import nl.uu.cs.ape.models.Module;
import nl.uu.cs.ape.models.Pair;
import nl.uu.cs.ape.models.Type;
import nl.uu.cs.ape.models.enums.AtomType;
import nl.uu.cs.ape.models.enums.ConfigEnum;
import nl.uu.cs.ape.models.logic.constructs.PredicateLabel;
import nl.uu.cs.ape.models.logic.constructs.TaxonomyPredicate;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxAtom;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxConjunction;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxDisjunction;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxEquivalence;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxFormula;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxImplication;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxNegatedConjunction;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxNegation;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxXOR;
import nl.uu.cs.ape.utils.APEDomainSetup;
import nl.uu.cs.ape.utils.APEUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EnforceModuleRelatedRules {
    private static final Logger log = LoggerFactory.getLogger(EnforceModuleRelatedRules.class);

    private EnforceModuleRelatedRules() {
        throw new UnsupportedOperationException();
    }

    public static Set<SLTLxFormula> moduleAnnotations(SATSynthesisEngine synthesisInstance) {
        HashSet<SLTLxFormula> fullEncoding = new HashSet<SLTLxFormula>();
        fullEncoding.addAll(EnforceModuleRelatedRules.toolInputTypes(synthesisInstance));
        fullEncoding.addAll(EnforceModuleRelatedRules.toolOutputTypes(synthesisInstance));
        return fullEncoding;
    }

    public static Set<SLTLxFormula> memoryStructure(SATSynthesisEngine synthesisInstance) {
        HashSet<SLTLxFormula> fullEncoding = new HashSet<SLTLxFormula>();
        fullEncoding.addAll(EnforceModuleRelatedRules.allowDataReferencing(synthesisInstance.getTypeAutomaton()));
        fullEncoding.addAll(EnforceModuleRelatedRules.usageOfGeneratedTypes(synthesisInstance));
        fullEncoding.addAll(EnforceModuleRelatedRules.dataReference(synthesisInstance.getDomainSetup(), synthesisInstance.getTypeAutomaton()));
        return fullEncoding;
    }

    public static Set<SLTLxFormula> ancestorRelationsDependency(SATSynthesisEngine synthesisInstance) {
        HashSet<SLTLxFormula> fullEncoding = new HashSet<SLTLxFormula>();
        TypeAutomaton typeAutomaton = synthesisInstance.getTypeAutomaton();
        fullEncoding.addAll(EnforceModuleRelatedRules.relationalReflexivity(AtomType.R_RELATION, typeAutomaton));
        fullEncoding.addAll(EnforceModuleRelatedRules.relationalTransitivity(AtomType.R_RELATION, typeAutomaton));
        fullEncoding.addAll(EnforceModuleRelatedRules.restrictAncestorRelationDomain(typeAutomaton));
        fullEncoding.addAll(EnforceModuleRelatedRules.ancestorRelRestrictOverModules(synthesisInstance));
        fullEncoding.addAll(EnforceModuleRelatedRules.ancestorRelDependencyOverModules(synthesisInstance));
        fullEncoding.addAll(EnforceModuleRelatedRules.ancestorRelOverDataReferencing(typeAutomaton));
        return fullEncoding;
    }

    public static Set<SLTLxFormula> identityRelationsDependency(TypeAutomaton typeAutomaton) {
        HashSet<SLTLxFormula> fullEncoding = new HashSet<SLTLxFormula>();
        fullEncoding.addAll(EnforceModuleRelatedRules.relationalIdentity(AtomType.IDENTITY_RELATION, typeAutomaton));
        return fullEncoding;
    }

    private static Set<SLTLxFormula> toolInputTypes(SATSynthesisEngine synthesisInstance) {
        HashSet<SLTLxFormula> fullEncoding = new HashSet<SLTLxFormula>();
        for (TaxonomyPredicate potentialModule : synthesisInstance.getDomainSetup().getAllModules().getModules()) {
            if (!(potentialModule instanceof Module)) continue;
            Module module = (Module)potentialModule;
            for (State moduleState : synthesisInstance.getModuleAutomaton().getAllStates()) {
                int moduleNo = moduleState.getLocalStateNumber();
                List<State> currInputStates = synthesisInstance.getTypeAutomaton().getUsedTypesBlock(moduleNo - 1).getStates();
                List<Type> moduleInputs = module.getModuleInput();
                for (State currInputState : currInputStates) {
                    int currInputStateNo = currInputState.getLocalStateNumber();
                    if (currInputStateNo < moduleInputs.size()) {
                        TaxonomyPredicate currInputType = moduleInputs.get(currInputStateNo);
                        fullEncoding.add(new SLTLxImplication(new SLTLxAtom(AtomType.MODULE, module, moduleState), new SLTLxAtom(AtomType.USED_TYPE, currInputType, currInputState)));
                        continue;
                    }
                    fullEncoding.add(new SLTLxImplication(new SLTLxAtom(AtomType.MODULE, module, moduleState), new SLTLxAtom(AtomType.USED_TYPE, synthesisInstance.getEmptyType(), currInputState)));
                }
            }
        }
        return fullEncoding;
    }

    private static Set<SLTLxFormula> dataReference(APEDomainSetup domainSetup, TypeAutomaton typeAutomaton) {
        HashSet<SLTLxFormula> fullEncoding = new HashSet<SLTLxFormula>();
        for (TaxonomyPredicate taxonomyPredicate : domainSetup.getAllTypes().getTypes()) {
            if (!taxonomyPredicate.isSimplePredicate() && !taxonomyPredicate.isEmptyPredicate()) continue;
            for (State currUsedTypeState : typeAutomaton.getAllUsedTypesStates()) {
                if (!taxonomyPredicate.isEmptyPredicate()) {
                    fullEncoding.add(new SLTLxNegatedConjunction(new SLTLxAtom(AtomType.USED_TYPE, taxonomyPredicate, currUsedTypeState), new SLTLxAtom(AtomType.MEM_TYPE_REFERENCE, typeAutomaton.getNullState(), currUsedTypeState)));
                    for (State refMemoryTypeState : typeAutomaton.getAllMemoryTypesStates()) {
                        fullEncoding.add(new SLTLxImplication(new SLTLxAtom(AtomType.MEM_TYPE_REFERENCE, refMemoryTypeState, currUsedTypeState), new SLTLxEquivalence(new SLTLxAtom(AtomType.USED_TYPE, taxonomyPredicate, currUsedTypeState), new SLTLxAtom(AtomType.MEMORY_TYPE, taxonomyPredicate, refMemoryTypeState))));
                    }
                    continue;
                }
                fullEncoding.add(new SLTLxImplication(new SLTLxAtom(AtomType.USED_TYPE, taxonomyPredicate, currUsedTypeState), new SLTLxAtom(AtomType.MEM_TYPE_REFERENCE, typeAutomaton.getNullState(), currUsedTypeState)));
            }
        }
        return fullEncoding;
    }

    private static Set<SLTLxFormula> allowDataReferencing(TypeAutomaton typeAutomaton) {
        HashSet<SLTLxFormula> fullEncoding = new HashSet<SLTLxFormula>();
        for (Block currBlock : typeAutomaton.getUsedTypesBlocks()) {
            int blockNumber = currBlock.getBlockNumber();
            for (State currInputState : currBlock.getStates()) {
                List<State> possibleMemStates = typeAutomaton.getMemoryStatesUntilBlockNo(blockNumber);
                possibleMemStates.add(typeAutomaton.getNullState());
                HashSet<SLTLxAtom> allPossibilities = new HashSet<SLTLxAtom>();
                for (State state : possibleMemStates) {
                    allPossibilities.add(new SLTLxAtom(AtomType.MEM_TYPE_REFERENCE, state, currInputState));
                }
                fullEncoding.add(new SLTLxDisjunction(allPossibilities));
                for (Pair pair : EnforceModuleRelatedRules.getPredicatePairs(possibleMemStates)) {
                    fullEncoding.add(new SLTLxNegatedConjunction(new SLTLxAtom(AtomType.MEM_TYPE_REFERENCE, (PredicateLabel)pair.getFirst(), currInputState), new SLTLxAtom(AtomType.MEM_TYPE_REFERENCE, (PredicateLabel)pair.getSecond(), currInputState)));
                }
                for (State state : typeAutomaton.getMemoryStatesAfterBlockNo(blockNumber)) {
                    fullEncoding.add(new SLTLxNegation(new SLTLxAtom(AtomType.MEM_TYPE_REFERENCE, state, currInputState)));
                }
            }
        }
        return fullEncoding;
    }

    private static Set<SLTLxFormula> restrictAncestorRelationDomain(TypeAutomaton typeAutomaton) {
        int blockNumber;
        HashSet<SLTLxFormula> fullEncoding = new HashSet<SLTLxFormula>();
        for (Block currBlock : typeAutomaton.getUsedTypesBlocks()) {
            blockNumber = currBlock.getBlockNumber();
            for (State currInputState : currBlock.getStates()) {
                for (State nonExistingMemState : typeAutomaton.getMemoryStatesAfterBlockNo(blockNumber)) {
                    fullEncoding.add(new SLTLxNegation(new SLTLxAtom(AtomType.R_RELATION, nonExistingMemState, currInputState)));
                }
                for (State existingMemState : typeAutomaton.getMemoryStatesUntilBlockNo(blockNumber)) {
                    fullEncoding.add(new SLTLxNegatedConjunction(new SLTLxAtom(AtomType.MEM_TYPE_REFERENCE, typeAutomaton.getNullState(), currInputState), new SLTLxAtom(AtomType.R_RELATION, existingMemState, currInputState)));
                }
            }
        }
        for (Block currBlock : typeAutomaton.getMemoryTypesBlocks()) {
            blockNumber = currBlock.getBlockNumber();
            for (State currMemState : currBlock.getStates()) {
                for (State nonExistingMemState : typeAutomaton.getMemoryStatesAfterBlockNo(blockNumber - 1)) {
                    if (nonExistingMemState.equals(currMemState)) continue;
                    fullEncoding.add(new SLTLxNegation(new SLTLxAtom(AtomType.R_RELATION, nonExistingMemState, currMemState)));
                }
            }
        }
        return fullEncoding;
    }

    private static Set<SLTLxFormula> ancestorRelOverDataReferencing(TypeAutomaton typeAutomaton) {
        HashSet<SLTLxFormula> fullEncoding = new HashSet<SLTLxFormula>();
        for (Block currInputBlock : typeAutomaton.getUsedTypesBlocks()) {
            int blockNumber = currInputBlock.getBlockNumber();
            for (State currInputState : currInputBlock.getStates()) {
                for (State availableMemState : typeAutomaton.getMemoryStatesUntilBlockNo(blockNumber)) {
                    fullEncoding.add(new SLTLxImplication(new SLTLxAtom(AtomType.MEM_TYPE_REFERENCE, availableMemState, currInputState), new SLTLxAtom(AtomType.R_RELATION, availableMemState, currInputState)));
                }
            }
        }
        return fullEncoding;
    }

    private static Set<SLTLxFormula> ancestorRelDependencyOverModules(SATSynthesisEngine synthesisInstance) {
        TypeAutomaton typeAutomaton = synthesisInstance.getTypeAutomaton();
        HashSet<SLTLxFormula> fullEncoding = new HashSet<SLTLxFormula>();
        for (int i = 0; i < typeAutomaton.getUsedTypesBlocks().size() - 1; ++i) {
            Block currInputBlock = typeAutomaton.getUsedTypesBlock(i);
            Block currMemBlock = typeAutomaton.getMemoryTypesBlock(i + 1);
            Type emptyType = synthesisInstance.getEmptyType();
            for (State currMemState : currMemBlock.getStates()) {
                for (State currInputState : currInputBlock.getStates()) {
                    fullEncoding.add(new SLTLxXOR(new SLTLxAtom(AtomType.R_RELATION, currInputState, currMemState), new SLTLxDisjunction(new SLTLxAtom(AtomType.MEMORY_TYPE, emptyType, currMemState), new SLTLxAtom(AtomType.USED_TYPE, emptyType, currInputState))));
                }
            }
        }
        return fullEncoding;
    }

    private static Set<SLTLxFormula> ancestorRelRestrictOverModules(SATSynthesisEngine synthesisInstance) {
        TypeAutomaton typeAutomaton = synthesisInstance.getTypeAutomaton();
        HashSet<SLTLxFormula> fullEncoding = new HashSet<SLTLxFormula>();
        Type emptyType = synthesisInstance.getEmptyType();
        for (int i = 0; i < typeAutomaton.getUsedTypesBlocks().size() - 1; ++i) {
            Block currInputBlock = typeAutomaton.getUsedTypesBlock(i);
            Block currMemBlock = typeAutomaton.getMemoryTypesBlock(i + 1);
            for (State currMemState : currMemBlock.getStates()) {
                SLTLxAtom outputEmpty = new SLTLxAtom(AtomType.MEMORY_TYPE, emptyType, currMemState);
                for (State existingType : typeAutomaton.getAllMemoryStatesUntilBlockNo(i)) {
                    HashSet<SLTLxNegation> notInputAncestors = new HashSet<SLTLxNegation>();
                    for (State currInputState : currInputBlock.getStates()) {
                        notInputAncestors.add(new SLTLxNegation(new SLTLxAtom(AtomType.R_RELATION, existingType, currInputState)));
                    }
                    fullEncoding.add(new SLTLxDisjunction(outputEmpty, new SLTLxImplication(new SLTLxConjunction(notInputAncestors), new SLTLxNegation(new SLTLxAtom(AtomType.R_RELATION, existingType, currMemState)))));
                }
            }
        }
        return fullEncoding;
    }

    private static Set<SLTLxFormula> relationalReflexivity(AtomType binRel, TypeAutomaton typeAutomaton) {
        HashSet<SLTLxFormula> fullEncoding = new HashSet<SLTLxFormula>();
        typeAutomaton.getAllStates().forEach(state -> {
            fullEncoding.add(new SLTLxAtom(binRel, (PredicateLabel)state, (State)state));
            fullEncoding.add(new SLTLxNegation(new SLTLxAtom(binRel, (PredicateLabel)state, typeAutomaton.getNullState())));
        });
        return fullEncoding;
    }

    private static Set<SLTLxFormula> relationalIdentity(AtomType binRel, TypeAutomaton typeAutomaton) {
        HashSet<SLTLxFormula> fullEncoding = new HashSet<SLTLxFormula>();
        typeAutomaton.getAllStates().forEach(state1 -> {
            fullEncoding.add(new SLTLxNegation(new SLTLxAtom(binRel, (PredicateLabel)state1, typeAutomaton.getNullState())));
            fullEncoding.add(new SLTLxNegation(new SLTLxAtom(binRel, typeAutomaton.getNullState(), (State)state1)));
            typeAutomaton.getAllStates().forEach(state2 -> {
                if (state1.equals(state2)) {
                    fullEncoding.add(new SLTLxAtom(binRel, (PredicateLabel)state1, (State)state2));
                } else {
                    fullEncoding.add(new SLTLxNegation(new SLTLxAtom(binRel, (PredicateLabel)state1, (State)state2)));
                }
            });
        });
        return fullEncoding;
    }

    private static Set<SLTLxFormula> relationalTransitivity(AtomType binRel, TypeAutomaton typeAutomaton) {
        HashSet<SLTLxFormula> fullEncoding = new HashSet<SLTLxFormula>();
        typeAutomaton.getAllStates().forEach(state1 -> typeAutomaton.getAllStates().forEach(state2 -> typeAutomaton.getAllStates().forEach(state3 -> fullEncoding.add(new SLTLxImplication(new SLTLxConjunction(new SLTLxAtom(binRel, (PredicateLabel)state1, (State)state2), new SLTLxAtom(binRel, (PredicateLabel)state2, (State)state3)), new SLTLxAtom(binRel, (PredicateLabel)state1, (State)state3))))));
        return fullEncoding;
    }

    private static Set<SLTLxFormula> relationalSymmetry(AtomType binRel, TypeAutomaton typeAutomaton) {
        HashSet<SLTLxFormula> fullEncoding = new HashSet<SLTLxFormula>();
        typeAutomaton.getAllMemoryTypesStates().forEach(state1 -> typeAutomaton.getAllMemoryTypesStates().forEach(state2 -> fullEncoding.add(new SLTLxImplication(new SLTLxAtom(binRel, (PredicateLabel)state1, (State)state2), new SLTLxAtom(binRel, (PredicateLabel)state2, (State)state1)))));
        return fullEncoding;
    }

    private static Set<SLTLxFormula> usageOfGeneratedTypes(SATSynthesisEngine synthesisInstance) {
        Type emptyType = synthesisInstance.getEmptyType();
        TypeAutomaton typeAutomaton = synthesisInstance.getTypeAutomaton();
        HashSet<SLTLxFormula> fullEncoding = new HashSet<SLTLxFormula>();
        for (Block currBlock : typeAutomaton.getMemoryTypesBlocks()) {
            HashSet<SLTLxAtom> allPossibilities;
            int blockNumber = currBlock.getBlockNumber();
            if (blockNumber == 0) {
                if (synthesisInstance.getConfig().getUseWorkflowInput() == ConfigEnum.ALL) {
                    for (State state : currBlock.getStates()) {
                        HashSet<SLTLxAtom> allPossibilities2 = new HashSet<SLTLxAtom>();
                        allPossibilities2.add(new SLTLxAtom(AtomType.MEMORY_TYPE, emptyType, state));
                        for (State inputState : typeAutomaton.getUsedStatesAfterBlockNo(blockNumber - 1)) {
                            allPossibilities2.add(new SLTLxAtom(AtomType.MEM_TYPE_REFERENCE, state, inputState));
                        }
                        fullEncoding.add(new SLTLxDisjunction(allPossibilities2));
                    }
                    continue;
                }
                if (synthesisInstance.getConfig().getUseWorkflowInput() != ConfigEnum.ONE) continue;
                allPossibilities = new HashSet();
                for (State currMemoryState3 : currBlock.getStates()) {
                    if (currMemoryState3.getLocalStateNumber() == 0) {
                        allPossibilities.add(new SLTLxAtom(AtomType.MEMORY_TYPE, emptyType, currMemoryState3));
                    }
                    for (State inputState : typeAutomaton.getUsedStatesAfterBlockNo(blockNumber - 1)) {
                        allPossibilities.add(new SLTLxAtom(AtomType.MEM_TYPE_REFERENCE, currMemoryState3, inputState));
                    }
                }
                fullEncoding.add(new SLTLxDisjunction(allPossibilities));
                continue;
            }
            if (synthesisInstance.getConfig().getUseAllGeneratedData() == ConfigEnum.ALL) {
                for (State state : currBlock.getStates()) {
                    HashSet<SLTLxAtom> allPossibilities2 = new HashSet<SLTLxAtom>();
                    allPossibilities2.add(new SLTLxAtom(AtomType.MEMORY_TYPE, emptyType, state));
                    for (State inputState : typeAutomaton.getUsedStatesAfterBlockNo(blockNumber - 1)) {
                        allPossibilities2.add(new SLTLxAtom(AtomType.MEM_TYPE_REFERENCE, state, inputState));
                    }
                    fullEncoding.add(new SLTLxDisjunction(allPossibilities2));
                }
                continue;
            }
            if (synthesisInstance.getConfig().getUseAllGeneratedData() != ConfigEnum.ONE) continue;
            allPossibilities = new HashSet<SLTLxAtom>();
            for (State currMemoryState : currBlock.getStates()) {
                if (currMemoryState.getLocalStateNumber() == 0) {
                    allPossibilities.add(new SLTLxAtom(AtomType.MEMORY_TYPE, emptyType, currMemoryState));
                }
                for (State inputState : typeAutomaton.getUsedStatesAfterBlockNo(blockNumber - 1)) {
                    allPossibilities.add(new SLTLxAtom(AtomType.MEM_TYPE_REFERENCE, currMemoryState, inputState));
                }
            }
            fullEncoding.add(new SLTLxDisjunction(allPossibilities));
        }
        return fullEncoding;
    }

    private static Set<SLTLxFormula> toolOutputTypes(SATSynthesisEngine synthesisInstance) {
        HashSet<SLTLxFormula> fullEncoding = new HashSet<SLTLxFormula>();
        for (TaxonomyPredicate potentialModule : synthesisInstance.getDomainSetup().getAllModules().getModules()) {
            if (!(potentialModule instanceof Module)) continue;
            Module module = (Module)potentialModule;
            for (State moduleState : synthesisInstance.getModuleAutomaton().getAllStates()) {
                int moduleNo = moduleState.getLocalStateNumber();
                List<State> currOutputStates = synthesisInstance.getTypeAutomaton().getMemoryTypesBlock(moduleNo).getStates();
                List<Type> moduleOutputs = module.getModuleOutput();
                for (int i = 0; i < currOutputStates.size(); ++i) {
                    if (i < moduleOutputs.size()) {
                        TaxonomyPredicate outputType = moduleOutputs.get(i);
                        fullEncoding.add(new SLTLxImplication(new SLTLxAtom(AtomType.MODULE, module, moduleState), new SLTLxAtom(AtomType.MEMORY_TYPE, outputType, currOutputStates.get(i))));
                        continue;
                    }
                    fullEncoding.add(new SLTLxImplication(new SLTLxAtom(AtomType.MODULE, module, moduleState), new SLTLxAtom(AtomType.MEMORY_TYPE, synthesisInstance.getEmptyType(), currOutputStates.get(i))));
                }
            }
        }
        return fullEncoding;
    }

    public static Set<SLTLxFormula> moduleMutualExclusion(Pair<PredicateLabel> pair, ModuleAutomaton moduleAutomaton) {
        HashSet<SLTLxFormula> fullEncoding = new HashSet<SLTLxFormula>();
        for (State moduleState : moduleAutomaton.getAllStates()) {
            fullEncoding.add(new SLTLxDisjunction(new SLTLxNegation(new SLTLxAtom(AtomType.MODULE, pair.getFirst(), moduleState)), new SLTLxNegation(new SLTLxAtom(AtomType.MODULE, pair.getSecond(), moduleState))));
        }
        return fullEncoding;
    }

    public static Set<SLTLxFormula> moduleMandatoryUsage(AllModules allModules, ModuleAutomaton moduleAutomaton) {
        HashSet<SLTLxFormula> fullEncoding = new HashSet<SLTLxFormula>();
        if (allModules.getModules().isEmpty()) {
            log.warn("No tools were I/O annotated.");
            return fullEncoding;
        }
        for (State moduleState : moduleAutomaton.getAllStates()) {
            HashSet<SLTLxAtom> allPossibilities = new HashSet<SLTLxAtom>();
            for (TaxonomyPredicate tool : allModules.getModules()) {
                if (!(tool instanceof Module)) continue;
                allPossibilities.add(new SLTLxAtom(AtomType.MODULE, tool, moduleState));
            }
            fullEncoding.add(new SLTLxDisjunction(allPossibilities));
        }
        return fullEncoding;
    }

    public static Set<SLTLxFormula> moduleTaxonomyStructure(AllModules allModules, TaxonomyPredicate currModule, ModuleAutomaton moduleAutomaton) {
        HashSet<SLTLxFormula> fullEncoding = new HashSet<SLTLxFormula>();
        for (State moduleState : moduleAutomaton.getAllStates()) {
            fullEncoding.addAll(EnforceModuleRelatedRules.moduleTaxonomyStructureForState(allModules, currModule, moduleState));
        }
        return fullEncoding;
    }

    private static Set<SLTLxFormula> moduleTaxonomyStructureForState(AllModules allModules, TaxonomyPredicate currModule, State moduleState) {
        SLTLxAtom superModuleState = new SLTLxAtom(AtomType.MODULE, currModule, moduleState);
        HashSet<SLTLxFormula> fullEncoding = new HashSet<SLTLxFormula>();
        ArrayList<SLTLxAtom> subModulesStates = new ArrayList<SLTLxAtom>();
        if (currModule.getSubPredicates() != null && !currModule.getSubPredicates().isEmpty()) {
            for (TaxonomyPredicate subModule : APEUtils.safe(currModule.getSubPredicates())) {
                if (subModule == null) {
                    log.error("Submodule is 'null': " + currModule.getPredicateID() + " ->" + currModule.getSubPredicates().toString());
                }
                SLTLxAtom subModuleState = new SLTLxAtom(AtomType.MODULE, subModule, moduleState);
                subModulesStates.add(subModuleState);
                fullEncoding.addAll(EnforceModuleRelatedRules.moduleTaxonomyStructureForState(allModules, subModule, moduleState));
            }
            fullEncoding.add(new SLTLxImplication(superModuleState, new SLTLxDisjunction(subModulesStates)));
            for (SLTLxAtom subModuleState : subModulesStates) {
                fullEncoding.add(new SLTLxImplication(subModuleState, superModuleState));
            }
        }
        return fullEncoding;
    }

    public static List<Pair<PredicateLabel>> getPredicatePairs(List<? extends PredicateLabel> predicateList) {
        ArrayList<Pair<PredicateLabel>> pairs = new ArrayList<Pair<PredicateLabel>>();
        for (int i = 0; i < predicateList.size() - 1; ++i) {
            for (int j = i + 1; j < predicateList.size(); ++j) {
                pairs.add(new Pair<PredicateLabel>(predicateList.get(i), predicateList.get(j)));
            }
        }
        return pairs;
    }
}

