/*
 * Decompiled with CFR 0.152.
 */
package nl.uu.cs.ape.core.implSAT;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import nl.uu.cs.ape.automaton.Block;
import nl.uu.cs.ape.automaton.State;
import nl.uu.cs.ape.automaton.TypeAutomaton;
import nl.uu.cs.ape.configuration.APEConfigException;
import nl.uu.cs.ape.models.AllTypes;
import nl.uu.cs.ape.models.AuxTypePredicate;
import nl.uu.cs.ape.models.Pair;
import nl.uu.cs.ape.models.Type;
import nl.uu.cs.ape.models.enums.AtomType;
import nl.uu.cs.ape.models.enums.LogicOperation;
import nl.uu.cs.ape.models.logic.constructs.PredicateLabel;
import nl.uu.cs.ape.models.logic.constructs.TaxonomyPredicate;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxAtom;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxDisjunction;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxFormula;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxImplication;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxNegatedConjunction;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxNegation;
import nl.uu.cs.ape.utils.APEDomainSetup;
import nl.uu.cs.ape.utils.APEUtils;

public class EnforceTypeRelatedRules {
    private EnforceTypeRelatedRules() {
        throw new UnsupportedOperationException();
    }

    public static Set<SLTLxFormula> memoryTypesMutualExclusion(Pair<PredicateLabel> pair, TypeAutomaton typeAutomaton) {
        HashSet<SLTLxFormula> fullEncoding = new HashSet<SLTLxFormula>();
        PredicateLabel firstPair = pair.getFirst();
        PredicateLabel secondPair = pair.getSecond();
        for (State memTypeState : typeAutomaton.getAllMemoryTypesStates()) {
            fullEncoding.add(new SLTLxNegatedConjunction(new SLTLxAtom(AtomType.MEMORY_TYPE, firstPair, memTypeState), new SLTLxAtom(AtomType.MEMORY_TYPE, secondPair, memTypeState)));
        }
        return fullEncoding;
    }

    public static Set<SLTLxFormula> usedTypeMutualExclusion(Pair<PredicateLabel> pair, TypeAutomaton typeAutomaton) {
        HashSet<SLTLxFormula> fullEncoding = new HashSet<SLTLxFormula>();
        PredicateLabel firstPair = pair.getFirst();
        PredicateLabel secondPair = pair.getSecond();
        for (State usedTypeState : typeAutomaton.getAllUsedTypesStates()) {
            fullEncoding.add(new SLTLxNegatedConjunction(new SLTLxAtom(AtomType.USED_TYPE, firstPair, usedTypeState), new SLTLxAtom(AtomType.USED_TYPE, secondPair, usedTypeState)));
        }
        return fullEncoding;
    }

    public static Set<SLTLxFormula> typeMandatoryUsage(APEDomainSetup domainSetup, TypeAutomaton typeAutomaton) {
        HashSet<SLTLxFormula> fullEncoding = new HashSet<SLTLxFormula>();
        Type empty = domainSetup.getAllTypes().getEmptyType();
        Type dataType = AuxTypePredicate.generateAuxiliaryPredicate(domainSetup.getAllTypes().getDataTaxonomyDimensionsAsSortedSet(), LogicOperation.AND, domainSetup);
        for (Block typeBlock : typeAutomaton.getMemoryTypesBlocks()) {
            for (State memTypeState : typeBlock.getStates()) {
                fullEncoding.add(new SLTLxDisjunction(new SLTLxAtom(AtomType.MEMORY_TYPE, dataType, memTypeState), new SLTLxAtom(AtomType.MEMORY_TYPE, empty, memTypeState)));
            }
        }
        for (Block typeBlock : typeAutomaton.getUsedTypesBlocks()) {
            for (State usedTypeState : typeBlock.getStates()) {
                fullEncoding.add(new SLTLxDisjunction(new SLTLxAtom(AtomType.USED_TYPE, dataType, usedTypeState), new SLTLxAtom(AtomType.USED_TYPE, empty, usedTypeState)));
            }
        }
        return fullEncoding;
    }

    public static Set<SLTLxFormula> typeEnforceTaxonomyStructure(AllTypes allTypes, TypeAutomaton typeAutomaton) {
        HashSet<SLTLxFormula> fullEncoding = new HashSet<SLTLxFormula>();
        for (TaxonomyPredicate dimension : allTypes.getRootPredicates()) {
            for (Block memTypeBlock : typeAutomaton.getMemoryTypesBlocks()) {
                for (State memTypeState : memTypeBlock.getStates()) {
                    fullEncoding.addAll(EnforceTypeRelatedRules.typeEnforceTaxonomyStructureForState(dimension, memTypeState, AtomType.MEMORY_TYPE));
                }
            }
            for (Block usedTypeBlock : typeAutomaton.getUsedTypesBlocks()) {
                for (State usedTypeState : usedTypeBlock.getStates()) {
                    fullEncoding.addAll(EnforceTypeRelatedRules.typeEnforceTaxonomyStructureForState(dimension, usedTypeState, AtomType.USED_TYPE));
                }
            }
        }
        return fullEncoding;
    }

    private static Set<SLTLxFormula> typeEnforceTaxonomyStructureForState(TaxonomyPredicate currType, State typeState, AtomType typeElement) {
        SLTLxAtom superTypeState = new SLTLxAtom(typeElement, currType, typeState);
        HashSet<SLTLxFormula> fullEncoding = new HashSet<SLTLxFormula>();
        ArrayList<SLTLxAtom> subTypesStates = new ArrayList<SLTLxAtom>();
        if (currType.getSubPredicates() != null && !currType.getSubPredicates().isEmpty()) {
            for (TaxonomyPredicate subType : currType.getSubPredicates()) {
                SLTLxAtom subTypeState = new SLTLxAtom(typeElement, subType, typeState);
                subTypesStates.add(subTypeState);
                fullEncoding.addAll(EnforceTypeRelatedRules.typeEnforceTaxonomyStructureForState(subType, typeState, typeElement));
            }
            fullEncoding.add(new SLTLxImplication(superTypeState, new SLTLxDisjunction(subTypesStates)));
            for (SLTLxAtom subTypeState : subTypesStates) {
                fullEncoding.add(new SLTLxImplication(subTypeState, superTypeState));
            }
        }
        return fullEncoding;
    }

    public static Set<SLTLxFormula> workflowInputs(AllTypes allTypes, List<Type> program_inputs, TypeAutomaton typeAutomaton) throws APEConfigException {
        HashSet<SLTLxFormula> fullEncoding = new HashSet<SLTLxFormula>();
        List<State> workflowInputStates = typeAutomaton.getWorkflowInputBlock().getStates();
        for (int i = 0; i < workflowInputStates.size(); ++i) {
            State currState = workflowInputStates.get(i);
            if (i < program_inputs.size()) {
                Type currType = program_inputs.get(i);
                if (allTypes.get(currType.getPredicateID()) == null) {
                    throw APEConfigException.workflowIODataTypeNotInDomain(currType.getPredicateID());
                }
                fullEncoding.add(new SLTLxAtom(AtomType.MEMORY_TYPE, currType, currState));
                continue;
            }
            fullEncoding.add(new SLTLxAtom(AtomType.MEMORY_TYPE, allTypes.getEmptyType(), currState));
        }
        return fullEncoding;
    }

    public static Set<SLTLxFormula> workdlowOutputs(AllTypes allTypes, List<Type> program_outputs, TypeAutomaton typeAutomaton) throws APEConfigException {
        HashSet<SLTLxFormula> fullEncoding = new HashSet<SLTLxFormula>();
        List<State> workflowOutputStates = typeAutomaton.getWorkflowOutputBlock().getStates();
        for (int i = 0; i < workflowOutputStates.size(); ++i) {
            if (i < program_outputs.size()) {
                TaxonomyPredicate currType = program_outputs.get(i);
                if (allTypes.get(currType.getPredicateID()) == null) {
                    throw APEConfigException.workflowIODataTypeNotInDomain(currType.getPredicateID());
                }
                fullEncoding.add(new SLTLxAtom(AtomType.USED_TYPE, currType, workflowOutputStates.get(i)));
                continue;
            }
            fullEncoding.add(new SLTLxAtom(AtomType.USED_TYPE, allTypes.getEmptyType(), workflowOutputStates.get(i)));
        }
        return fullEncoding;
    }

    public static Set<SLTLxFormula> inputsAreNotOutputs(TypeAutomaton typeAutomaton) throws APEConfigException {
        HashSet<SLTLxFormula> fullEncoding = new HashSet<SLTLxFormula>();
        List<State> workflowInputStates = typeAutomaton.getWorkflowInputBlock().getStates();
        List<State> workflowOutputStates = typeAutomaton.getWorkflowOutputBlock().getStates();
        for (Pair<State> pairIO : APEUtils.getUniquePairs(workflowInputStates, workflowOutputStates)) {
            fullEncoding.add(new SLTLxNegation(new SLTLxAtom(AtomType.MEM_TYPE_REFERENCE, pairIO.getFirst(), pairIO.getSecond())));
        }
        return fullEncoding;
    }
}

