/*
 * Decompiled with CFR 0.152.
 */
package nl.uu.cs.ape.core.implSAT;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import nl.uu.cs.ape.automaton.State;
import nl.uu.cs.ape.core.SolutionInterpreter;
import nl.uu.cs.ape.core.implSAT.SATSynthesisEngine;
import nl.uu.cs.ape.models.AllModules;
import nl.uu.cs.ape.models.AuxiliaryPredicate;
import nl.uu.cs.ape.models.Module;
import nl.uu.cs.ape.models.Type;
import nl.uu.cs.ape.models.enums.AtomType;
import nl.uu.cs.ape.models.logic.constructs.PredicateLabel;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxLiteral;
import nl.uu.cs.ape.utils.APEUtils;

public class SATSolution
extends SolutionInterpreter {
    private static final String textUnsat = "UNSAT";
    private final List<SLTLxLiteral> literals;
    private final List<SLTLxLiteral> positiveLiterals;
    private final List<SLTLxLiteral> relevantModules;
    private final List<SLTLxLiteral> relevantTypes;
    private final List<SLTLxLiteral> relevantElements;
    private final List<SLTLxLiteral> references2MemTypes;
    private final Set<PredicateLabel> usedTypeStates;
    private final boolean unsat;

    public SATSolution(int[] satSolution, SATSynthesisEngine synthesisInstance) {
        this.unsat = false;
        this.literals = new ArrayList<SLTLxLiteral>();
        this.positiveLiterals = new ArrayList<SLTLxLiteral>();
        this.relevantModules = new ArrayList<SLTLxLiteral>();
        this.relevantTypes = new ArrayList<SLTLxLiteral>();
        this.relevantElements = new ArrayList<SLTLxLiteral>();
        this.references2MemTypes = new ArrayList<SLTLxLiteral>();
        this.usedTypeStates = new HashSet<PredicateLabel>();
        for (int mappedLiteral : satSolution) {
            SLTLxLiteral currLiteral;
            if (mappedLiteral >= synthesisInstance.getMappings().getInitialNumOfMappedAtoms()) {
                currLiteral = new SLTLxLiteral(Integer.toString(mappedLiteral), synthesisInstance.getMappings());
                this.literals.add(currLiteral);
                if (currLiteral.isNegated()) continue;
                this.positiveLiterals.add(currLiteral);
                if (currLiteral.getPredicate() instanceof AuxiliaryPredicate) continue;
                if (currLiteral.getPredicate() instanceof Module) {
                    this.relevantElements.add(currLiteral);
                    this.relevantModules.add(currLiteral);
                    continue;
                }
                if (currLiteral.getWorkflowElementType() != AtomType.MODULE && currLiteral.getWorkflowElementType() != AtomType.MEM_TYPE_REFERENCE && currLiteral.getWorkflowElementType() != AtomType.R_RELATION && currLiteral.getPredicate() instanceof Type && ((Type)currLiteral.getPredicate()).isSimplePredicate()) {
                    this.relevantElements.add(currLiteral);
                    this.relevantTypes.add(currLiteral);
                    this.usedTypeStates.add(currLiteral.getUsedInStateArgument());
                    continue;
                }
                if (!(currLiteral.getPredicate() instanceof State) || ((State)currLiteral.getPredicate()).getAbsoluteStateNumber() == -1) continue;
                this.references2MemTypes.add(currLiteral);
                this.relevantElements.add(currLiteral);
                continue;
            }
            if (mappedLiteral < 100000) continue;
            currLiteral = new SLTLxLiteral(Integer.toString(mappedLiteral), synthesisInstance.getMappings());
            this.literals.add(currLiteral);
        }
        Collections.sort(this.relevantModules);
        Collections.sort(this.relevantTypes);
        Collections.sort(this.references2MemTypes);
        Collections.sort(this.relevantElements);
    }

    public SATSolution() {
        this.unsat = true;
        this.literals = null;
        this.positiveLiterals = null;
        this.relevantModules = null;
        this.relevantTypes = null;
        this.relevantElements = null;
        this.references2MemTypes = null;
        this.usedTypeStates = null;
    }

    @Override
    public String getSolution() {
        StringBuilder solution = new StringBuilder();
        if (this.unsat) {
            solution = new StringBuilder(textUnsat);
        } else {
            for (SLTLxLiteral literal : this.positiveLiterals) {
                solution.append(literal.toString()).append(" ");
            }
        }
        return solution.toString();
    }

    @Override
    public String getCompleteSolution() {
        StringBuilder solution = new StringBuilder();
        if (this.unsat) {
            solution = new StringBuilder(textUnsat);
        } else {
            for (SLTLxLiteral literal : this.literals) {
                solution.append(literal.toString()).append("\n");
            }
        }
        return solution.toString();
    }

    @Override
    public String getRelevantToolsInSolution() {
        StringBuilder solution = new StringBuilder();
        if (this.unsat) {
            solution = new StringBuilder(textUnsat);
        } else {
            for (SLTLxLiteral literal : this.relevantModules) {
                solution.append(literal.getPredicate().getPredicateLabel()).append(" -> ");
            }
        }
        return APEUtils.removeNLastChar(solution.toString(), 4);
    }

    @Override
    public String getRelevantSolution() {
        StringBuilder solution = new StringBuilder();
        if (this.unsat) {
            solution = new StringBuilder(textUnsat);
        } else {
            for (SLTLxLiteral relevantElement : this.relevantElements) {
                solution.append(relevantElement.toString() + " ");
            }
        }
        return solution.toString();
    }

    @Override
    public List<Module> getRelevantSolutionModules(AllModules allModules) {
        ArrayList<Module> solutionModules = new ArrayList<Module>();
        if (this.unsat) {
            return null;
        }
        for (SLTLxLiteral literal : this.relevantModules) {
            solutionModules.add((Module)allModules.get(literal.getPredicate().getPredicateID()));
        }
        return solutionModules;
    }

    public String getOriginalSATSolution() {
        StringBuilder solution = new StringBuilder();
        if (!this.unsat) {
            for (SLTLxLiteral literal : this.literals) {
                solution.append(literal.toMappedString()).append(" ");
            }
        }
        return solution.toString();
    }

    public int[] getNegatedMappedSolutionArray(boolean toolSeqRepeat) {
        ArrayList<Integer> negSol = new ArrayList<Integer>();
        if (!this.unsat) {
            if (!toolSeqRepeat) {
                for (SLTLxLiteral literal : this.relevantModules) {
                    negSol.add(literal.toNegatedMappedInt());
                }
            } else {
                for (SLTLxLiteral literal : this.relevantElements) {
                    if (literal.getWorkflowElementType() == AtomType.MEMORY_TYPE) continue;
                    negSol.add(literal.toNegatedMappedInt());
                }
            }
        }
        int[] negSolList = new int[negSol.size()];
        for (int i = 0; i < negSol.size(); ++i) {
            negSolList[i] = (Integer)negSol.get(i);
        }
        return negSolList;
    }

    @Override
    public boolean isSat() {
        return !this.unsat;
    }
}

