/*
 * Decompiled with CFR 0.152.
 */
package nl.uu.cs.ape.core.implSAT;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import nl.uu.cs.ape.automaton.ModuleAutomaton;
import nl.uu.cs.ape.automaton.TypeAutomaton;
import nl.uu.cs.ape.configuration.APERunConfig;
import nl.uu.cs.ape.core.SynthesisEngine;
import nl.uu.cs.ape.core.implSAT.EnforceModuleRelatedRules;
import nl.uu.cs.ape.core.implSAT.EnforceSLTLxRelatedRules;
import nl.uu.cs.ape.core.implSAT.EnforceTypeRelatedRules;
import nl.uu.cs.ape.core.implSAT.SATSolution;
import nl.uu.cs.ape.core.solutionStructure.SolutionWorkflow;
import nl.uu.cs.ape.core.solutionStructure.SolutionsList;
import nl.uu.cs.ape.io.APEFiles;
import nl.uu.cs.ape.models.AbstractModule;
import nl.uu.cs.ape.models.Pair;
import nl.uu.cs.ape.models.SATAtomMappings;
import nl.uu.cs.ape.models.Type;
import nl.uu.cs.ape.models.logic.constructs.PredicateLabel;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxFormula;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxVariableOccurrenceCollection;
import nl.uu.cs.ape.utils.APEDomainSetup;
import nl.uu.cs.ape.utils.APEUtils;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.SolverFactory;
import org.sat4j.reader.DimacsReader;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SATSynthesisEngine
implements SynthesisEngine {
    private static final Logger log = LoggerFactory.getLogger(SATSynthesisEngine.class);
    private final APEDomainSetup domainSetup;
    private final APERunConfig runConfig;
    private final SATAtomMappings mappings;
    private final SolutionsList allSolutions;
    private File cnfEncoding;
    private File satInputFile;
    private ModuleAutomaton moduleAutomaton;
    private TypeAutomaton typeAutomaton;
    private SLTLxVariableOccurrenceCollection varUsage;
    public static double encodingTime = 0.0;
    public static double satSolvingTime = 0.0;

    public SATSynthesisEngine(APEDomainSetup domainSetup, SolutionsList allSolutions, APERunConfig runConfig, int workflowLength) throws IOException {
        this.domainSetup = domainSetup;
        this.allSolutions = allSolutions;
        this.runConfig = runConfig;
        this.mappings = allSolutions.getMappings();
        this.mappings.resetAuxVariables();
        this.varUsage = new SLTLxVariableOccurrenceCollection();
        this.satInputFile = null;
        this.cnfEncoding = File.createTempFile("satCNF" + workflowLength, null);
        int maxNoToolInputs = Math.max(domainSetup.getMaxNoToolInputs(), runConfig.getProgramOutputs().size());
        int maxNoToolOutputs = Math.max(domainSetup.getMaxNoToolOutputs(), runConfig.getProgramInputs().size());
        this.moduleAutomaton = new ModuleAutomaton(workflowLength, maxNoToolInputs, maxNoToolOutputs);
        this.typeAutomaton = new TypeAutomaton(workflowLength, maxNoToolInputs, maxNoToolOutputs);
    }

    @Override
    public boolean synthesisEncoding() throws IOException {
        long problemSetupStartTime = System.currentTimeMillis();
        AbstractModule rootModule = this.domainSetup.getAllModules().getRootModule();
        if (rootModule == null) {
            log.error("Taxonomies have not been setup properly.");
            return false;
        }
        String currLengthTimer = "length" + this.getSolutionSize();
        APEUtils.timerStart(currLengthTimer, this.runConfig.getDebugMode());
        APEUtils.timerRestartAndPrint(currLengthTimer, "Automaton encoding");
        SLTLxFormula.appendCNFToFile(this.cnfEncoding, this, EnforceModuleRelatedRules.moduleAnnotations(this));
        APEUtils.timerRestartAndPrint(currLengthTimer, "Tool I/O constraints");
        SLTLxFormula.appendCNFToFile(this.cnfEncoding, this, EnforceModuleRelatedRules.memoryStructure(this));
        APEUtils.timerRestartAndPrint(currLengthTimer, "Memory structure encoding");
        for (Pair<PredicateLabel> pair : this.domainSetup.getAllModules().getSimplePairs()) {
            SLTLxFormula.appendCNFToFile(this.cnfEncoding, this, EnforceModuleRelatedRules.moduleMutualExclusion(pair, this.moduleAutomaton));
        }
        APEUtils.timerRestartAndPrint(currLengthTimer, "Tool exclusions encoding");
        SLTLxFormula.appendCNFToFile(this.cnfEncoding, this, EnforceModuleRelatedRules.moduleMandatoryUsage(this.domainSetup.getAllModules(), this.moduleAutomaton));
        SLTLxFormula.appendCNFToFile(this.cnfEncoding, this, EnforceModuleRelatedRules.moduleTaxonomyStructure(this.domainSetup.getAllModules(), rootModule, this.moduleAutomaton));
        APEUtils.timerRestartAndPrint(currLengthTimer, "Tool usage encoding");
        for (Pair<PredicateLabel> pair : this.domainSetup.getAllTypes().getTypePairsForEachSubTaxonomy()) {
            SLTLxFormula.appendCNFToFile(this.cnfEncoding, this, EnforceTypeRelatedRules.memoryTypesMutualExclusion(pair, this.typeAutomaton));
        }
        APEUtils.timerRestartAndPrint(currLengthTimer, "Type exclusions encoding");
        SLTLxFormula.appendCNFToFile(this.cnfEncoding, this, EnforceTypeRelatedRules.typeMandatoryUsage(this.domainSetup, this.typeAutomaton));
        SLTLxFormula.appendCNFToFile(this.cnfEncoding, this, EnforceTypeRelatedRules.typeEnforceTaxonomyStructure(this.domainSetup.getAllTypes(), this.typeAutomaton));
        APEUtils.timerRestartAndPrint(currLengthTimer, "Type usage encoding");
        SLTLxFormula.appendCNFToFile(this.cnfEncoding, this, EnforceModuleRelatedRules.ancestorRelationsDependency(this));
        SLTLxFormula.appendCNFToFile(this.cnfEncoding, this, EnforceModuleRelatedRules.identityRelationsDependency(this.typeAutomaton));
        SLTLxFormula.appendCNFToFile(this.cnfEncoding, this, EnforceSLTLxRelatedRules.setTrueFalse());
        SLTLxFormula.appendCNFToFile(this.cnfEncoding, this, EnforceTypeRelatedRules.workflowInputs(this.domainSetup.getAllTypes(), this.runConfig.getProgramInputs(), this.typeAutomaton));
        SLTLxFormula.appendCNFToFile(this.cnfEncoding, this, EnforceTypeRelatedRules.workdlowOutputs(this.domainSetup.getAllTypes(), this.runConfig.getProgramOutputs(), this.typeAutomaton));
        SLTLxFormula.appendCNFToFile(this.cnfEncoding, this, EnforceTypeRelatedRules.inputsAreNotOutputs(this.typeAutomaton));
        if (!this.domainSetup.getUnformattedConstr().isEmpty() || !this.domainSetup.getSLTLxConstraints().isEmpty()) {
            APEFiles.appendToFile(this.cnfEncoding, APEUtils.encodeAPEConstraints(this, this.domainSetup, this.mappings, this.moduleAutomaton, this.typeAutomaton));
            APEUtils.timerRestartAndPrint(currLengthTimer, "SLTLx constraints");
        }
        SLTLxFormula.appendCNFToFile(this.cnfEncoding, this, EnforceSLTLxRelatedRules.preserveAuxiliaryPredicateRules(this.moduleAutomaton, this.typeAutomaton, this.domainSetup.getHelperPredicates()));
        int variables = this.mappings.getSize();
        int clauses = APEUtils.countLines(this.cnfEncoding);
        String satInputHeader = "p cnf " + variables + " " + clauses + "\n";
        APEUtils.timerRestartAndPrint(currLengthTimer, "Reading rows");
        this.satInputFile = APEFiles.prependToFile(satInputHeader, this.cnfEncoding);
        this.cnfEncoding.delete();
        long problemSetupTimeElapsedMillis = System.currentTimeMillis() - problemSetupStartTime;
        log.info("Total problem setup time: " + (float)problemSetupTimeElapsedMillis / 1000.0f + " sec (" + clauses + " clauses).");
        encodingTime += (double)problemSetupTimeElapsedMillis;
        return true;
    }

    @Override
    public List<SolutionWorkflow> synthesisExecution() throws IOException {
        FileInputStream tmpSatInput = new FileInputStream(this.satInputFile);
        List<SolutionWorkflow> currSolutions = this.runMiniSAT(tmpSatInput, this.allSolutions.getNumberOfSolutions(), this.allSolutions.getMaxNumberOfSolutions());
        ((InputStream)tmpSatInput).close();
        return currSolutions;
    }

    public String getCnfEncoding() {
        return this.cnfEncoding.toString();
    }

    private List<SolutionWorkflow> runMiniSAT(InputStream satInput, int solutionsFound, int solutionsFoundMax) {
        long realTimeElapsedMillis;
        ArrayList<SolutionWorkflow> solutions = new ArrayList<SolutionWorkflow>();
        ISolver solver = SolverFactory.newDefault();
        long globalTimeoutMs = this.runConfig.getTimeoutMs();
        long currTimeout = APEUtils.timerTimeLeft("globalTimer", globalTimeoutMs);
        if (currTimeout <= 0L) {
            log.warn("Timeout. Total solving took longer than the timeout: " + globalTimeoutMs + " ms.");
            return solutions;
        }
        solver.setTimeoutMs(currTimeout);
        long realStartTime = 0L;
        DimacsReader reader = new DimacsReader(solver);
        try {
            IProblem problem = reader.parseInstance(satInput);
            realStartTime = System.currentTimeMillis();
            while (solutionsFound < solutionsFoundMax && problem.isSatisfiable()) {
                SolutionWorkflow satSolution = new SolutionWorkflow(problem.model(), this);
                solutions.add(satSolution);
                if (++solutionsFound % 500 == 0) {
                    realTimeElapsedMillis = System.currentTimeMillis() - realStartTime;
                    log.info("Found in total " + solutionsFound + " solutions. Solving time: " + (float)realTimeElapsedMillis / 1000.0f + " sec.");
                }
                VecInt negSol = new VecInt(((SATSolution)satSolution.getNativeSolution()).getNegatedMappedSolutionArray(this.runConfig.getAllowToolSeqRepeat()));
                solver.addClause((IVecInt)negSol);
            }
            satInput.close();
        }
        catch (ParseFormatException e) {
            log.error("Error while parsing the cnf encoding of the problem by the MiniSAT solver.");
            log.error(e.getMessage());
            return solutions;
        }
        catch (ContradictionException e) {
            if (solutionsFound == 0) {
                log.warn("Unsatisfiable");
                return solutions;
            }
        }
        catch (TimeoutException e) {
            log.warn("Timeout. Total solving took longer than the timeout: " + globalTimeoutMs + " ms.");
        }
        catch (IOException e) {
            log.warn("Internal error while parsing the encoding.");
            return solutions;
        }
        if (solutionsFound == 0 || solutionsFound % 500 != 0) {
            realTimeElapsedMillis = System.currentTimeMillis() - realStartTime;
            log.info("Found " + solutionsFound + " solutions. Solving time: " + (float)realTimeElapsedMillis / 1000.0f + " sec.");
            satSolvingTime += (double)realTimeElapsedMillis;
        }
        return solutions;
    }

    public APERunConfig getConfig() {
        return this.runConfig;
    }

    @Override
    public APEDomainSetup getDomainSetup() {
        return this.domainSetup;
    }

    @Override
    public SATAtomMappings getMappings() {
        return this.mappings;
    }

    public SolutionsList getAllSolutions() {
        return this.allSolutions;
    }

    public ModuleAutomaton getModuleAutomaton() {
        return this.moduleAutomaton;
    }

    @Override
    public TypeAutomaton getTypeAutomaton() {
        return this.typeAutomaton;
    }

    public Type getEmptyType() {
        return this.domainSetup.getAllTypes().getEmptyType();
    }

    @Override
    public int getSolutionSize() {
        return this.moduleAutomaton.size();
    }

    public SLTLxVariableOccurrenceCollection getVariableUsage() {
        return this.varUsage;
    }

    @Override
    public void deleteTempFiles() throws IOException {
        try {
            Files.delete(this.cnfEncoding.toPath());
            Files.delete(this.satInputFile.toPath());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

