/*
 * Decompiled with CFR 0.152.
 */
package nl.uu.cs.ape.core.solutionStructure;

import nl.uu.cs.ape.core.solutionStructure.ModuleNode;
import nl.uu.cs.ape.core.solutionStructure.SolutionWorkflow;

public abstract class CWLCreatorBase {
    protected final StringBuilder cwlRepresentation;
    protected SolutionWorkflow solution;
    private IndentStyle indentStyle;

    protected CWLCreatorBase(SolutionWorkflow solution) {
        this.solution = solution;
        this.cwlRepresentation = new StringBuilder();
        this.indentStyle = IndentStyle.SPACES2;
    }

    public CWLCreatorBase setIndentStyle(IndentStyle indentStyle) {
        this.indentStyle = indentStyle;
        return this;
    }

    public abstract String getCWLVersion();

    public String generate() {
        this.generateTopComment();
        this.cwlRepresentation.append(String.format("cwlVersion: %s%n", this.getCWLVersion()));
        this.cwlRepresentation.append("class: Workflow").append("\n");
        this.cwlRepresentation.append("\n");
        this.cwlRepresentation.append("label: ").append(this.getWorkflowName()).append("\n");
        this.generateDoc();
        this.generateCWLRepresentation();
        return this.cwlRepresentation.toString();
    }

    protected void generateTopComment() {
        this.cwlRepresentation.append(String.format("# %s%n", this.getWorkflowName()));
        this.cwlRepresentation.append("# This workflow is generated by APE (https://github.com/sanctuuary/APE).\n");
    }

    private String getWorkflowName() {
        return String.format("WorkflowNo_%o", this.solution.getIndex());
    }

    private void generateDoc() {
        this.cwlRepresentation.append("doc: ");
        this.cwlRepresentation.append("A workflow including the tool(s) ");
        for (ModuleNode moduleNode : this.solution.getModuleNodes()) {
            this.cwlRepresentation.append(moduleNode.getNodeLabel()).append(", ");
        }
        this.deleteLastNCharactersFromCWL(2);
        this.cwlRepresentation.append(".").append("\n").append("\n");
    }

    protected abstract void generateCWLRepresentation();

    public String getCWL() {
        return this.cwlRepresentation.toString();
    }

    protected void deleteLastNCharactersFromCWL(int numberOfCharToDel) {
        this.cwlRepresentation.delete(this.cwlRepresentation.length() - numberOfCharToDel, this.cwlRepresentation.length());
    }

    protected String ind(int level) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < level; ++i) {
            builder.append((Object)this.indentStyle);
        }
        return builder.toString();
    }

    public static enum IndentStyle {
        SPACES2("  "),
        SPACES4("    ");

        private final String text;

        private IndentStyle(String s) {
            this.text = s;
        }

        public String toString() {
            return this.text;
        }
    }
}

