/*
 * Decompiled with CFR 0.152.
 */
package nl.uu.cs.ape.core.solutionStructure;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nl.uu.cs.ape.core.solutionStructure.CWLCreatorBase;
import nl.uu.cs.ape.core.solutionStructure.ModuleNode;
import nl.uu.cs.ape.core.solutionStructure.SolutionWorkflow;
import nl.uu.cs.ape.core.solutionStructure.TypeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class ExecutableCWLCreator
extends CWLCreatorBase {
    private static final Logger log = LoggerFactory.getLogger(ExecutableCWLCreator.class);
    private final HashMap<String, String> inputMap = new HashMap();
    private final HashMap<String, String> stepNames = new HashMap();
    private int stepIndex = 1;
    private final ArrayList<String> missingAnnotationMessages = new ArrayList();

    public ExecutableCWLCreator(SolutionWorkflow solution) {
        super(solution);
    }

    @Override
    public String getCWLVersion() {
        return "v1.0";
    }

    @Override
    protected void generateCWLRepresentation() {
        this.generateRequirements();
        this.cwlRepresentation.append("\n");
        this.generateInputs();
        int offset = this.cwlRepresentation.length();
        this.generateSteps();
        this.generateOutputs(offset);
        if (!this.missingAnnotationMessages.isEmpty()) {
            this.cwlRepresentation.delete(0, this.cwlRepresentation.length());
            this.generateTopComment();
            this.cwlRepresentation.append("\n");
            for (String message : this.missingAnnotationMessages) {
                this.cwlRepresentation.append("# ").append(message).append("\n");
                log.warn("Workflow {}: {}", (Object)this.solution.getIndex(), (Object)message);
            }
        }
    }

    private void generateRequirements() {
        this.cwlRepresentation.append("requirements:").append("\n").append(this.ind(1)).append("ShellCommandRequirement: {}").append("\n").append(this.ind(1)).append("InlineJavascriptRequirement: {}").append("\n");
    }

    private void generateInputs() {
        this.cwlRepresentation.append("inputs:").append("\n");
        LinkedHashMap<TypeNode, LinkedHashMap<String, String>> toAppend = new LinkedHashMap<TypeNode, LinkedHashMap<String, String>>();
        for (TypeNode inputState : this.solution.getWorkflowInputTypeStates()) {
            ModuleNode module = inputState.getUsedByModules().get(0);
            ArrayList<LinkedHashMap<String, String>> cwlInputs = module.getUsedModule().getCwlInputs();
            if (cwlInputs == null) {
                this.addMissingInput(module);
            }
            int index = 0;
            for (TypeNode t : module.getInputTypes()) {
                if (t.getNodeID().equals(inputState.getNodeID())) break;
                ++index;
            }
            toAppend.put(inputState, cwlInputs.get(index));
        }
        for (ModuleNode module : this.solution.getModuleNodes()) {
            ArrayList<LinkedHashMap<String, String>> cwlInputs = module.getUsedModule().getCwlInputs();
            if (cwlInputs == null) {
                this.addMissingInput(module);
            }
            if (!module.getInputTypes().isEmpty()) continue;
            for (int i = 0; i < module.getOutputTypes().size(); ++i) {
                TypeNode node = module.getOutputTypes().get(i);
                if (node.getUsedByModules().isEmpty() || cwlInputs.isEmpty()) continue;
                toAppend.put(node, cwlInputs.get(i));
            }
        }
        ArrayList<String> toReplace = new ArrayList<String>();
        HashMap<String, Integer> nameCounter = new HashMap<String, Integer>();
        Yaml yaml = new Yaml();
        for (Map.Entry entry : toAppend.entrySet()) {
            String inputName;
            String newName = inputName = this.getInputName(yaml.dump(entry.getValue()));
            if (nameCounter.containsKey(inputName)) {
                int count = (Integer)nameCounter.get(inputName);
                newName = newName + (count + 1);
                nameCounter.replace(inputName, count + 1);
            } else {
                newName = newName + 1;
                nameCounter.put(inputName, 1);
            }
            toReplace.add(newName);
            this.inputMap.put(((TypeNode)entry.getKey()).getNodeID(), newName);
        }
        HashMap appending = new HashMap();
        Object[] h = toAppend.values().toArray();
        int index = 0;
        for (Object obj : toAppend.values()) {
            LinkedHashMap entry = (LinkedHashMap)obj;
            Map.Entry e = (Map.Entry)entry.entrySet().toArray()[0];
            appending.put((String)toReplace.get(index), e.getValue());
            ++index;
        }
        this.appendYamlData(yaml.dump(appending), 1);
    }

    private void generateOutputs(int offset) {
        StringBuilder toInsert = new StringBuilder();
        for (TypeNode outputType : this.solution.getWorkflowOutputTypeStates()) {
            String name = this.inputMap.get(outputType.getNodeID());
            if (name == null) continue;
            toInsert.append("outputs:").append("\n").append(this.ind(1)).append("out:").append("\n").append(this.ind(2)).append("type: File").append("\n").append(this.ind(2)).append("outputSource: ").append(name).append("\n");
        }
        this.cwlRepresentation.insert(offset, toInsert);
    }

    private void generateSteps() {
        this.cwlRepresentation.append("steps:").append("\n");
        for (ModuleNode moduleNode : this.solution.getModuleNodes()) {
            Map<String, Object> implementation = moduleNode.getUsedModule().getCwlImplementation();
            if (implementation == null) {
                this.addMissingImplementation(moduleNode);
                ++this.stepIndex;
                continue;
            }
            String cwl = this.setStepName(moduleNode, implementation);
            String toAppend = this.connectStepInputs(moduleNode, cwl);
            this.findOutputs(moduleNode, cwl);
            this.appendYamlData(toAppend, 1);
            ++this.stepIndex;
        }
    }

    private String getInputName(String cwl) {
        Pattern pattern = Pattern.compile("\\\\@(\\w+)\\\\@");
        Matcher matcher = pattern.matcher(cwl);
        matcher.find();
        return matcher.group(1);
    }

    private String replaceInputName(String cwl, String old, String newName) {
        return cwl.replaceFirst(String.format("\\\\@%s\\\\@", old), newName);
    }

    private String setStepName(ModuleNode moduleNode, Map<String, Object> implementation) {
        String cwl = new Yaml().dump(implementation);
        Object[] keySet = implementation.keySet().toArray();
        for (int i = 0; i < keySet.length; ++i) {
            String key = (String)keySet[i];
            String newKey = key + this.stepIndex;
            cwl = cwl.replaceAll(key, newKey);
            if (i != keySet.length - 1) continue;
            this.stepNames.put(moduleNode.getNodeID(), newKey);
        }
        return cwl;
    }

    private String connectStepInputs(ModuleNode moduleNode, String cwl) {
        Pattern pattern = Pattern.compile("\\'\\\\\\@input\\[(\\d+)\\]\\'");
        Matcher matcher = pattern.matcher(cwl);
        List<TypeNode> inputs = moduleNode.getInputTypes();
        String result = cwl;
        while (matcher.find()) {
            String number = matcher.group(1);
            int index = Integer.parseInt(number);
            String newName = this.inputMap.get(inputs.get(index).getNodeID());
            if (newName == null) continue;
            result = result.replaceFirst(String.format("\\'\\\\\\@input\\[%s\\]\\'", number), newName);
        }
        return result;
    }

    private void findOutputs(ModuleNode moduleNode, String cwl) {
        Yaml yaml = new Yaml();
        LinkedHashMap code = (LinkedHashMap)yaml.load(cwl);
        Object[] entryList = code.entrySet().toArray();
        Map.Entry entry = (Map.Entry)entryList[entryList.length - 1];
        LinkedHashMap implementation = (LinkedHashMap)entry.getValue();
        ArrayList outputs = (ArrayList)implementation.get("out");
        int i = 0;
        for (TypeNode outputType : moduleNode.getOutputTypes()) {
            if (i >= outputs.size()) break;
            String outName = String.format("%s/%s", this.stepNames.get(moduleNode.getNodeID()), outputs.get(i));
            this.inputMap.put(outputType.getNodeID(), outName);
            ++i;
        }
    }

    private void appendYamlData(String data, int indentLevel) {
        for (String line : data.split("\\r?\\n")) {
            this.cwlRepresentation.append(this.ind(indentLevel)).append(line).append("\n");
        }
    }

    private void addMissingInput(ModuleNode moduleNode) {
        this.missingAnnotationMessages.add(String.format("Tool \"%s\" is missing its CWL inputs.", moduleNode.getNodeLabel()));
    }

    private void addMissingImplementation(ModuleNode moduleNode) {
        this.missingAnnotationMessages.add(String.format("Tool \"%s\" is missing its CWL implementation.", moduleNode.getNodeLabel()));
    }
}

