/*
 * Decompiled with CFR 0.152.
 */
package nl.uu.cs.ape.core.solutionStructure;

import guru.nidi.graphviz.engine.Format;
import guru.nidi.graphviz.engine.Graphviz;
import guru.nidi.graphviz.engine.Renderer;
import guru.nidi.graphviz.model.Factory;
import guru.nidi.graphviz.model.Graph;
import guru.nidi.graphviz.model.LinkSource;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import nl.uu.cs.ape.utils.APEUtils;

public class SolutionGraph {
    private Graph graph;

    SolutionGraph(Graph graph) {
        this.graph = graph;
    }

    public Renderer getPNGRenderer() {
        return Graphviz.fromGraph((Graph)this.graph).render(Format.PNG);
    }

    public BufferedImage getPNGImage(boolean debug) {
        Renderer renderer = this.getPNGRenderer();
        APEUtils.disableErr();
        BufferedImage image = renderer.toImage();
        APEUtils.enableErr();
        return image;
    }

    public void write2File(File file, boolean debug) throws IOException {
        Renderer renderer = this.getPNGRenderer();
        APEUtils.disableErr();
        renderer.toFile(file);
        APEUtils.enableErr();
    }

    public SolutionGraph changeTitle(String title) {
        this.graph = Factory.graph((String)title).with(new LinkSource[]{this.graph});
        return this;
    }
}

