/*
 * Decompiled with CFR 0.152.
 */
package nl.uu.cs.ape.core.solutionStructure;

import guru.nidi.graphviz.attribute.Attributes;
import guru.nidi.graphviz.attribute.Color;
import guru.nidi.graphviz.attribute.Label;
import guru.nidi.graphviz.attribute.LinkAttr;
import guru.nidi.graphviz.attribute.Rank;
import guru.nidi.graphviz.attribute.Shape;
import guru.nidi.graphviz.attribute.Style;
import guru.nidi.graphviz.model.Factory;
import guru.nidi.graphviz.model.Graph;
import guru.nidi.graphviz.model.LinkSource;
import guru.nidi.graphviz.model.LinkTarget;
import guru.nidi.graphviz.model.Node;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.uu.cs.ape.automaton.Block;
import nl.uu.cs.ape.automaton.ModuleAutomaton;
import nl.uu.cs.ape.automaton.State;
import nl.uu.cs.ape.automaton.TypeAutomaton;
import nl.uu.cs.ape.core.SolutionInterpreter;
import nl.uu.cs.ape.core.implSAT.SATSolution;
import nl.uu.cs.ape.core.implSAT.SATSynthesisEngine;
import nl.uu.cs.ape.core.solutionStructure.ModuleNode;
import nl.uu.cs.ape.core.solutionStructure.SolutionGraph;
import nl.uu.cs.ape.core.solutionStructure.SolutionWorkflowNode;
import nl.uu.cs.ape.core.solutionStructure.TypeNode;
import nl.uu.cs.ape.models.AbstractModule;
import nl.uu.cs.ape.models.AuxiliaryPredicate;
import nl.uu.cs.ape.models.Module;
import nl.uu.cs.ape.models.Type;
import nl.uu.cs.ape.models.enums.AtomType;
import nl.uu.cs.ape.models.enums.NodeType;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxLiteral;
import nl.uu.cs.ape.utils.APEUtils;

public class SolutionWorkflow {
    private static final String fileNamePrefix = "workflowSolution_";
    private List<ModuleNode> moduleNodes = new ArrayList<ModuleNode>();
    private List<TypeNode> workflowInputTypeStates = new ArrayList<TypeNode>();
    private List<TypeNode> workflowOutputTypeStates = new ArrayList<TypeNode>();
    private Map<State, ModuleNode> mappedModuleNodes = new HashMap<State, ModuleNode>();
    private Map<State, TypeNode> mappedMemoryTypeNodes = new HashMap<State, TypeNode>();
    private Map<State, ModuleNode> usedType2ToolMap = new HashMap<State, ModuleNode>();
    private SolutionInterpreter nativeSolution;
    private SolutionGraph dataflowGraph;
    private SolutionGraph controlflowGraph;
    private int index;

    private SolutionWorkflow(ModuleAutomaton toolAutomaton, TypeAutomaton typeAutomaton) throws ExceptionInInitializerError {
        ModuleNode prev = null;
        for (State currState : toolAutomaton.getAllStates()) {
            ModuleNode currNode = new ModuleNode(currState);
            currNode.setPrevModuleNode(prev);
            if (prev != null) {
                prev.setNextModuleNode(currNode);
            }
            this.moduleNodes.add(currNode);
            this.mappedModuleNodes.put(currState, currNode);
            prev = currNode;
        }
        for (Block currBlock : typeAutomaton.getMemoryTypesBlocks()) {
            ModuleNode typeGenerator = APEUtils.safeGet(this.moduleNodes, currBlock.getBlockNumber() - 1);
            for (State currState : currBlock.getStates()) {
                TypeNode currTypeNode = new TypeNode(currState);
                currTypeNode.setCreatedByModule(typeGenerator);
                if (typeGenerator != null) {
                    typeGenerator.addOutputType(currTypeNode);
                }
                this.mappedMemoryTypeNodes.put(currState, currTypeNode);
                if (currBlock.getBlockNumber() == 0) {
                    this.workflowInputTypeStates.add(currTypeNode);
                    continue;
                }
                if (currBlock.getBlockNumber() != toolAutomaton.size()) continue;
            }
        }
        for (Block currBlock : typeAutomaton.getUsedTypesBlocks()) {
            ModuleNode inputForTool = APEUtils.safeGet(this.moduleNodes, currBlock.getBlockNumber());
            for (State currState : currBlock.getStates()) {
                this.usedType2ToolMap.put(currState, inputForTool);
            }
        }
    }

    public SolutionWorkflow(int[] satSolution, SATSynthesisEngine synthesisInstance) {
        this(synthesisInstance.getModuleAutomaton(), synthesisInstance.getTypeAutomaton());
        this.nativeSolution = new SATSolution(satSolution, synthesisInstance);
        for (int mappedLiteral : satSolution) {
            SolutionWorkflowNode currNode;
            SLTLxLiteral currLiteral;
            if (mappedLiteral < synthesisInstance.getMappings().getInitialNumOfMappedAtoms() || (currLiteral = new SLTLxLiteral(Integer.toString(mappedLiteral), synthesisInstance.getMappings())).isNegated() || currLiteral.getPredicate() instanceof AuxiliaryPredicate || currLiteral.isWorkflowElementType(AtomType.USED_TYPE) && ((Type)currLiteral.getPredicate()).isSimplePredicate() || currLiteral.isWorkflowElementType(AtomType.R_RELATION)) continue;
            if (currLiteral.isWorkflowElementType(AtomType.MODULE)) {
                currNode = this.mappedModuleNodes.get(currLiteral.getUsedInStateArgument());
                if (currLiteral.getPredicate() instanceof Module) {
                    ((ModuleNode)currNode).setUsedModule((Module)currLiteral.getPredicate());
                    continue;
                }
                ((ModuleNode)currNode).addAbstractDescriptionOfUsedType((AbstractModule)currLiteral.getPredicate());
                continue;
            }
            if (currLiteral.isWorkflowElementType(AtomType.MEMORY_TYPE)) {
                currNode = this.mappedMemoryTypeNodes.get(currLiteral.getUsedInStateArgument());
                if (currLiteral.getPredicate() instanceof Type && ((Type)currLiteral.getPredicate()).isNodeType(NodeType.LEAF)) {
                    ((TypeNode)currNode).addUsedType((Type)currLiteral.getPredicate());
                    continue;
                }
                if (!(currLiteral.getPredicate() instanceof Type) || ((Type)currLiteral.getPredicate()).isNodeType(NodeType.EMPTY_LABEL)) continue;
                ((TypeNode)currNode).addAbstractDescriptionOfUsedType((Type)currLiteral.getPredicate());
                continue;
            }
            if (!currLiteral.isWorkflowElementType(AtomType.MEM_TYPE_REFERENCE) || ((State)currLiteral.getPredicate()).getAbsoluteStateNumber() == -1) continue;
            ModuleNode usedTypeNode = this.usedType2ToolMap.get(currLiteral.getUsedInStateArgument());
            TypeNode memoryTypeNode = this.mappedMemoryTypeNodes.get(currLiteral.getPredicate());
            int inputIndex = currLiteral.getUsedInStateArgument().getLocalStateNumber();
            if (usedTypeNode != null) {
                usedTypeNode.setInputType(inputIndex, memoryTypeNode);
            } else {
                APEUtils.safeSet(this.workflowOutputTypeStates, inputIndex, memoryTypeNode);
            }
            memoryTypeNode.addUsedByTool(usedTypeNode);
        }
        this.workflowInputTypeStates.removeIf(TypeNode::isEmpty);
        this.workflowOutputTypeStates.removeIf(TypeNode::isEmpty);
    }

    public List<ModuleNode> getModuleNodes() {
        return this.moduleNodes;
    }

    public List<TypeNode> getWorkflowInputTypeStates() {
        return this.workflowInputTypeStates;
    }

    public List<TypeNode> getWorkflowOutputTypeStates() {
        return this.workflowOutputTypeStates;
    }

    public SolutionInterpreter getNativeSolution() {
        return this.nativeSolution;
    }

    public SolutionGraph getDataflowGraph() {
        if (this.dataflowGraph != null) {
            return this.dataflowGraph;
        }
        return this.generateFieldDataflowGraph("", Rank.RankDir.TOP_TO_BOTTOM);
    }

    public SolutionGraph getDataflowGraph(String title, Rank.RankDir orientation) {
        if (this.dataflowGraph != null) {
            return this.dataflowGraph;
        }
        return this.generateFieldDataflowGraph(title, orientation);
    }

    public BufferedImage getDataflowGraphPNG(Rank.RankDir orientation) {
        if (this.dataflowGraph != null) {
            return this.dataflowGraph.getPNGImage(false);
        }
        return this.generateFieldDataflowGraph("", orientation).getPNGImage(false);
    }

    public SolutionGraph getControlflowGraph() {
        if (this.controlflowGraph != null) {
            return this.controlflowGraph;
        }
        return this.generateFieldControlflowGraph("", Rank.RankDir.TOP_TO_BOTTOM);
    }

    public SolutionGraph getControlflowGraph(String title, Rank.RankDir orientation) {
        if (this.controlflowGraph != null) {
            return this.controlflowGraph;
        }
        return this.generateFieldControlflowGraph(title, orientation);
    }

    public static String getFileNamePrefix() {
        return fileNamePrefix;
    }

    public String getFileName() {
        Object[] objectArray = new Object[2];
        objectArray[0] = fileNamePrefix;
        objectArray[1] = this.getIndex();
        return String.format("%s%o", objectArray);
    }

    public BufferedImage getControlflowGraphPNG(Rank.RankDir orientation) {
        if (this.controlflowGraph != null) {
            return this.controlflowGraph.getPNGImage(false);
        }
        return this.generateFieldControlflowGraph("", orientation).getPNGImage(false);
    }

    public String getReadableSolution() {
        StringBuilder solution = new StringBuilder();
        solution.append("WORKFLOW_IN:{");
        int i = 0;
        for (TypeNode workflowInput : this.workflowInputTypeStates) {
            solution.append(workflowInput.toString());
            if (++i >= this.workflowInputTypeStates.size()) continue;
            solution.append(", ");
        }
        solution.append("} |");
        for (ModuleNode currTool : this.moduleNodes) {
            solution.append(" IN:{");
            i = 0;
            for (TypeNode toolInput : currTool.getInputTypes()) {
                if (toolInput.isEmpty()) continue;
                if (i++ > 1) {
                    solution.append(", ");
                }
                solution.append(toolInput.toString());
            }
            solution.append("} ").append(currTool.toString());
            solution.append(" OUT:{");
            i = 0;
            for (TypeNode toolOutput : currTool.getOutputTypes()) {
                if (toolOutput.isEmpty()) continue;
                if (i++ > 1) {
                    solution.append(", ");
                }
                solution.append(toolOutput.toString());
            }
            solution.append("} |");
        }
        i = 0;
        solution.append("WORKFLOW_OUT:{");
        for (TypeNode workflowOutput : this.workflowOutputTypeStates) {
            solution.append(workflowOutput.toString());
            if (++i >= this.workflowOutputTypeStates.size()) continue;
            solution.append(", ");
        }
        solution.append("}");
        return solution.toString();
    }

    public String getSolutionDotFormat() {
        StringBuilder solution = new StringBuilder();
        String input = "\"Workflow INPUT\"";
        String output = "\"Workflow OUTPUT\"";
        boolean inputDefined = false;
        boolean outputDefined = false;
        for (TypeNode workflowInput : this.workflowInputTypeStates) {
            if (!inputDefined) {
                solution.append(input + " [shape=box, color = red];\n");
                inputDefined = true;
            }
            solution.append(input + "->" + workflowInput.getNodeID() + ";\n");
            solution.append(workflowInput.getDotDefinition());
        }
        for (ModuleNode currTool : this.moduleNodes) {
            solution.append(currTool.getDotDefinition());
            for (TypeNode toolInput : currTool.getInputTypes()) {
                if (toolInput.isEmpty()) continue;
                solution.append(toolInput.getNodeID() + "->" + currTool.getNodeID() + "[label = in, fontsize = 10];\n");
            }
            for (TypeNode toolOutput : currTool.getOutputTypes()) {
                if (toolOutput.isEmpty()) continue;
                solution.append(toolOutput.getDotDefinition());
                solution.append(currTool.getNodeID() + "->" + toolOutput.getNodeID() + " [label = out, fontsize = 10];\n");
            }
        }
        for (TypeNode workflowOutput : this.workflowOutputTypeStates) {
            if (!outputDefined) {
                solution.append(output + " [shape=box, color = red];\n");
                outputDefined = true;
            }
            solution.append(workflowOutput.getDotDefinition());
            solution.append(workflowOutput.getNodeID() + "->" + output + ";\n");
        }
        return solution.toString();
    }

    private SolutionGraph generateFieldDataflowGraph(String title, Rank.RankDir orientation) {
        Graph workflowGraph = Factory.graph((String)title).directed();
        if (orientation != Rank.RankDir.TOP_TO_BOTTOM) {
            workflowGraph = (Graph)workflowGraph.graphAttr().with((Attributes)Rank.dir((Rank.RankDir)orientation));
        }
        String input = "Workflow INPUT     ";
        String output = "Workflow OUTPUT     ";
        boolean inputDefined = false;
        boolean outputDefined = false;
        int index = 0;
        int workflowInNo = 1;
        for (TypeNode workflowInput : this.workflowInputTypeStates) {
            if (!inputDefined) {
                workflowGraph = workflowGraph.with(new LinkSource[]{(LinkSource)Factory.node((String)input).with((Attributes)Color.RED, (Attributes)Shape.RECTANGLE, (Attributes)Style.BOLD)});
                inputDefined = true;
            }
            workflowGraph = workflowInput.addTypeToGraph(workflowGraph);
            workflowGraph = workflowGraph.with(new LinkSource[]{Factory.node((String)input).link(new LinkTarget[]{(LinkTarget)Factory.to((Node)Factory.node((String)workflowInput.getNodeID())).with((Attributes)Label.of((String)(workflowInNo++ + "  ")), LinkAttr.weight((double)index++), (Attributes)Style.DOTTED)})});
        }
        for (ModuleNode currTool : this.moduleNodes) {
            workflowGraph = currTool.addModuleToGraph(workflowGraph);
            int inputNo = 1;
            for (TypeNode toolInput : currTool.getInputTypes()) {
                if (toolInput.isEmpty()) continue;
                workflowGraph = workflowGraph.with(new LinkSource[]{Factory.node((String)toolInput.getNodeID()).link(new LinkTarget[]{(LinkTarget)Factory.to((Node)Factory.node((String)currTool.getNodeID())).with((Attributes)Label.of((String)("in " + inputNo++ + "  ")), (Attributes)Color.ORANGE, LinkAttr.weight((double)index++))})});
            }
            int outputNo = 1;
            for (TypeNode toolOutput : currTool.getOutputTypes()) {
                if (toolOutput.isEmpty()) continue;
                workflowGraph = toolOutput.addTypeToGraph(workflowGraph);
                workflowGraph = workflowGraph.with(new LinkSource[]{Factory.node((String)currTool.getNodeID()).link(new LinkTarget[]{(LinkTarget)Factory.to((Node)Factory.node((String)toolOutput.getNodeID())).with((Attributes)Label.of((String)("out " + outputNo++ + "  ")), LinkAttr.weight((double)index++))})});
            }
        }
        int workflowOutNo = 1;
        for (TypeNode workflowOutput : this.workflowOutputTypeStates) {
            if (!outputDefined) {
                workflowGraph = workflowGraph.with(new LinkSource[]{(LinkSource)Factory.node((String)output).with((Attributes)Color.RED, (Attributes)Shape.RECTANGLE, (Attributes)Style.BOLD)});
                outputDefined = true;
            }
            workflowGraph = workflowOutput.addTypeToGraph(workflowGraph);
            workflowGraph = workflowGraph.with(new LinkSource[]{Factory.node((String)workflowOutput.getNodeID()).link(new LinkTarget[]{(LinkTarget)Factory.to((Node)Factory.node((String)output)).with((Attributes)Label.of((String)(workflowOutNo++ + "  ")), LinkAttr.weight((double)index++), (Attributes)Style.DOTTED)})});
        }
        this.dataflowGraph = new SolutionGraph(workflowGraph);
        return this.dataflowGraph;
    }

    private SolutionGraph generateFieldControlflowGraph(String title, Rank.RankDir orientation) {
        Graph workflowGraph = (Graph)Factory.graph((String)title).directed().graphAttr().with((Attributes)Rank.dir((Rank.RankDir)orientation));
        String input = "START     ";
        String output = "END     ";
        workflowGraph = workflowGraph.with(new LinkSource[]{(LinkSource)Factory.node((String)input).with((Attributes)Color.BLACK, (Attributes)Style.BOLD)});
        String prevNode = input;
        for (ModuleNode currTool : this.moduleNodes) {
            workflowGraph = currTool.addModuleToGraph(workflowGraph);
            workflowGraph = workflowGraph.with(new LinkSource[]{Factory.node((String)prevNode).link(new LinkTarget[]{(LinkTarget)Factory.to((Node)Factory.node((String)currTool.getNodeID())).with((Attributes)Label.of((String)"next   "), (Attributes)Color.RED)})});
            prevNode = currTool.getNodeID();
        }
        workflowGraph = workflowGraph.with(new LinkSource[]{(LinkSource)Factory.node((String)output).with((Attributes)Color.BLACK, (Attributes)Style.BOLD)});
        workflowGraph = workflowGraph.with(new LinkSource[]{Factory.node((String)prevNode).link(new LinkTarget[]{(LinkTarget)Factory.to((Node)Factory.node((String)output)).with((Attributes)Label.of((String)"next   "), (Attributes)Color.RED)})});
        this.controlflowGraph = new SolutionGraph(workflowGraph);
        return this.controlflowGraph;
    }

    public int getSolutionLength() {
        return this.moduleNodes.size();
    }

    public void setIndex(int i) {
        this.index = i;
    }

    public int getIndex() {
        return this.index;
    }

    public String getScriptExecution() {
        StringBuffer script = new StringBuffer("#!/bin/bash\n");
        script.append("if [ $# -ne " + this.workflowInputTypeStates.size() + " ]\n\tthen\n");
        script.append("\t\techo \"" + this.workflowInputTypeStates.size() + " argument(s) expected.\"\n\t\texit\nfi\n");
        int in = 1;
        for (TypeNode input : this.workflowInputTypeStates) {
            script.append(input.getShortNodeID() + "=$" + in++ + "\n");
        }
        script.append("\n");
        for (ModuleNode operation : this.moduleNodes) {
            int i;
            String code = operation.getUsedModule().getExecutionCode();
            if (code == null || code.equals("")) {
                script.append("\"Error. Tool '" + operation.getNodeLabel() + "' is missing the execution code.\"").append("\n");
                continue;
            }
            for (i = 0; i < operation.getInputTypes().size(); ++i) {
                code = code.replace("@input[" + i + "]", operation.getInputTypes().get(i).getShortNodeID());
            }
            for (i = 0; i < operation.getOutputTypes().size(); ++i) {
                code = code.replace("@output[" + i + "]", operation.getOutputTypes().get(i).getShortNodeID());
            }
            script.append(code).append("\n");
        }
        int out = 1;
        for (TypeNode output : this.workflowOutputTypeStates) {
            script.append("echo \"" + out++ + ". output is: $" + output.getShortNodeID() + "\"");
        }
        return script.toString();
    }
}

