/*
 * Decompiled with CFR 0.152.
 */
package nl.uu.cs.ape.core.solutionStructure;

import guru.nidi.graphviz.attribute.Attributes;
import guru.nidi.graphviz.attribute.Label;
import guru.nidi.graphviz.model.Factory;
import guru.nidi.graphviz.model.Graph;
import guru.nidi.graphviz.model.LinkSource;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import nl.uu.cs.ape.automaton.State;
import nl.uu.cs.ape.core.solutionStructure.ModuleNode;
import nl.uu.cs.ape.core.solutionStructure.SolutionWorkflowNode;
import nl.uu.cs.ape.models.Type;
import nl.uu.cs.ape.models.enums.AtomType;
import nl.uu.cs.ape.utils.APEUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeNode
extends SolutionWorkflowNode {
    private static final Logger log = LoggerFactory.getLogger(TypeNode.class);
    private SortedSet<Type> usedTypes = new TreeSet<Type>();
    private SortedSet<Type> abstractTypes = new TreeSet<Type>();
    private ModuleNode createdByModule = null;
    private List<ModuleNode> usedByModules = new ArrayList<ModuleNode>();

    public TypeNode(State automatonState) throws ExceptionInInitializerError {
        super(automatonState);
        if (automatonState.getWorkflowStateType() != AtomType.MEMORY_TYPE) {
            throw new ExceptionInInitializerError("Class MemTypeNode can only be instantiated using State that is of type AtomType.MEMORY_TYPE, as a parameter.");
        }
    }

    public void addUsedType(Type simpleType) {
        if (simpleType.isSimplePredicate()) {
            this.usedTypes.add(simpleType);
        } else {
            log.warn("Abstract and Empty Type cannot be used to define an instance.");
        }
    }

    public void addAbstractDescriptionOfUsedType(Type abstractType) {
        if (!abstractType.isSimplePredicate()) {
            this.abstractTypes.add(abstractType);
        } else {
            log.warn("Simple Type cannot be used to describe an instance.");
        }
    }

    public void addUsedByTool(ModuleNode usedByTool) {
        this.usedByModules.add(usedByTool);
    }

    public void setCreatedByModule(ModuleNode createdByModule) {
        this.createdByModule = createdByModule;
    }

    public SortedSet<Type> getTypes() {
        return this.usedTypes;
    }

    public SortedSet<Type> getAbstractTypes() {
        return this.abstractTypes;
    }

    public ModuleNode getCreatedByModule() {
        return this.createdByModule;
    }

    public List<ModuleNode> getUsedByModules() {
        return this.usedByModules;
    }

    public boolean isEmpty() {
        return this.usedTypes.isEmpty();
    }

    public String toString() {
        StringBuilder printString = new StringBuilder();
        printString.append("[");
        int i = 0;
        for (Type type : this.usedTypes) {
            printString.append(type.getPredicateID());
            if (++i >= this.usedTypes.size()) continue;
            printString.append(", ");
        }
        printString.append(" (" + super.getAutomatonState().getPredicateID() + ")]");
        return printString.toString();
    }

    public String getDotDefinition() {
        return this.getNodeID() + " [label=\"" + this.getNodeLabel() + "\", color=blue];\n";
    }

    public Graph addTypeToGraph(Graph workflowGraph) {
        return workflowGraph.with(new LinkSource[]{(LinkSource)Factory.node((String)this.getNodeID()).with((Attributes)Label.of((String)(this.getNodeLabel() + "   ")))});
    }

    @Override
    public String getNodeLabel() {
        StringBuilder printString = new StringBuilder();
        int i = 0;
        for (Type type : this.usedTypes) {
            String typeLabel = type.getPredicateLabel();
            if (typeLabel.endsWith("_p")) {
                typeLabel = APEUtils.removeNLastChar(typeLabel, 2);
            }
            printString.append(typeLabel);
            if (++i >= this.usedTypes.size()) continue;
            printString.append(", ");
        }
        return printString.toString();
    }

    @Override
    public String getNodeID() {
        StringBuilder printString = new StringBuilder("\"");
        int i = 0;
        for (Type type : this.usedTypes) {
            printString.append(type.getPredicateID());
            if (++i >= this.usedTypes.size()) continue;
            printString.append(",");
        }
        printString.append("[").append(super.getAutomatonState().getPredicateID()).append("]").append("\"");
        return printString.toString();
    }

    public String getFormat() {
        StringBuilder printString = new StringBuilder();
        for (Type type : this.usedTypes) {
            if (!type.getRootNodeID().equals("http://edamontology.org/format_1915")) continue;
            printString.append("\"").append(type.getPredicateLongLabel()).append("\" # ").append(type.getPredicateLabel());
        }
        if (printString.length() == 0) {
            printString.append("\"unknown\"");
        }
        return printString.toString();
    }

    @Override
    public String getNodeLongLabel() {
        StringBuilder printString = new StringBuilder();
        int i = 0;
        for (Type type : this.usedTypes) {
            String typeLabel = type.getPredicateLongLabel();
            printString.append(typeLabel);
            if (++i >= this.usedTypes.size()) continue;
            printString.append(", ");
        }
        return printString.toString();
    }

    public String getShortNodeID() {
        return "node" + Math.abs(this.getNodeID().hashCode());
    }
}

