/*
 * Decompiled with CFR 0.152.
 */
package nl.uu.cs.ape.io;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Scanner;
import java.util.Set;
import nl.uu.cs.ape.configuration.APEConfigException;
import nl.uu.cs.ape.models.sltlxStruc.CNFClause;
import nl.uu.cs.ape.utils.APEUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class APEFiles {
    private static final Logger log = LoggerFactory.getLogger(APEFiles.class);

    private static Path getLocalPath(String tag, String path) {
        if (path == null) {
            throw APEConfigException.invalidValue(tag, "null", "value is null.");
        }
        if (path.equals("")) {
            throw APEConfigException.invalidValue(tag, path, "value is empty.");
        }
        try {
            return Paths.get(path, new String[0]);
        }
        catch (NullPointerException | InvalidPathException e) {
            throw APEConfigException.invalidValue(tag, path, String.format("The path for tag '%s' is invalid. %s", tag, e.getMessage()));
        }
    }

    public static boolean localPathExists(String path) {
        Path localPath = Paths.get(path, new String[0]);
        return Files.exists(localPath, new LinkOption[0]);
    }

    public static boolean validPathFormat(String path) {
        return APEFiles.validLocalPathFormat(path) || APEFiles.isURI(path);
    }

    public static boolean validLocalPathFormat(String path) {
        try {
            Paths.get(path, new String[0]);
            return true;
        }
        catch (NullPointerException | InvalidPathException e) {
            return false;
        }
    }

    public static File readFileFromPath(String tag, String inputPath, Permission ... requestedPermissions) throws IOException, JSONException, APEConfigException {
        Path path = APEFiles.getLocalPath(tag, inputPath);
        if (Files.notExists(path, new LinkOption[0])) {
            throw APEConfigException.pathNotFound(tag, inputPath);
        }
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            throw APEConfigException.notAFile(tag, inputPath);
        }
        APEFiles.checkPermissions(tag, path, requestedPermissions);
        return path.toFile();
    }

    public static Path readDirectoryPath(String tag, String inputPath, Permission ... requestedPermissions) throws IOException, JSONException, APEConfigException {
        Path path = APEFiles.getLocalPath(tag, inputPath);
        String absolutePath = path.toAbsolutePath().toString();
        if (!APEFiles.isFolderFormat(path)) {
            throw APEConfigException.notADirectory(tag, absolutePath);
        }
        APEFiles.createDirectory(tag, path);
        if (!APEFiles.directoryExists(path)) {
            throw APEConfigException.notADirectory(tag, absolutePath);
        }
        try {
            APEFiles.checkPermissions(tag, path, requestedPermissions);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return path.toAbsolutePath();
    }

    private static void createDirectory(String tag, Path path) throws APEConfigException {
        if (Files.notExists(path, new LinkOption[0])) {
            String absolutePath = path.toAbsolutePath().toString();
            if (!APEFiles.isFolderFormat(path)) {
                throw new APEConfigException("Path '" + absolutePath + "' for tag '" + tag + "' is not a directory!");
            }
            APEUtils.printWarning(absolutePath + "' does not exist. Directory will be created.", new Object[0]);
            if (new File(absolutePath).mkdirs()) {
                log.debug("Successfully created directory '" + absolutePath + "'");
            } else {
                throw new APEConfigException("Could not create directory '" + absolutePath + "' for tag '" + tag + "'");
            }
        }
    }

    public static void checkPermissions(String tag, Path path, Permission ... requestedPermissions) throws IOException {
        if (Arrays.stream(requestedPermissions).anyMatch(p -> p == Permission.READ) && !Files.isReadable(path)) {
            throw APEConfigException.missingPermission(tag, path.toString(), (Object)Permission.READ);
        }
        if (Arrays.stream(requestedPermissions).anyMatch(p -> p == Permission.WRITE) && !Files.isWritable(path)) {
            throw APEConfigException.missingPermission(tag, path.toString(), (Object)Permission.WRITE);
        }
    }

    public static boolean isFolderFormat(Path path) {
        return FilenameUtils.getExtension((String)path.toString()).equals("");
    }

    public static boolean isFileFormat(Path path) {
        return !APEFiles.isFolderFormat(path);
    }

    public static boolean directoryExists(Path path) {
        return Files.isDirectory(path, new LinkOption[0]);
    }

    public static boolean isJSON(JSONObject jsonObject) {
        return jsonObject != null;
    }

    public static boolean isJSONArray(JSONArray jsonArray) {
        return jsonArray != null;
    }

    public static boolean isURI(String uri) {
        try {
            new URL(uri).toURI();
            return true;
        }
        catch (MalformedURLException | URISyntaxException e1) {
            return false;
        }
    }

    public static File readPathToFile(String filePath) throws IOException {
        return APEFiles.isURI(filePath) ? APEFiles.readURLToFile(filePath) : new File(filePath);
    }

    private static File readURLToFile(String fileUrl) throws IOException {
        File loadedFile = File.createTempFile("ape_temp_", "");
        FileUtils.copyURLToFile((URL)new URL(fileUrl), (File)loadedFile, (int)10000, (int)10000);
        return loadedFile;
    }

    public static void appendToFile(File file, String content) throws IOException, NullPointerException {
        FileWriterWithEncoding fileWriter = new FileWriterWithEncoding(file, "ASCII", true);
        try (BufferedWriter writer = new BufferedWriter((Writer)fileWriter, 32768);){
            writer.write(content);
        }
    }

    public static void appendSetToFile(File file, Set<String> content) throws IOException, NullPointerException {
        FileWriterWithEncoding fileWriter = new FileWriterWithEncoding(file, "ASCII", true);
        try (BufferedWriter writer = new BufferedWriter((Writer)fileWriter, 32768);){
            for (String str : content) {
                writer.write(str);
            }
        }
    }

    public static void appendToFile(File file, Set<CNFClause> cnfEncoding) throws IOException, NullPointerException {
        StringBuilder string = new StringBuilder();
        cnfEncoding.forEach(clause -> string.append(clause.toCNF()));
        FileWriterWithEncoding fileWriter = new FileWriterWithEncoding(file, "ASCII", true);
        try (BufferedWriter writer = new BufferedWriter((Writer)fileWriter, 32768);){
            writer.write(string.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File prependToFile(String prefix, File file) throws IOException {
        LineIterator li = FileUtils.lineIterator((File)file);
        File tempFile = File.createTempFile("prependPrefix", ".tmp");
        tempFile.deleteOnExit();
        FileWriterWithEncoding fileWriter = new FileWriterWithEncoding(tempFile, "ASCII", true);
        BufferedWriter writer = new BufferedWriter((Writer)fileWriter);
        try {
            writer.write(prefix);
            while (li.hasNext()) {
                writer.write(li.next());
                writer.write("\n");
            }
        }
        finally {
            writer.close();
            li.close();
        }
        return tempFile;
    }

    public static boolean isValidReadFile(String path) {
        if (path == null || path.equals("")) {
            log.error("Path is not provided correctly.");
            return false;
        }
        File f = new File(path);
        if (!f.isFile()) {
            log.error("Provided path: \"" + path + "\" is not a file.");
            return false;
        }
        if (!f.canRead()) {
            log.error("Provided file: \"" + path + "\" is missing the reading permission.");
            return false;
        }
        return true;
    }

    public static boolean write2file(String text, File file, boolean append) throws IOException {
        try (FileWriter fw = new FileWriter(file, append);){
            fw.write(text);
        }
        return true;
    }

    public static boolean write2file(InputStream tempSatInput, File file, Boolean append) throws IOException {
        StringBuilder humanReadable = new StringBuilder();
        Scanner scanner = new Scanner(tempSatInput);
        while (scanner.hasNextLine()) {
            String str = scanner.nextLine();
            humanReadable.append(str).append("\n");
        }
        scanner.close();
        return APEFiles.write2file(humanReadable.toString(), file, (boolean)append);
    }

    public static JSONObject readPathToJSONObject(String path) throws IOException, JSONException {
        File file = APEFiles.readPathToFile(path);
        return APEFiles.readFileToJSONObject(file);
    }

    public static JSONObject readFileToJSONObject(File file) throws IOException, JSONException {
        String content = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
        return new JSONObject(content);
    }

    public static JSONArray readFileToJSONArray(File file) throws IOException, JSONException {
        String content = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
        return new JSONArray(content);
    }

    public static enum Permission {
        READ,
        WRITE;

    }
}

