/*
 * Decompiled with CFR 0.152.
 */
package nl.uu.cs.ape.models;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import nl.uu.cs.ape.models.logic.constructs.TaxonomyPredicate;
import nl.uu.cs.ape.utils.APEUtils;

public abstract class AllPredicates {
    private Map<String, TaxonomyPredicate> mappedPredicates;
    private List<String> dimensionRoots;

    protected AllPredicates(List<String> taxonomyRoots) {
        this.dimensionRoots = taxonomyRoots;
        this.mappedPredicates = new HashMap<String, TaxonomyPredicate>();
    }

    public List<TaxonomyPredicate> getRootPredicates() {
        ArrayList<TaxonomyPredicate> rootPredicates = new ArrayList<TaxonomyPredicate>();
        for (String rootID : this.dimensionRoots) {
            rootPredicates.add(this.get(rootID));
        }
        return rootPredicates;
    }

    public List<String> getAllRootIDs() {
        return this.dimensionRoots;
    }

    public abstract TaxonomyPredicate addPredicate(TaxonomyPredicate var1) throws ExceptionInInitializerError;

    public abstract Class<?> getPredicateClass();

    public boolean trimTaxonomy() {
        for (TaxonomyPredicate root : this.getRootPredicates()) {
            ArrayList<TaxonomyPredicate> toRemove = new ArrayList<TaxonomyPredicate>();
            for (TaxonomyPredicate subClass : APEUtils.safe(root.getSubPredicates())) {
                if (subClass == null) continue;
                if (subClass.getIsRelevant()) {
                    this.trimSubTaxonomy(subClass);
                    continue;
                }
                toRemove.add(subClass);
                this.trimSubTaxonomy(subClass);
            }
            root.removeAllSubPredicates(toRemove);
        }
        return true;
    }

    public boolean trimSubTaxonomy(TaxonomyPredicate subTaxRoot) {
        if (subTaxRoot == null) {
            return true;
        }
        ArrayList<TaxonomyPredicate> toRemove = new ArrayList<TaxonomyPredicate>();
        for (TaxonomyPredicate subClass : APEUtils.safe(subTaxRoot.getSubPredicates())) {
            if (subClass == null) continue;
            if (subClass.getIsRelevant()) {
                this.trimSubTaxonomy(subClass);
                continue;
            }
            toRemove.add(subClass);
            this.trimSubTaxonomy(subClass);
        }
        if (!subTaxRoot.getIsRelevant()) {
            this.mappedPredicates.remove(subTaxRoot.getPredicateID());
        }
        subTaxRoot.removeAllSubPredicates(toRemove);
        return true;
    }

    protected Map<String, TaxonomyPredicate> getMappedPredicates() {
        return this.mappedPredicates;
    }

    public TaxonomyPredicate get(String predicateID) {
        return this.mappedPredicates.get(predicateID);
    }

    public SortedSet<TaxonomyPredicate> getElementsFromSubTaxonomy(TaxonomyPredicate subTreeRoot) throws NullPointerException {
        if (subTreeRoot == null) {
            throw new NullPointerException("Given sub-taxonomy type cannot be null.");
        }
        TreeSet<TaxonomyPredicate> elements = new TreeSet<TaxonomyPredicate>();
        elements.add(subTreeRoot);
        for (TaxonomyPredicate subType : APEUtils.safe(subTreeRoot.getSubPredicates())) {
            elements.addAll(this.getElementsFromSubTaxonomy(subType));
        }
        return elements;
    }

    public boolean existsRoot(String curRootIRI) {
        return this.dimensionRoots.contains(curRootIRI);
    }

    public void put(String key, TaxonomyPredicate value) {
        this.mappedPredicates.put(key, value);
    }

    public void remove(String predicateID) {
        this.mappedPredicates.remove(predicateID);
    }
}

