/*
 * Decompiled with CFR 0.152.
 */
package nl.uu.cs.ape.models;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nl.uu.cs.ape.configuration.APECoreConfig;
import nl.uu.cs.ape.models.AllPredicates;
import nl.uu.cs.ape.models.Pair;
import nl.uu.cs.ape.models.Type;
import nl.uu.cs.ape.models.enums.NodeType;
import nl.uu.cs.ape.models.logic.constructs.PredicateLabel;
import nl.uu.cs.ape.models.logic.constructs.TaxonomyPredicate;
import nl.uu.cs.ape.utils.APEDimensionsException;
import nl.uu.cs.ape.utils.APEUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllTypes
extends AllPredicates {
    private static final Logger log = LoggerFactory.getLogger(AllTypes.class);
    private static String empty = "empty";
    private static String apeLabel = "APE_label";
    private static String emptyLabel = "emptyLabel";
    private Type emptyType = new Type(empty, empty, empty, NodeType.EMPTY);
    private Type apeLabelRoot = new Type(apeLabel, apeLabel, apeLabel, NodeType.ROOT);
    private Type emptyLabelType = new Type(emptyLabel, emptyLabel, apeLabel, NodeType.EMPTY_LABEL);

    public AllTypes(APECoreConfig config) {
        super(Stream.concat(config.getDataDimensionRoots().stream(), Stream.of(apeLabel)).collect(Collectors.toList()));
        this.setRelevant(this.emptyType);
        this.setRelevant(this.apeLabelRoot);
        this.setRelevant(this.emptyLabelType);
        this.apeLabelRoot.addSubPredicate(this.emptyLabelType);
        this.emptyLabelType.addSuperPredicate(this.apeLabelRoot);
    }

    public AllTypes(List<String> typeTaxonomyRoots) {
        super(Stream.concat(typeTaxonomyRoots.stream(), Stream.of(apeLabel)).collect(Collectors.toList()));
        this.setRelevant(this.emptyType);
        this.setRelevant(this.apeLabelRoot);
        this.setRelevant(this.emptyLabelType);
        this.apeLabelRoot.addSubPredicate(this.emptyLabelType);
        this.emptyLabelType.addSuperPredicate(this.apeLabelRoot);
    }

    private void setRelevant(Type type) {
        type.setAsRelevantTaxonomyTerm(this);
        this.getMappedPredicates().put(type.getPredicateID(), type);
    }

    public Collection<? extends TaxonomyPredicate> getTypes() {
        return this.getMappedPredicates().values();
    }

    private Type put(Type type) {
        Type tmpType = this.get(type.getPredicateID(), type.getRootNodeID());
        if (tmpType != null) {
            return tmpType;
        }
        this.getMappedPredicates().put(type.getPredicateID(), type);
        return type;
    }

    @Override
    public Type addPredicate(TaxonomyPredicate newType) throws ExceptionInInitializerError {
        Type tmpType = this.get(newType.getPredicateID(), newType.getRootNodeID());
        if (tmpType == null) {
            if (newType instanceof Type) {
                this.put((Type)newType);
                tmpType = (Type)newType;
            } else {
                throw new ExceptionInInitializerError(String.format("Type error. Only 'Type' StateInterface can be added to the set of all types. '%s' is not a type", newType.getPredicateID()));
            }
        }
        return tmpType;
    }

    public Type get(String predicateID, String dimensionID) throws APEDimensionsException {
        Type predicate = (Type)this.get(predicateID);
        if (predicate != null && predicate.getRootNodeID().equals(dimensionID)) {
            return predicate;
        }
        return null;
    }

    public Type getEmptyType() {
        return this.emptyType;
    }

    public boolean existsType(Type type) {
        return this.getMappedPredicates().containsKey(type.getPredicateID());
    }

    public boolean existsType(String typeID) {
        return this.getMappedPredicates().containsKey(typeID);
    }

    @Override
    public boolean existsRoot(String dimensionID) {
        return this.getAllRootIDs().contains(dimensionID);
    }

    public int size() {
        return this.getMappedPredicates().size();
    }

    @Override
    public Class<?> getPredicateClass() {
        return Type.class;
    }

    public List<Pair<PredicateLabel>> getTypePairsForEachSubTaxonomy() {
        ArrayList<Pair<PredicateLabel>> pairs = new ArrayList<Pair<PredicateLabel>>();
        HashMap subTreesMap = new HashMap();
        for (String subRoot : APEUtils.safe(this.getAllRootIDs())) {
            subTreesMap.put(subRoot, new ArrayList());
        }
        for (TaxonomyPredicate type : this.getMappedPredicates().values()) {
            if (type.isSimplePredicate()) {
                if (subTreesMap.get(type.getRootNodeID()) != null) {
                    ((List)subTreesMap.get(type.getRootNodeID())).add(type);
                    continue;
                }
                log.error("Type " + type.getPredicateID() + " has no root node");
                continue;
            }
            if (!type.isEmptyPredicate()) continue;
            this.getDataTaxonomyDimensionIDs().stream().forEach(dimensionID -> ((List)subTreesMap.get(dimensionID)).add(type));
        }
        for (List iterator : subTreesMap.values()) {
            for (int i = 0; i < iterator.size() - 1; ++i) {
                for (int j = i + 1; j < iterator.size(); ++j) {
                    pairs.add(new Pair<PredicateLabel>((PredicateLabel)iterator.get(i), (PredicateLabel)iterator.get(j)));
                }
            }
        }
        return pairs;
    }

    public List<String> getDataTaxonomyDimensionIDs() {
        ArrayList<String> taxonomyRoot = new ArrayList<String>();
        for (String dimension : this.getAllRootIDs()) {
            if (dimension.equals(this.getLabelRootID())) continue;
            taxonomyRoot.add(dimension);
        }
        return taxonomyRoot;
    }

    public List<TaxonomyPredicate> getDataTaxonomyDimensions() {
        ArrayList<TaxonomyPredicate> dimensionTypes = new ArrayList<TaxonomyPredicate>();
        this.getDataTaxonomyDimensionIDs().stream().filter(dimensionID -> this.get((String)dimensionID) != null).forEach(dimensionID -> dimensionTypes.add(this.get((String)dimensionID)));
        return dimensionTypes;
    }

    public List<TaxonomyPredicate> getDataTaxonomyDimensionsAndLabel() {
        ArrayList<TaxonomyPredicate> dimensionTypes = new ArrayList<TaxonomyPredicate>();
        this.getDataTaxonomyDimensionIDs().stream().filter(dimensionID -> this.get((String)dimensionID) != null).forEach(dimensionID -> dimensionTypes.add(this.get((String)dimensionID)));
        dimensionTypes.add(this.apeLabelRoot);
        return dimensionTypes;
    }

    public SortedSet<TaxonomyPredicate> getDataTaxonomyDimensionsAsSortedSet() {
        TreeSet<TaxonomyPredicate> dimensionTypes = new TreeSet<TaxonomyPredicate>();
        this.getDataTaxonomyDimensionIDs().stream().filter(dimensionID -> this.get((String)dimensionID) != null).forEach(dimensionID -> dimensionTypes.add(this.get((String)dimensionID)));
        return dimensionTypes;
    }

    public String getLabelRootID() {
        return apeLabel;
    }

    public Type getLabelRoot() {
        return this.apeLabelRoot;
    }

    public Type getEmptyAPELabel() {
        return this.emptyLabelType;
    }
}

