/*
 * Decompiled with CFR 0.152.
 */
package nl.uu.cs.ape.models;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import nl.uu.cs.ape.models.AbstractModule;
import nl.uu.cs.ape.models.AllModules;
import nl.uu.cs.ape.models.AuxModulePredicate;
import nl.uu.cs.ape.models.Type;
import nl.uu.cs.ape.models.enums.LogicOperation;
import nl.uu.cs.ape.models.enums.NodeType;
import nl.uu.cs.ape.models.logic.constructs.TaxonomyPredicate;
import nl.uu.cs.ape.utils.APEDimensionsException;
import nl.uu.cs.ape.utils.APEDomainSetup;
import nl.uu.cs.ape.utils.APEUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class Module
extends AbstractModule {
    private List<Type> moduleInput;
    private List<Type> moduleOutput;
    private String executionCommand;
    private ArrayList<LinkedHashMap<String, String>> cwlInputs;
    private Map<String, Object> cwlImplementation;

    public Module(String moduleName, String moduleID, String rootNode, List<Type> moduleInput, List<Type> moduleOutput, String moduleExecution) {
        super(moduleName, moduleID, rootNode, NodeType.LEAF);
        this.moduleInput = new ArrayList<Type>(moduleInput);
        this.moduleOutput = new ArrayList<Type>(moduleOutput);
        this.executionCommand = moduleExecution;
    }

    public Module(String moduleName, String moduleID, String rootNode, String moduleExecution) {
        super(moduleName, moduleID, rootNode, NodeType.LEAF);
        this.moduleInput = new ArrayList<Type>();
        this.moduleOutput = new ArrayList<Type>();
        this.executionCommand = moduleExecution;
    }

    public Module(Module module, TaxonomyPredicate abstractModule) {
        super(abstractModule, NodeType.LEAF);
        this.moduleInput = module.getModuleInput();
        this.moduleOutput = module.getModuleOutput();
        this.executionCommand = module.getExecutionCode();
    }

    @Override
    public List<Type> getModuleInput() {
        return this.moduleInput;
    }

    public void setModuleInput(List<Type> moduleInputs) {
        this.moduleInput = moduleInputs;
    }

    public void addModuleInput(Type moduleInput) {
        this.moduleInput.add(moduleInput);
    }

    @Override
    public List<Type> getModuleOutput() {
        return this.moduleOutput;
    }

    public void setModuleOutput(List<Type> moduleOutput) {
        this.moduleOutput = moduleOutput;
    }

    public void addModuleOutput(Type moduleOutput) {
        this.moduleOutput.add(moduleOutput);
    }

    public String getExecutionCode() {
        return this.executionCommand;
    }

    public ArrayList<LinkedHashMap<String, String>> getCwlInputs() {
        return this.cwlInputs;
    }

    public void setCwlInputs(ArrayList<LinkedHashMap<String, String>> cwlInputs) {
        this.cwlInputs = cwlInputs;
    }

    public Map<String, Object> getCwlImplementation() {
        return this.cwlImplementation;
    }

    public void setCwlImplementation(Map<String, Object> cwlImplementation) {
        this.cwlImplementation = cwlImplementation;
    }

    public static AbstractModule taxonomyInstanceFromJson(JSONObject jsonParam, APEDomainSetup domainSetup) throws JSONException {
        TreeSet<TaxonomyPredicate> parameterDimensions = new TreeSet<TaxonomyPredicate>();
        AllModules allModules = domainSetup.getAllModules();
        for (String currRootLabel : jsonParam.keySet()) {
            String curRootIRI = currRootLabel;
            if (!allModules.existsRoot(curRootIRI)) {
                curRootIRI = APEUtils.createClassIRI(currRootLabel, domainSetup.getOntologyPrefixIRI());
            }
            if (!allModules.existsRoot(curRootIRI)) {
                throw APEDimensionsException.notExistingDimension("Data type was defined over a non existing data dimension: '" + curRootIRI + "', in JSON: '" + jsonParam + "'");
            }
            LogicOperation logConn = LogicOperation.OR;
            TreeSet<TaxonomyPredicate> logConnectedPredicates = new TreeSet<TaxonomyPredicate>();
            for (String currModuleLabel : APEUtils.getListFromJson(jsonParam, currRootLabel, String.class)) {
                String currModuleIRI = APEUtils.createClassIRI(currModuleLabel, domainSetup.getOntologyPrefixIRI());
                AbstractModule currModule = allModules.get(currModuleIRI);
                if (currModule == null) {
                    currModule = allModules.get(currModuleLabel);
                }
                if (currModule != null) {
                    currModule.setAsRelevantTaxonomyTerm(allModules);
                    logConnectedPredicates.add(currModule);
                    continue;
                }
                throw APEDimensionsException.dimensionDoesNotContainClass(String.format("Error in a JSON input. The tool '%s' was not defined or does not belong to the tool dimension '%s'.", currModuleIRI, curRootIRI));
            }
            AbstractModule abstractDimensionType = AuxModulePredicate.generateAuxiliaryPredicate(logConnectedPredicates, logConn, domainSetup);
            if (abstractDimensionType == null) continue;
            parameterDimensions.add(abstractDimensionType);
        }
        AbstractModule taxonomyInstance = AuxModulePredicate.generateAuxiliaryPredicate(parameterDimensions, LogicOperation.AND, domainSetup);
        return taxonomyInstance;
    }

    @Override
    public String toString() {
        StringBuilder inputs = new StringBuilder();
        StringBuilder outputs = new StringBuilder();
        for (Type inType : this.moduleInput) {
            inputs.append("{").append(inType.toShortString()).append("} ");
        }
        for (Type outType : this.moduleOutput) {
            outputs.append("{").append(outType.toShortString()).append("} ");
        }
        return "______________________________________\n|" + super.toString() + ",\n|IN:\t" + inputs + ",\n|OUT\t" + outputs + "\n|______________________________________";
    }

    @Override
    public String toShortString() {
        return super.toShortString();
    }

    @Override
    public String getType() {
        return "module";
    }
}

