/*
 * Decompiled with CFR 0.152.
 */
package nl.uu.cs.ape.models;

import java.util.HashMap;
import java.util.Map;
import nl.uu.cs.ape.automaton.State;
import nl.uu.cs.ape.models.MappingsException;
import nl.uu.cs.ape.models.enums.AtomType;
import nl.uu.cs.ape.models.logic.constructs.PredicateLabel;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxAtom;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxAtomVar;

public class SATAtomMappings {
    private static final int auxDefaultInit = 3;
    private static final int auxMax = 100000;
    private static final int atomVarMaxNo = 100000;
    private Map<SLTLxAtom, Integer> mappings = new HashMap<SLTLxAtom, Integer>();
    private Map<Integer, SLTLxAtom> reverseMapping = new HashMap<Integer, SLTLxAtom>();
    private Map<String, SLTLxAtom> mapped = new HashMap<String, SLTLxAtom>();
    private Map<SLTLxAtomVar, Integer> vMappings = new HashMap<SLTLxAtomVar, Integer>();
    private Map<Integer, SLTLxAtomVar> vReverseMapping = new HashMap<Integer, SLTLxAtomVar>();
    private Map<String, SLTLxAtomVar> vMapped = new HashMap<String, SLTLxAtomVar>();
    private int atomNo = 200001;
    private int atomVarNo = 100001;
    private int auxiliary = 3;

    public synchronized Integer add(PredicateLabel predicate, State usedInState, AtomType elementType) throws MappingsException {
        SLTLxAtom atom = new SLTLxAtom(elementType, predicate, usedInState);
        Integer id = this.mappings.get(atom);
        if (id == null) {
            if (this.mapped.get(atom.toString()) != null) {
                throw MappingsException.mappedAtomsSignaturesOverlap("Encoding error. Two or more mappings map share same string: '" + atom.toString() + "' as ID.");
            }
            ++this.atomNo;
            this.mappings.put(atom, this.atomNo);
            this.reverseMapping.put(this.atomNo, atom);
            this.mapped.put(atom.toString(), atom);
            return this.atomNo;
        }
        return id;
    }

    public synchronized Integer add(SLTLxAtom atom) throws MappingsException {
        Integer id = this.mappings.get(atom);
        if (id == null) {
            if (this.mapped.get(atom.toString()) != null) {
                throw MappingsException.mappedAtomsSignaturesOverlap("Encoding error. Two or more mappings map share same string: '" + atom.toString() + "' as ID.");
            }
            ++this.atomNo;
            this.mappings.put(atom, this.atomNo);
            this.reverseMapping.put(this.atomNo, atom);
            this.mapped.put(atom.toString(), atom);
            return this.atomNo;
        }
        return id;
    }

    public synchronized Integer add(SLTLxAtomVar atomVar) throws MappingsException {
        Integer id = this.vMappings.get(atomVar);
        if (id == null) {
            if (this.vMapped.get(atomVar.toString()) != null) {
                throw MappingsException.mappedAtomsSignaturesOverlap("Encoding error. Two or more mappings map share same string: '" + atomVar.toString() + "' as ID.");
            }
            ++this.atomVarNo;
            this.vMappings.put(atomVar, this.atomVarNo);
            this.vReverseMapping.put(this.atomVarNo, atomVar);
            this.vMapped.put(atomVar.toString(), atomVar);
            return this.atomVarNo;
        }
        return id;
    }

    public Integer findMapping(SLTLxAtom atom) {
        return this.mappings.get(atom);
    }

    public SLTLxAtom findOriginal(Integer mappedValue) {
        return this.reverseMapping.get(mappedValue);
    }

    public SLTLxAtomVar findOriginalVar(Integer mappedValue) {
        return this.vReverseMapping.get(mappedValue);
    }

    public int getSize() {
        return this.atomNo;
    }

    public int getNextAuxNum() {
        return this.auxiliary++;
    }

    public void resetAuxVariables() {
        this.auxiliary = 3;
    }

    public int getCurrNumOfMappedAuxVar() {
        return this.auxiliary;
    }

    public int getInitialNumOfMappedAtoms() {
        return 200001;
    }
}

