/*
 * Decompiled with CFR 0.152.
 */
package nl.uu.cs.ape.models;

import java.util.TreeSet;
import nl.uu.cs.ape.models.AllTypes;
import nl.uu.cs.ape.models.AuxTypePredicate;
import nl.uu.cs.ape.models.enums.LogicOperation;
import nl.uu.cs.ape.models.enums.NodeType;
import nl.uu.cs.ape.models.logic.constructs.TaxonomyPredicate;
import nl.uu.cs.ape.utils.APEDimensionsException;
import nl.uu.cs.ape.utils.APEDomainSetup;
import nl.uu.cs.ape.utils.APEUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class Type
extends TaxonomyPredicate {
    private final String typeName;
    private final String typeID;
    private Type plainType;

    public Type(String typeName, String typeID, String rootNode, NodeType nodeType) {
        super(rootNode, nodeType);
        this.typeName = typeName;
        this.typeID = typeID;
        this.plainType = this;
    }

    @Override
    public String getPredicateLabel() {
        return this.typeName;
    }

    @Override
    public String getPredicateLongLabel() {
        if (this.typeID.endsWith("_plain")) {
            return APEUtils.removeNLastChar(this.typeID, 6);
        }
        return this.typeID;
    }

    @Override
    public String getPredicateID() {
        return this.typeID;
    }

    @Override
    public String getType() {
        return "type";
    }

    public void setPlainType(Type plainType) {
        this.plainType = plainType;
    }

    public Type getPlainType() {
        return this.plainType;
    }

    public static Type taxonomyInstanceFromJson(JSONObject jsonParam, APEDomainSetup domainSetup, boolean isOutputData) throws JSONException, APEDimensionsException {
        TreeSet<TaxonomyPredicate> parameterDimensions = new TreeSet<TaxonomyPredicate>();
        boolean labelDefined = false;
        AllTypes allTypes = domainSetup.getAllTypes();
        for (String currRootLabel : jsonParam.keySet()) {
            String curRootIRI = currRootLabel;
            if (!allTypes.existsRoot(curRootIRI)) {
                curRootIRI = APEUtils.createClassIRI(currRootLabel, domainSetup.getOntologyPrefixIRI());
            }
            if (!allTypes.existsRoot(curRootIRI)) {
                throw APEDimensionsException.notExistingDimension("Data type was defined over a non existing data dimension: '" + curRootIRI + "', in JSON: '" + jsonParam + "'");
            }
            LogicOperation logConn = LogicOperation.OR;
            TreeSet<TaxonomyPredicate> logConnectedPredicates = new TreeSet<TaxonomyPredicate>();
            for (String currTypeLabel : APEUtils.getListFromJson(jsonParam, currRootLabel, String.class)) {
                Type currType;
                String currTypeIRI = currTypeLabel;
                if (allTypes.get(currTypeIRI, curRootIRI) == null) {
                    currTypeIRI = APEUtils.createClassIRI(currTypeLabel, domainSetup.getOntologyPrefixIRI());
                }
                if (currRootLabel.equals(allTypes.getLabelRootID())) {
                    labelDefined = true;
                }
                if ((currType = allTypes.get(currTypeIRI, curRootIRI)) != null) {
                    if (isOutputData) {
                        currType.setAsRelevantTaxonomyTerm(allTypes);
                        currType = currType.getPlainType();
                    }
                    currType.setAsRelevantTaxonomyTerm(allTypes);
                    logConnectedPredicates.add(currType);
                    continue;
                }
                if (currRootLabel.equals(allTypes.getLabelRootID()) && isOutputData) {
                    currType = allTypes.addPredicate(new Type(currTypeLabel, currTypeLabel, curRootIRI, NodeType.LEAF));
                    allTypes.getLabelRoot().addSubPredicate(currType);
                    currType.addSuperPredicate(allTypes.getLabelRoot());
                    currType.setAsRelevantTaxonomyTerm(allTypes);
                    logConnectedPredicates.add(currType);
                    continue;
                }
                throw APEDimensionsException.dimensionDoesNotContainClass(String.format("Error in a JSON input. The data type '%s' was not defined or does not belong to the data dimension '%s'.", currTypeIRI, curRootIRI));
            }
            Type abstractDimensionType = AuxTypePredicate.generateAuxiliaryPredicate(logConnectedPredicates, logConn, domainSetup);
            if (abstractDimensionType == null) continue;
            parameterDimensions.add(abstractDimensionType);
        }
        if (!labelDefined) {
            if (isOutputData) {
                parameterDimensions.add(allTypes.getEmptyAPELabel());
            } else {
                parameterDimensions.add(allTypes.getLabelRoot());
            }
        }
        return AuxTypePredicate.generateAuxiliaryPredicate(parameterDimensions, LogicOperation.AND, domainSetup);
    }
}

