/*
 * Decompiled with CFR 0.152.
 */
package nl.uu.cs.ape.models.enums;

public enum AtomType {
    MODULE("module"),
    MEMORY_TYPE("memType"),
    USED_TYPE("usedType"),
    MEM_TYPE_REFERENCE("memRef"),
    R_RELATION("r_rel"),
    IDENTITY_RELATION("is_rel");

    private final String text;

    private AtomType(String s) {
        this.text = s;
    }

    public String toString() {
        return this.text;
    }

    public boolean isUnaryProperty() {
        return this.equals((Object)MODULE) || this.equals((Object)MEMORY_TYPE) || this.equals((Object)USED_TYPE);
    }

    public boolean isBinaryRel() {
        return this.equals((Object)R_RELATION) || this.equals((Object)MEM_TYPE_REFERENCE) || this.equals((Object)IDENTITY_RELATION);
    }

    public static String getStringShortcut(AtomType elem, Integer blockNumber, int stateNumber) {
        if (elem == MODULE) {
            return "Tool" + stateNumber;
        }
        if (elem == MEMORY_TYPE) {
            return "MemT" + blockNumber + "." + stateNumber;
        }
        if (elem == USED_TYPE) {
            return "UsedT" + blockNumber + "." + stateNumber;
        }
        if (elem == null) {
            return "nullMem";
        }
        return "AtomType error.";
    }
}

