/*
 * Decompiled with CFR 0.152.
 */
package nl.uu.cs.ape.models.logic.constructs;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import nl.uu.cs.ape.models.AllPredicates;
import nl.uu.cs.ape.models.enums.NodeType;
import nl.uu.cs.ape.models.logic.constructs.PredicateLabel;
import nl.uu.cs.ape.utils.APEUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TaxonomyPredicate
implements PredicateLabel {
    private static final Logger log = LoggerFactory.getLogger(TaxonomyPredicate.class);
    protected NodeType nodeType;
    private String rootNodeID;
    private boolean isRelevant;
    private Set<TaxonomyPredicate> subPredicates;
    private Set<TaxonomyPredicate> superPredicates;

    protected TaxonomyPredicate(String rootNode, NodeType nodeType) {
        this.rootNodeID = rootNode;
        this.nodeType = nodeType;
        this.isRelevant = false;
        if (nodeType != NodeType.LEAF && nodeType != NodeType.EMPTY) {
            this.subPredicates = new HashSet<TaxonomyPredicate>();
        }
        if (nodeType != NodeType.ROOT) {
            this.superPredicates = new HashSet<TaxonomyPredicate>();
        }
    }

    protected TaxonomyPredicate(TaxonomyPredicate oldPredicate, NodeType nodeType) {
        this.rootNodeID = oldPredicate.rootNodeID;
        this.nodeType = nodeType;
        this.isRelevant = oldPredicate.isRelevant;
        if (nodeType != NodeType.LEAF && nodeType != NodeType.EMPTY) {
            this.subPredicates = oldPredicate.getSubPredicates();
        }
        if (nodeType != NodeType.ROOT) {
            this.superPredicates = oldPredicate.getSuperPredicates();
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getPredicateID() == null ? 0 : this.getPredicateID().hashCode());
        result = 31 * result + (this.rootNodeID == null ? 0 : this.rootNodeID.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TaxonomyPredicate other = (TaxonomyPredicate)obj;
        if (this.getPredicateID() == null ? other.getPredicateID() != null : !this.getPredicateID().equals(other.getPredicateID())) {
            return false;
        }
        return !(this.rootNodeID == null ? other.rootNodeID != null : !this.rootNodeID.equals(other.rootNodeID));
    }

    @Override
    public int compareTo(PredicateLabel other) {
        if (!(other instanceof TaxonomyPredicate)) {
            return this.getPredicateID().compareTo(other.getPredicateID());
        }
        TaxonomyPredicate otherPredicate = (TaxonomyPredicate)other;
        int diff = 0;
        diff = this.getRootNodeID().compareTo(otherPredicate.getRootNodeID());
        if (diff != 0) {
            return diff;
        }
        return this.getPredicateID().compareTo(otherPredicate.getPredicateID());
    }

    public String getRootNodeID() {
        return this.rootNodeID;
    }

    public void setRootNode(String rootType) {
        this.rootNodeID = rootType;
    }

    public NodeType getNodeType() {
        return this.nodeType;
    }

    private void setIsRelevant() {
        this.isRelevant = true;
    }

    public boolean getIsRelevant() {
        return this.isRelevant;
    }

    public Map<String, String> toMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("value", this.getPredicateID());
        map.put("label", this.getPredicateLabel());
        return map;
    }

    public boolean setAsRelevantTaxonomyTerm(AllPredicates allPredicates) {
        if (this.isRelevant) {
            return true;
        }
        boolean succExe = true;
        if (allPredicates == null) {
            return false;
        }
        this.setIsRelevant();
        for (TaxonomyPredicate superPredicate : APEUtils.safe(this.superPredicates)) {
            succExe = succExe && superPredicate.setAsRelevantTaxonomyTermBottomUp(allPredicates);
        }
        for (TaxonomyPredicate subPredicate : APEUtils.safe(this.subPredicates)) {
            succExe = succExe && subPredicate.setAsRelevantTaxonomyTermTopDown(allPredicates);
        }
        return succExe;
    }

    private boolean setAsRelevantTaxonomyTermTopDown(AllPredicates allPredicates) {
        if (this.isRelevant) {
            return true;
        }
        boolean succExe = true;
        if (allPredicates == null) {
            return false;
        }
        this.setIsRelevant();
        for (TaxonomyPredicate subPredicate : APEUtils.safe(this.subPredicates)) {
            succExe = succExe && subPredicate.setAsRelevantTaxonomyTermTopDown(allPredicates);
        }
        return succExe;
    }

    private boolean setAsRelevantTaxonomyTermBottomUp(AllPredicates allPredicates) {
        if (this.isRelevant) {
            return true;
        }
        boolean succExe = true;
        if (allPredicates == null) {
            return false;
        }
        this.setIsRelevant();
        for (TaxonomyPredicate superPredicate : APEUtils.safe(this.superPredicates)) {
            succExe = succExe && superPredicate.setAsRelevantTaxonomyTermBottomUp(allPredicates);
        }
        return succExe;
    }

    public abstract String getType();

    public String toString() {
        return "|ID: " + this.getPredicateID() + ", Label:" + this.getPredicateLabel() + "|";
    }

    public String toShortString() {
        return this.getPredicateLabel();
    }

    public void printTree(String str, AllPredicates allPredicates) {
        log.debug(str + this.toShortString() + "[" + (Object)((Object)this.getNodeType()) + "]");
        for (TaxonomyPredicate predicate : APEUtils.safe(this.subPredicates)) {
            predicate.printTree(str + ". ", allPredicates);
        }
    }

    public boolean addSubPredicate(TaxonomyPredicate predicate) {
        if (this.nodeType != NodeType.LEAF && this.nodeType != NodeType.EMPTY) {
            this.subPredicates.add(predicate);
            return true;
        }
        log.warn("Cannot add sub-predicate to a leaf or empty taxonomy term: " + this.getPredicateID() + ".");
        return false;
    }

    public Set<TaxonomyPredicate> getSubPredicates() {
        return this.subPredicates;
    }

    public boolean removeSubPredicate(TaxonomyPredicate subPredicateToRemove) {
        return this.subPredicates.remove(subPredicateToRemove);
    }

    public boolean removeAllSubPredicates(Collection<TaxonomyPredicate> subPredicatesToRemove) {
        boolean done = false;
        if (subPredicatesToRemove != null && !subPredicatesToRemove.isEmpty()) {
            done = this.subPredicates.removeAll(subPredicatesToRemove);
        }
        return done;
    }

    public boolean addSuperPredicate(TaxonomyPredicate predicate) {
        if (predicate == null) {
            return false;
        }
        if (this.nodeType != NodeType.ROOT) {
            this.superPredicates.add(predicate);
            return true;
        }
        log.warn("Cannot add super-predicate to a root taxonomy term!");
        return false;
    }

    public Set<TaxonomyPredicate> getSuperPredicates() {
        return this.superPredicates;
    }

    public boolean isNodeType(NodeType nodeType) {
        return this.nodeType.equals((Object)nodeType);
    }

    public boolean isSimplePredicate() {
        return this.nodeType == NodeType.LEAF || this.nodeType == NodeType.EMPTY_LABEL;
    }

    public boolean isArtificialLeaf() {
        return this.nodeType == NodeType.ARTIFICIAL_LEAF;
    }

    public boolean isEmptyPredicate() {
        return this.nodeType == NodeType.EMPTY;
    }

    public boolean notEmptyPredicate() {
        return this.nodeType != NodeType.EMPTY;
    }

    public boolean isRootPredicate() {
        return this.nodeType == NodeType.ROOT;
    }

    public NodeType getNodePredicate() {
        return this.nodeType;
    }

    public void setNodePredicate(NodeType nodeType) {
        this.nodeType = nodeType;
    }
}

