/*
 * Decompiled with CFR 0.152.
 */
package nl.uu.cs.ape.models.sltlxStruc;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import nl.uu.cs.ape.core.implSAT.SATSynthesisEngine;
import nl.uu.cs.ape.io.APEFiles;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxElem;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxVariableSubstitutionCollection;

public abstract class SLTLxFormula
implements SLTLxElem {
    protected SLTLxFormula() {
    }

    public static void appendCNFToFile(File file, SATSynthesisEngine synthesisEngine, Collection<SLTLxFormula> formulas) throws IOException {
        StringBuilder cnf = new StringBuilder();
        SLTLxFormula.createCNFEncoding(formulas, 0, synthesisEngine).forEach(clause -> cnf.append((String)clause));
        APEFiles.appendToFile(file, cnf.toString());
    }

    private static Set<String> createCNFEncoding(Collection<SLTLxFormula> facts, int stateNo, SATSynthesisEngine synthesisEngine) {
        HashSet<String> clauses = new HashSet<String>();
        facts.forEach(fact -> clauses.addAll(fact.getCNFEncoding(stateNo, new SLTLxVariableSubstitutionCollection(), synthesisEngine)));
        return clauses;
    }

    public Set<String> getConstraintCNFEncoding(SATSynthesisEngine synthesisEngine) {
        return this.getCNFEncoding(0, new SLTLxVariableSubstitutionCollection(), synthesisEngine);
    }
}

