/*
 * Decompiled with CFR 0.152.
 */
package nl.uu.cs.ape.models.sltlxStruc;

import java.util.HashSet;
import java.util.Set;
import nl.uu.cs.ape.core.implSAT.SATSynthesisEngine;
import nl.uu.cs.ape.models.sltlxStruc.CNFClause;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxAtom;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxFormula;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxVariableSubstitutionCollection;

public class SLTLxNextOp
extends SLTLxFormula {
    private SLTLxFormula operation;
    private SLTLxFormula formula;

    public SLTLxNextOp(SLTLxFormula operation, SLTLxFormula formula) {
        this.operation = operation;
        this.formula = formula;
    }

    @Override
    public Set<String> getCNFEncoding(int stateNo, SLTLxVariableSubstitutionCollection variableMapping, SATSynthesisEngine synthesisEngine) {
        if (synthesisEngine.getSolutionSize() <= stateNo) {
            return SLTLxAtom.getFalse().getCNFEncoding(stateNo, variableMapping, synthesisEngine);
        }
        HashSet<Set<String>> allClauses = new HashSet<Set<String>>();
        allClauses.add(this.operation.getCNFEncoding(stateNo, variableMapping, synthesisEngine));
        allClauses.add(this.formula.getCNFEncoding(stateNo + 1, variableMapping, synthesisEngine));
        return CNFClause.conjunctClausesCollection(allClauses);
    }

    @Override
    public Set<String> getNegatedCNFEncoding(int stateNo, SLTLxVariableSubstitutionCollection variableMapping, SATSynthesisEngine synthesisEngine) {
        if (synthesisEngine.getSolutionSize() <= stateNo) {
            return SLTLxAtom.getTrue().getCNFEncoding(stateNo, variableMapping, synthesisEngine);
        }
        HashSet<Set<String>> allClauses = new HashSet<Set<String>>();
        allClauses.add(this.operation.getNegatedCNFEncoding(stateNo, variableMapping, synthesisEngine));
        allClauses.add(this.formula.getNegatedCNFEncoding(stateNo + 1, variableMapping, synthesisEngine));
        return CNFClause.disjoinClausesCollection(allClauses);
    }
}

