/*
 * Decompiled with CFR 0.152.
 */
package nl.uu.cs.ape.models.sltlxStruc;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import nl.uu.cs.ape.automaton.State;
import nl.uu.cs.ape.core.implSAT.SATSynthesisEngine;
import nl.uu.cs.ape.models.AbstractModule;
import nl.uu.cs.ape.models.enums.AtomType;
import nl.uu.cs.ape.models.enums.AtomVarType;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxAtom;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxAtomVar;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxConjunction;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxDisjunction;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxFormula;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxImplication;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxVariable;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxVariableSubstitutionCollection;

public class SLTLxOperation
extends SLTLxFormula {
    private AbstractModule module;
    private List<SLTLxVariable> inputs;
    private List<SLTLxVariable> outputs;

    public SLTLxOperation(AbstractModule module, List<SLTLxVariable> inputs, List<SLTLxVariable> outputs) {
        this.module = module;
        this.inputs = inputs;
        this.outputs = outputs;
    }

    @Override
    public Set<String> getCNFEncoding(int stateNo, SLTLxVariableSubstitutionCollection variableMapping, SATSynthesisEngine synthesisEngine) {
        SLTLxFormula operationUsage = this.enforceOperation(stateNo, synthesisEngine);
        return operationUsage.getCNFEncoding(stateNo, variableMapping, synthesisEngine);
    }

    @Override
    public Set<String> getNegatedCNFEncoding(int stateNo, SLTLxVariableSubstitutionCollection variableMapping, SATSynthesisEngine synthesisEngine) {
        SLTLxFormula operationModel = this.enforceOperation(stateNo, synthesisEngine);
        return operationModel.getNegatedCNFEncoding(stateNo, variableMapping, synthesisEngine);
    }

    private SLTLxFormula enforceOperation(int stateNo, SATSynthesisEngine synthesisEngine) {
        SLTLxFormula outputsRule;
        SLTLxFormula inputsRule;
        State moduleState = synthesisEngine.getModuleAutomaton().getSafe(stateNo);
        if (moduleState == null) {
            return SLTLxAtom.getFalse();
        }
        SLTLxAtom moduleRule = new SLTLxAtom(AtomType.MODULE, this.module, moduleState);
        if (this.inputs.isEmpty()) {
            inputsRule = SLTLxAtom.getTrue();
        } else {
            HashSet<SLTLxFormula> allInputs = new HashSet<SLTLxFormula>();
            for (SLTLxVariable inputVar : this.inputs) {
                HashSet<SLTLxAtomVar> inputAtoms = new HashSet<SLTLxAtomVar>();
                for (State state : synthesisEngine.getTypeAutomaton().getUsedTypesBlock(stateNo).getStates()) {
                    inputAtoms.add(new SLTLxAtomVar(AtomVarType.MEM_TYPE_REF_V, state, inputVar));
                }
                SLTLxDisjunction currInputStates = new SLTLxDisjunction(inputAtoms);
                allInputs.add(currInputStates);
            }
            if (this.inputs.size() > 1) {
                for (SLTLxVariable inputVar : this.inputs) {
                    ArrayList restVars = new ArrayList();
                    this.inputs.forEach(restVars::add);
                    restVars.remove(restVars.indexOf(inputVar));
                    for (State state : synthesisEngine.getTypeAutomaton().getUsedTypesBlock(stateNo).getStates()) {
                        ArrayList restStates = new ArrayList();
                        synthesisEngine.getTypeAutomaton().getUsedTypesBlock(stateNo).getStates().forEach(restStates::add);
                        restStates.remove(restStates.indexOf(state));
                        SLTLxAtomVar currSub = new SLTLxAtomVar(AtomVarType.MEM_TYPE_REF_V, state, inputVar);
                        for (SLTLxVariable otherVar : restVars) {
                            HashSet<SLTLxAtomVar> varPossibility = new HashSet<SLTLxAtomVar>();
                            for (State otherState : restStates) {
                                varPossibility.add(new SLTLxAtomVar(AtomVarType.MEM_TYPE_REF_V, otherState, otherVar));
                            }
                            allInputs.add(new SLTLxImplication(currSub, new SLTLxDisjunction(varPossibility)));
                        }
                    }
                }
            }
            inputsRule = new SLTLxConjunction(allInputs);
        }
        if (this.outputs.isEmpty()) {
            outputsRule = SLTLxAtom.getTrue();
        } else {
            HashSet<SLTLxDisjunction> allOutputs = new HashSet<SLTLxDisjunction>();
            for (SLTLxVariable outputVar : this.outputs) {
                HashSet<SLTLxAtomVar> outputAtoms = new HashSet<SLTLxAtomVar>();
                for (State outState : synthesisEngine.getTypeAutomaton().getMemoryTypesBlock(stateNo + 1).getStates()) {
                    outputAtoms.add(new SLTLxAtomVar(AtomVarType.VAR_VALUE, outState, outputVar));
                }
                SLTLxDisjunction sLTLxDisjunction = new SLTLxDisjunction(outputAtoms);
                allOutputs.add(sLTLxDisjunction);
            }
            outputsRule = new SLTLxConjunction(allOutputs);
        }
        return new SLTLxConjunction(moduleRule, inputsRule, outputsRule);
    }
}

