/*
 * Decompiled with CFR 0.152.
 */
package nl.uu.cs.ape.models.sltlxStruc;

import java.util.HashSet;
import java.util.Set;
import nl.uu.cs.ape.automaton.State;
import nl.uu.cs.ape.automaton.StateInterface;
import nl.uu.cs.ape.core.implSAT.SATSynthesisEngine;
import nl.uu.cs.ape.models.Pair;
import nl.uu.cs.ape.models.enums.AtomType;
import nl.uu.cs.ape.models.enums.AtomVarType;
import nl.uu.cs.ape.models.logic.constructs.PredicateLabel;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxAtom;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxAtomVar;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxConjunction;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxDisjunction;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxEquivalence;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxFormula;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxImplication;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxNegatedConjunction;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxNegation;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxVariableOccurrenceCollection;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxVariableSubstitutionCollection;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxXOR;
import nl.uu.cs.ape.utils.APEUtils;

public class SLTLxVariable
implements StateInterface,
PredicateLabel {
    private final String variableID;

    public SLTLxVariable(String variableName) {
        this.variableID = variableName;
    }

    public String getVariableName() {
        return this.variableID;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.variableID == null ? 0 : this.variableID.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SLTLxVariable other = (SLTLxVariable)obj;
        return !(this.variableID == null ? other.variableID != null : !this.variableID.equals(other.variableID));
    }

    @Override
    public String getPredicateID() {
        return this.variableID;
    }

    @Override
    public int compareTo(PredicateLabel other) {
        return this.getPredicateID().compareTo(other.getPredicateID());
    }

    @Override
    public String getPredicateLabel() {
        return this.variableID;
    }

    @Override
    public String getPredicateLongLabel() {
        return this.variableID;
    }

    public Set<String> getExistentialCNFEncoding(int stateNo, SLTLxVariableSubstitutionCollection variableSubstitutions, SATSynthesisEngine synthesisEngine) {
        HashSet<SLTLxConjunction> varRefs = new HashSet<SLTLxConjunction>();
        for (State state : variableSubstitutions.getVariableDomain(this)) {
            SLTLxAtomVar currAtomVar = new SLTLxAtomVar(AtomVarType.VAR_VALUE, state, this);
            SLTLxAtom currIsEmptyState = new SLTLxAtom(state.getWorkflowStateType(), synthesisEngine.getEmptyType(), state);
            varRefs.add(new SLTLxConjunction(currAtomVar, new SLTLxNegation(currIsEmptyState)));
        }
        SLTLxDisjunction allVars = new SLTLxDisjunction(varRefs);
        return allVars.getCNFEncoding(stateNo, variableSubstitutions, synthesisEngine);
    }

    public Set<String> getUniversalCNFEncoding(int stateNo, SLTLxVariableSubstitutionCollection variableSubstitutions, SATSynthesisEngine synthesisEngine) {
        HashSet<SLTLxXOR> varRefs = new HashSet<SLTLxXOR>();
        for (State state : variableSubstitutions.getVariableDomain(this)) {
            SLTLxAtomVar currAtomVar = new SLTLxAtomVar(AtomVarType.VAR_VALUE, state, this);
            SLTLxAtom currIsEmptyState = new SLTLxAtom(state.getWorkflowStateType(), synthesisEngine.getEmptyType(), state);
            varRefs.add(new SLTLxXOR(currAtomVar, currIsEmptyState));
        }
        SLTLxConjunction allVars = new SLTLxConjunction(varRefs);
        return allVars.getCNFEncoding(stateNo, variableSubstitutions, synthesisEngine);
    }

    public Set<String> getVariableSubstitutionToPreserveProperties(int stateNo, SLTLxVariableSubstitutionCollection variableSubstitutions, SATSynthesisEngine synthesisEngine) {
        HashSet<SLTLxFormula> allFacts = new HashSet<SLTLxFormula>();
        SLTLxVariableOccurrenceCollection varOccurrences = synthesisEngine.getVariableUsage();
        allFacts.addAll(SLTLxVariable.generateDataPropertySubstitutionRules(this, variableSubstitutions, varOccurrences));
        varOccurrences.getPairsContainingVarAsArg(this).forEach(pair -> allFacts.addAll(SLTLxVariable.generateBinarySubstitutionRules(pair, variableSubstitutions, varOccurrences)));
        SLTLxConjunction andFacts = new SLTLxConjunction(allFacts);
        return andFacts.getCNFEncoding(stateNo, variableSubstitutions, synthesisEngine);
    }

    private static Set<SLTLxFormula> generateDataPropertySubstitutionRules(SLTLxVariable variable, SLTLxVariableSubstitutionCollection variableSubstitutions, SLTLxVariableOccurrenceCollection varOccurrences) {
        HashSet<SLTLxFormula> allFacts = new HashSet<SLTLxFormula>();
        for (State varState : variableSubstitutions.getVariableDomain(variable)) {
            for (PredicateLabel predicateLabel : varOccurrences.getDataTypes(variable)) {
                allFacts.add(new SLTLxImplication(new SLTLxAtomVar(AtomVarType.VAR_VALUE, varState, variable), new SLTLxEquivalence(new SLTLxAtomVar(AtomVarType.TYPE_V, predicateLabel, variable), new SLTLxAtom(AtomType.MEMORY_TYPE, predicateLabel, varState))));
            }
            for (State state : varOccurrences.getMemoryReferences(variable)) {
                allFacts.add(new SLTLxImplication(new SLTLxAtomVar(AtomVarType.VAR_VALUE, varState, variable), new SLTLxEquivalence(new SLTLxAtomVar(AtomVarType.MEM_TYPE_REF_V, state, variable), new SLTLxAtom(AtomType.MEM_TYPE_REFERENCE, varState, state))));
            }
        }
        return allFacts;
    }

    private static Set<SLTLxFormula> generateBinarySubstitutionRules(Pair<SLTLxVariable> pair, SLTLxVariableSubstitutionCollection variableSubstitutions, SLTLxVariableOccurrenceCollection varOccurrences) {
        HashSet<SLTLxFormula> allFacts = new HashSet<SLTLxFormula>();
        SLTLxVariable var1 = pair.getFirst();
        SLTLxVariable var2 = pair.getSecond();
        if (variableSubstitutions.getVariableDomain(var1) == null || variableSubstitutions.getVariableDomain(var2) == null) {
            return allFacts;
        }
        for (AtomVarType atomVarType : varOccurrences.getBinaryPredicates(pair)) {
            AtomType atomType = SLTLxVariable.inferAtomType(atomVarType);
            if (atomType == null) continue;
            for (State var1State : variableSubstitutions.getVariableDomain(var1)) {
                for (State var2State : variableSubstitutions.getVariableDomain(var2)) {
                    allFacts.add(new SLTLxImplication(new SLTLxConjunction(new SLTLxAtomVar(AtomVarType.VAR_VALUE, var1State, var1), new SLTLxAtomVar(AtomVarType.VAR_VALUE, var2State, var2)), new SLTLxEquivalence(new SLTLxAtomVar(atomVarType, var1, var2), new SLTLxAtom(atomType, var1State, var2State))));
                }
            }
        }
        return allFacts;
    }

    private static AtomType inferAtomType(AtomVarType atomVarType) {
        if (atomVarType.equals((Object)AtomVarType.VAR_EQUIVALENCE)) {
            return AtomType.IDENTITY_RELATION;
        }
        if (atomVarType.equals((Object)AtomVarType.R_RELATION_V)) {
            return AtomType.R_RELATION;
        }
        if (atomVarType.equals((Object)AtomVarType.MEM_TYPE_REF_V)) {
            return AtomType.MEM_TYPE_REFERENCE;
        }
        return null;
    }

    public static Set<State> getVariableDomain(int stateNo, SATSynthesisEngine synthesisEngine) {
        HashSet<State> variableDomain = new HashSet<State>();
        int nextStateNo = stateNo + 1;
        for (State state : synthesisEngine.getTypeAutomaton().getAllMemoryStatesUntilBlockNo(nextStateNo)) {
            variableDomain.add(state);
        }
        return variableDomain;
    }

    public Set<String> getVariableMutualExclusion(int stateNo, SLTLxVariableSubstitutionCollection variableMapping, SATSynthesisEngine synthesisEngine) {
        HashSet<String> allClauses = new HashSet<String>();
        int nextStateNo = stateNo + 1;
        Set<Pair<PredicateLabel>> statePairs = APEUtils.getUniquePairs(synthesisEngine.getTypeAutomaton().getAllMemoryStatesUntilBlockNo(nextStateNo));
        statePairs.forEach(statePair -> allClauses.addAll(new SLTLxNegatedConjunction(new SLTLxAtomVar(AtomVarType.VAR_VALUE, (PredicateLabel)statePair.getFirst(), this), new SLTLxAtomVar(AtomVarType.VAR_VALUE, (PredicateLabel)statePair.getSecond(), this)).getCNFEncoding(stateNo, variableMapping, synthesisEngine)));
        return allClauses;
    }
}

