/*
 * Decompiled with CFR 0.152.
 */
package nl.uu.cs.ape.models.sltlxStruc;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import nl.uu.cs.ape.automaton.State;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxParsingAnnotationException;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxVariable;

public class SLTLxVariableSubstitutionCollection {
    private Map<SLTLxVariable, SLTLxVariable> mappedVariables = new HashMap<SLTLxVariable, SLTLxVariable>();
    private Map<SLTLxVariable, Set<State>> variableDomain;
    private static int variableNo = 1;

    public SLTLxVariableSubstitutionCollection() {
        this.variableDomain = new HashMap<SLTLxVariable, Set<State>>();
    }

    public SLTLxVariableSubstitutionCollection(SLTLxVariableSubstitutionCollection existing) {
        for (SLTLxVariable key : existing.mappedVariables.keySet()) {
            this.mappedVariables.put(key, existing.mappedVariables.get(key));
        }
        this.variableDomain = new HashMap<SLTLxVariable, Set<State>>();
        for (SLTLxVariable key : existing.variableDomain.keySet()) {
            this.variableDomain.put(key, existing.variableDomain.get(key));
        }
    }

    public SLTLxVariable addNewVariable(SLTLxVariable existingVar, Set<State> varDomain) {
        SLTLxVariable newVar = new SLTLxVariable("uniqVar_" + variableNo++);
        this.mappedVariables.put(existingVar, newVar);
        this.mappedVariables.put(newVar, newVar);
        this.variableDomain.put(newVar, varDomain);
        return newVar;
    }

    public SLTLxVariable getVarSabstitute(SLTLxVariable existingVar) throws SLTLxParsingAnnotationException {
        SLTLxVariable variable = this.mappedVariables.get(existingVar);
        if (variable == null) {
            throw SLTLxParsingAnnotationException.variableNotBound("Variable " + existingVar.getPredicateID() + " must be bound.");
        }
        return variable;
    }

    public Set<State> getVariableDomain(SLTLxVariable variable) {
        return this.variableDomain.get(variable);
    }
}

