/*
 * Decompiled with CFR 0.152.
 */
package nl.uu.cs.ape.models.templateFormulas;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import nl.uu.cs.ape.automaton.Block;
import nl.uu.cs.ape.automaton.ModuleAutomaton;
import nl.uu.cs.ape.automaton.State;
import nl.uu.cs.ape.automaton.TypeAutomaton;
import nl.uu.cs.ape.models.Pair;
import nl.uu.cs.ape.models.SATAtomMappings;
import nl.uu.cs.ape.models.enums.AtomType;
import nl.uu.cs.ape.models.logic.constructs.PredicateLabel;
import nl.uu.cs.ape.models.logic.constructs.TaxonomyPredicate;
import nl.uu.cs.ape.utils.APEDomainSetup;
import nl.uu.cs.ape.utils.APEUtils;

public abstract class SLTLxTemplateFormula {
    private TaxonomyPredicate predicate;
    private boolean sign;

    protected SLTLxTemplateFormula(TaxonomyPredicate predicate) {
        this.predicate = predicate;
        this.sign = true;
    }

    protected SLTLxTemplateFormula(boolean sign, TaxonomyPredicate predicate) {
        this.predicate = predicate;
        this.sign = sign;
    }

    public void setSign(boolean sign) {
        this.sign = sign;
    }

    public boolean getSign() {
        return this.sign;
    }

    public TaxonomyPredicate getSubFormula() {
        return this.predicate;
    }

    public abstract String getType();

    public abstract String getCNF(ModuleAutomaton var1, List<Block> var2, AtomType var3, SATAtomMappings var4);

    public static String iteModule(TaxonomyPredicate ifPredicate, TaxonomyPredicate thenPredicate, ModuleAutomaton moduleAutomaton, SATAtomMappings mappings) {
        StringBuilder constraints = new StringBuilder();
        int automatonSize = moduleAutomaton.getAllStates().size();
        for (int i = 0; i < automatonSize; ++i) {
            constraints.append("-" + mappings.add(ifPredicate, moduleAutomaton.getAllStates().get(i), AtomType.MODULE) + " ");
            for (int j = i + 1; j < automatonSize; ++j) {
                constraints.append(mappings.add(thenPredicate, moduleAutomaton.get(j), AtomType.MODULE)).append(" ");
            }
            constraints.append("0\n");
        }
        return constraints.toString();
    }

    public static String iteType(TaxonomyPredicate ifPredicate, TaxonomyPredicate thenPredicate, AtomType typeElement, List<Block> typeBlocks, SATAtomMappings mappings) {
        StringBuilder constraints = new StringBuilder();
        int numberOfBlocks = typeBlocks.size();
        int numberOfStates = typeBlocks.get(0).getBlockSize();
        for (int i_block = 0; i_block < numberOfBlocks; ++i_block) {
            for (int i_state = 0; i_state < numberOfStates; ++i_state) {
                constraints.append("-").append(mappings.add(ifPredicate, typeBlocks.get(i_block).getState(i_state), typeElement)).append(" ");
                for (int j_block = i_block + 1; j_block < numberOfBlocks; ++j_block) {
                    for (int j_state = i_state + 1; j_state < numberOfBlocks; ++j_state) {
                        constraints.append(mappings.add(thenPredicate, typeBlocks.get(j_block).getState(j_state), typeElement)).append(" ");
                    }
                }
                constraints.append("0\n");
            }
        }
        return constraints.toString();
    }

    public static String itnModule(TaxonomyPredicate ifPredicate, TaxonomyPredicate thenNotPredicate, ModuleAutomaton moduleAutomaton, SATAtomMappings mappings) {
        StringBuilder constraints = new StringBuilder();
        int automatonSize = moduleAutomaton.getAllStates().size();
        for (int i = 0; i < automatonSize - 1; ++i) {
            State currModuleState = moduleAutomaton.getAllStates().get(i);
            for (int j = i + 1; j < automatonSize; ++j) {
                constraints.append("-").append(mappings.add(ifPredicate, currModuleState, AtomType.MODULE)).append(" ");
                constraints.append("-" + mappings.add(thenNotPredicate, moduleAutomaton.get(j), AtomType.MODULE) + " 0\n");
            }
        }
        return constraints.toString();
    }

    public static String itnType(TaxonomyPredicate ifPredicate, TaxonomyPredicate thenNotPredicate, AtomType typeElement, List<Block> typeBlocks, SATAtomMappings mappings) {
        StringBuilder constraints = new StringBuilder();
        int numberOfBlocks = typeBlocks.size();
        int numberOfStates = typeBlocks.get(0).getBlockSize();
        for (int i_block = 0; i_block < numberOfBlocks - 1; ++i_block) {
            for (int i_state = 0; i_state < numberOfStates; ++i_state) {
                for (int j_block = i_block + 1; j_block < numberOfBlocks; ++j_block) {
                    for (int j_state = 0; j_state < numberOfStates; ++j_state) {
                        constraints.append("-").append(mappings.add(ifPredicate, typeBlocks.get(i_block).getState(i_state), typeElement)).append(" ");
                        constraints.append("-").append(mappings.add(thenNotPredicate, typeBlocks.get(j_block).getState(j_state), typeElement)).append(" 0\n");
                    }
                }
            }
        }
        return constraints.toString();
    }

    public static String dependModule(TaxonomyPredicate secondModuleInSequence, TaxonomyPredicate firstModuleInSequence, ModuleAutomaton moduleAutomaton, SATAtomMappings mappings) {
        StringBuilder constraints = new StringBuilder();
        int automatonSize = moduleAutomaton.getAllStates().size();
        for (int i = 0; i < automatonSize; ++i) {
            constraints.append("-").append(mappings.add(secondModuleInSequence, moduleAutomaton.getAllStates().get(i), AtomType.MODULE)).append(" ");
            for (int j = 0; j < i; ++j) {
                constraints.append(mappings.add(firstModuleInSequence, moduleAutomaton.get(j), AtomType.MODULE)).append(" ");
            }
            constraints.append("0\n");
        }
        return constraints.toString();
    }

    public static String nextModule(TaxonomyPredicate firstModuleInSequence, TaxonomyPredicate secondModuleInSequence, ModuleAutomaton moduleAutomaton, SATAtomMappings mappings) {
        StringBuilder constraints = new StringBuilder();
        int automatonSize = moduleAutomaton.getAllStates().size();
        for (int i = 0; i < automatonSize; ++i) {
            constraints.append("-").append(mappings.add(firstModuleInSequence, moduleAutomaton.getAllStates().get(i), AtomType.MODULE)).append(" ");
            if (i < automatonSize - 1) {
                constraints.append(mappings.add(secondModuleInSequence, moduleAutomaton.get(i + 1), AtomType.MODULE)).append(" ");
            }
            constraints.append("0\n");
        }
        return constraints.toString();
    }

    public static String prevModule(TaxonomyPredicate secondModuleInSequence, TaxonomyPredicate firstModuleInSequence, ModuleAutomaton moduleAutomaton, SATAtomMappings mappings) {
        StringBuilder constraints = new StringBuilder();
        int automatonSize = moduleAutomaton.getAllStates().size();
        for (int i = 0; i < automatonSize; ++i) {
            constraints.append("-").append(mappings.add(secondModuleInSequence, moduleAutomaton.getAllStates().get(i), AtomType.MODULE)).append(" ");
            if (i > 0) {
                constraints.append(mappings.add(firstModuleInSequence, moduleAutomaton.get(i - 1), AtomType.MODULE)).append(" ");
            }
            constraints.append("0\n");
        }
        return constraints.toString();
    }

    public static String useAsLastModule(TaxonomyPredicate lastModule, ModuleAutomaton moduleAutomaton, SATAtomMappings mappings) {
        StringBuilder constraints = new StringBuilder();
        List<State> moduleAutomatonStates = moduleAutomaton.getAllStates();
        State lastModuleState = moduleAutomatonStates.get(moduleAutomatonStates.size() - 1);
        constraints.append(mappings.add(lastModule, lastModuleState, AtomType.MODULE)).append(" 0\n");
        return constraints.toString();
    }

    public static String useAsNthModule(TaxonomyPredicate module, int n, ModuleAutomaton moduleAutomaton, SATAtomMappings mappings) {
        StringBuilder constraints = new StringBuilder();
        List<State> moduleAutomatonStates = moduleAutomaton.getAllStates();
        State nthModuleState = moduleAutomatonStates.get(n - 1);
        constraints.append(mappings.add(module, nthModuleState, AtomType.MODULE)).append(" 0\n");
        return constraints.toString();
    }

    public static String useModuleInput(TaxonomyPredicate module, TaxonomyPredicate inputType, ModuleAutomaton moduleAutomaton, TypeAutomaton typeAutomaton, SATAtomMappings mappings) {
        StringBuilder constraints = new StringBuilder();
        HashSet<Integer> allCombinations = new HashSet<Integer>();
        HashMap<Integer, State> opOrderStates = new HashMap<Integer, State>();
        HashMap<Integer, List<State>> opInputs = new HashMap<Integer, List<State>>();
        int automatonSize = moduleAutomaton.getAllStates().size();
        for (int opNo = 0; opNo < automatonSize; ++opNo) {
            int currOp = mappings.getNextAuxNum();
            allCombinations.add(currOp);
            opOrderStates.put(currOp, moduleAutomaton.getAllStates().get(opNo));
            opInputs.put(currOp, typeAutomaton.getUsedTypesBlock(opNo).getStates());
        }
        for (Integer currComb : allCombinations) {
            constraints.append(currComb + " ");
        }
        constraints.append("0\n");
        for (Integer currComb : allCombinations) {
            constraints.append("-" + currComb + " ").append(mappings.add(module, (State)opOrderStates.get(currComb), AtomType.MODULE)).append(" 0\n");
            constraints.append("-" + currComb + " ");
            for (State currState : (List)opInputs.get(currComb)) {
                constraints.append(mappings.add(inputType, currState, AtomType.USED_TYPE)).append(" ");
            }
            constraints.append("0\n");
        }
        return constraints.toString();
    }

    public static String useModuleOutput(TaxonomyPredicate module, TaxonomyPredicate outputType, ModuleAutomaton moduleAutomaton, TypeAutomaton typeAutomaton, SATAtomMappings mappings) {
        StringBuilder constraints = new StringBuilder();
        HashSet<Integer> allCombinations = new HashSet<Integer>();
        HashMap<Integer, State> opOrderStates = new HashMap<Integer, State>();
        HashMap<Integer, List<State>> onOutputs = new HashMap<Integer, List<State>>();
        int automatonSize = moduleAutomaton.getAllStates().size();
        for (int opNo = 0; opNo < automatonSize; ++opNo) {
            int currOp = mappings.getNextAuxNum();
            allCombinations.add(currOp);
            opOrderStates.put(currOp, moduleAutomaton.getAllStates().get(opNo));
            onOutputs.put(currOp, typeAutomaton.getMemoryTypesBlock(opNo + 1).getStates());
        }
        for (Integer currComb : allCombinations) {
            constraints.append(currComb + " ");
        }
        constraints.append("0\n");
        for (Integer currComb : allCombinations) {
            constraints.append("-" + currComb + " ").append(mappings.add(module, (State)opOrderStates.get(currComb), AtomType.MODULE)).append(" 0\n");
            constraints.append("-" + currComb + " ");
            for (State currState : (List)onOutputs.get(currComb)) {
                constraints.append(mappings.add(outputType, currState, AtomType.MEM_TYPE_REFERENCE)).append(" ");
            }
            constraints.append("0\n");
        }
        return constraints.toString();
    }

    public static String connectedModules(TaxonomyPredicate firstPredicate, TaxonomyPredicate secondPredicate, ModuleAutomaton moduleAutomaton, TypeAutomaton typeAutomaton, SATAtomMappings mappings) {
        StringBuilder constraints = new StringBuilder();
        HashSet<Integer> allCombinations = new HashSet<Integer>();
        HashMap<Integer, Pair<State>> opOrderStates = new HashMap<Integer, Pair<State>>();
        HashMap<Integer, Set<Pair<State>>> opOutInPairs = new HashMap<Integer, Set<Pair<State>>>();
        int automatonSize = moduleAutomaton.getAllStates().size();
        for (int op1 = 0; op1 < automatonSize - 1; ++op1) {
            for (int op2 = op1 + 1; op2 < automatonSize; ++op2) {
                int currComb = mappings.getNextAuxNum();
                allCombinations.add(currComb);
                opOrderStates.put(currComb, new Pair<State>(moduleAutomaton.getAllStates().get(op1), moduleAutomaton.getAllStates().get(op2)));
                List<State> op1outputs = typeAutomaton.getMemoryTypesBlock(op1 + 1).getStates();
                List<State> op2inputs = typeAutomaton.getUsedTypesBlock(op2).getStates();
                Set<Pair<State>> statePairs = APEUtils.getUniquePairs(op1outputs, op2inputs);
                opOutInPairs.put(currComb, statePairs);
            }
        }
        for (Integer currComb : allCombinations) {
            constraints.append(currComb + " ");
        }
        constraints.append("0\n");
        for (Integer currComb : allCombinations) {
            constraints.append("-" + currComb + " ").append(mappings.add(firstPredicate, (State)((Pair)opOrderStates.get(currComb)).getFirst(), AtomType.MODULE)).append(" 0\n");
            constraints.append("-" + currComb + " ").append(mappings.add(secondPredicate, (State)((Pair)opOrderStates.get(currComb)).getSecond(), AtomType.MODULE)).append(" 0\n");
            constraints.append("-" + currComb + " ");
            for (Pair currPair : (Set)opOutInPairs.get(currComb)) {
                constraints.append(mappings.add((PredicateLabel)currPair.getFirst(), (State)currPair.getSecond(), AtomType.MEM_TYPE_REFERENCE)).append(" ");
            }
            constraints.append("0\n");
        }
        return constraints.toString();
    }

    public static String notConnectedModules(TaxonomyPredicate firstPredicate, TaxonomyPredicate secondPredicate, ModuleAutomaton moduleAutomaton, TypeAutomaton typeAutomaton, SATAtomMappings mappings) {
        StringBuilder constraints = new StringBuilder();
        int automatonSize = moduleAutomaton.getAllStates().size();
        for (int op1 = 0; op1 < automatonSize - 1; ++op1) {
            for (int op2 = op1 + 1; op2 < automatonSize; ++op2) {
                State firstModuleState = moduleAutomaton.get(op1);
                State secondModuleState = moduleAutomaton.get(op2);
                List<State> op1outputs = typeAutomaton.getMemoryTypesBlock(op1 + 1).getStates();
                List<State> op2inputs = typeAutomaton.getUsedTypesBlock(op2).getStates();
                Set<Pair<State>> statePairs = APEUtils.getUniquePairs(op1outputs, op2inputs);
                for (Pair<State> currIOpair : statePairs) {
                    constraints.append("-").append(mappings.add(firstPredicate, firstModuleState, AtomType.MODULE)).append(" ");
                    constraints.append("-" + mappings.add(currIOpair.getFirst(), currIOpair.getSecond(), AtomType.MEM_TYPE_REFERENCE) + " ");
                    constraints.append("-" + mappings.add(secondPredicate, secondModuleState, AtomType.MODULE) + " 0\n");
                }
            }
        }
        return constraints.toString();
    }

    public static String notRepeatModules(TaxonomyPredicate predicate, APEDomainSetup domainSetup, ModuleAutomaton moduleAutomaton, TypeAutomaton typeAutomaton, SATAtomMappings mappings) {
        StringBuilder constraints = new StringBuilder();
        int automatonSize = moduleAutomaton.getAllStates().size();
        for (int op1 = 0; op1 < automatonSize - 1; ++op1) {
            for (int op2 = op1 + 1; op2 < automatonSize; ++op2) {
                State firstModuleState = moduleAutomaton.get(op1);
                State secondModuleState = moduleAutomaton.get(op2);
                List<State> op1outputs = typeAutomaton.getMemoryTypesBlock(op1 + 1).getStates();
                List<State> op2inputs = typeAutomaton.getUsedTypesBlock(op2).getStates();
                Set<Pair<State>> statePairs = APEUtils.getUniquePairs(op1outputs, op2inputs);
                for (Pair<State> currIOpair : statePairs) {
                    domainSetup.getAllModules().getElementsFromSubTaxonomy(predicate).stream().filter(x -> x.isSimplePredicate()).forEach(operation -> {
                        constraints.append("-").append(mappings.add((PredicateLabel)operation, firstModuleState, AtomType.MODULE)).append(" ");
                        constraints.append("-" + mappings.add((PredicateLabel)currIOpair.getFirst(), (State)currIOpair.getSecond(), AtomType.MEM_TYPE_REFERENCE) + " ");
                        constraints.append("-" + mappings.add((PredicateLabel)operation, secondModuleState, AtomType.MODULE) + " 0\n");
                    });
                }
            }
        }
        return constraints.toString();
    }

    private static String combine(int int1, int int2) {
        return int1 + "_" + int2;
    }
}

