/*
 * Decompiled with CFR 0.152.
 */
package nl.uu.cs.ape.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.IntStream;
import nl.uu.cs.ape.automaton.ModuleAutomaton;
import nl.uu.cs.ape.automaton.TypeAutomaton;
import nl.uu.cs.ape.configuration.APERunConfig;
import nl.uu.cs.ape.core.implSAT.SATSynthesisEngine;
import nl.uu.cs.ape.models.ConstraintTemplateData;
import nl.uu.cs.ape.models.Module;
import nl.uu.cs.ape.models.Pair;
import nl.uu.cs.ape.models.SATAtomMappings;
import nl.uu.cs.ape.models.Type;
import nl.uu.cs.ape.models.enums.LogicOperation;
import nl.uu.cs.ape.models.logic.constructs.PredicateLabel;
import nl.uu.cs.ape.models.logic.constructs.TaxonomyPredicate;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxAtom;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxAtomVar;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxFormula;
import nl.uu.cs.ape.parser.SLTLxSATVisitor;
import nl.uu.cs.ape.utils.APEDomainSetup;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class APEUtils {
    private static final Logger log = LoggerFactory.getLogger(APEUtils.class);
    private static final Map<String, Long> timers = new HashMap<String, Long>();
    private static final PrintStream original = System.err;
    private static final PrintStream nullStream = new PrintStream(new OutputStream(){

        @Override
        public void write(int b) {
        }
    });

    private APEUtils() {
        throw new UnsupportedOperationException();
    }

    public static String encodeAPEConstraints(SATSynthesisEngine synthesisEngine, APEDomainSetup domainSetup, SATAtomMappings mappings, ModuleAutomaton moduleAutomaton, TypeAutomaton typeAutomaton) {
        StringBuilder cnf_SLTL = new StringBuilder();
        int currConst = 0;
        for (ConstraintTemplateData constraintTemplateData : domainSetup.getUnformattedConstr()) {
            ++currConst;
            if (domainSetup.getConstraintTemplate(constraintTemplateData.getConstraintID()) == null) {
                log.warn("Constraint ID provided: '" + constraintTemplateData.getConstraintID() + "' is not valid. Constraint skipped.");
                continue;
            }
            String currConstrEncoding = APEUtils.constraintSATEncoding(constraintTemplateData.getConstraintID(), constraintTemplateData.getParameters(), domainSetup, moduleAutomaton, typeAutomaton, mappings);
            if (currConstrEncoding == null) {
                log.warn("Error in constraint file. Constraint no: " + currConst + ". Constraint skipped.");
                continue;
            }
            cnf_SLTL.append(currConstrEncoding);
        }
        for (String string : domainSetup.getSLTLxConstraints()) {
            Set<SLTLxFormula> sltlxFormulas = SLTLxSATVisitor.parseFormula(synthesisEngine, string);
            for (SLTLxFormula sltlxFormula : sltlxFormulas) {
                sltlxFormula.getConstraintCNFEncoding(synthesisEngine).forEach(cnf_SLTL::append);
            }
        }
        return cnf_SLTL.toString();
    }

    public static String constraintSATEncoding(String constraintID, List<TaxonomyPredicate> list, APEDomainSetup domainSetup, ModuleAutomaton moduleAutomaton, TypeAutomaton typeAutomaton, SATAtomMappings mappings) {
        return domainSetup.getConstraintTemplate(constraintID).getConstraint(list, domainSetup, moduleAutomaton, typeAutomaton, mappings);
    }

    public static String createClassIRI(String label, String ontologyPrefixIRI) throws IllegalArgumentException {
        if (label == null || label.equals("")) {
            throw new IllegalArgumentException("The OWL object label cannot be an empty String.");
        }
        if (label.startsWith("http")) {
            return label;
        }
        return ontologyPrefixIRI + label;
    }

    public static Set<String> createIRIsFromLabels(Set<String> taxonomyTerms, String ontologyPrefixIRI) {
        HashSet<String> taxonomyTermIRIs = new HashSet<String>();
        for (String taxonomyTermLabel : taxonomyTerms) {
            taxonomyTermIRIs.add(APEUtils.createClassIRI(taxonomyTermLabel, ontologyPrefixIRI));
        }
        return taxonomyTermIRIs;
    }

    public static List<JSONObject> getListFromJson(File jsonFile, String key) throws IOException, JSONException {
        String content = FileUtils.readFileToString((File)jsonFile, (Charset)StandardCharsets.UTF_8);
        JSONObject jsonObject = new JSONObject(content);
        return APEUtils.getListFromJson(jsonObject, key, JSONObject.class);
    }

    public static <T> List<T> getListFromJson(JSONObject jsonObject, String key, Class<T> clazz) {
        List<Object> jsonList = new ArrayList<Object>();
        try {
            Object tmp = jsonObject.get(key);
            try {
                if (tmp instanceof JSONArray) {
                    jsonList = APEUtils.getListFromJsonList((JSONArray)tmp, clazz);
                } else {
                    Object element = tmp;
                    jsonList.add(element);
                }
            }
            catch (JSONException e) {
                log.warn("Json parsing error. Expected object '" + clazz.getSimpleName() + "' under the tag '" + key + "'. The following object does not match the provided format:\n" + jsonObject.toString());
                return jsonList;
            }
            return jsonList;
        }
        catch (JSONException e) {
            return jsonList;
        }
    }

    public static <T> List<T> getListFromJsonList(JSONArray jsonArray, Class<T> clazz) {
        ArrayList<Object> newList = new ArrayList<Object>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            Object element = jsonArray.get(i);
            newList.add(element);
        }
        return newList;
    }

    /*
     * WARNING - void declaration
     */
    public static void debugPrintout(APERunConfig runConfig, APEDomainSetup domainSetup) {
        String line = "-------------------------------------------------------------";
        if (runConfig.getDebugMode()) {
            log.debug(line);
            log.debug("\tConstraint templates:");
            log.debug(line);
            log.debug(domainSetup.getConstraintFactory().printConstraintsCodes() + "\n");
            log.debug(line);
            log.debug("\tTool Taxonomy:");
            log.debug(line);
            domainSetup.getAllModules().getRootModule().printTree(" ", domainSetup.getAllModules());
            log.debug("\n" + line);
            log.debug("\tData Taxonomy dimensions:");
            for (TaxonomyPredicate taxonomyPredicate : domainSetup.getAllTypes().getRootPredicates()) {
                log.debug("\n" + line);
                log.debug("\t" + taxonomyPredicate.getPredicateLabel() + "Taxonomy:");
                log.debug(line);
                taxonomyPredicate.printTree(" ", domainSetup.getAllTypes());
            }
            log.debug(line);
            log.debug("\tLabels Taxonomy:");
            log.debug(line);
            domainSetup.getAllTypes().getLabelRoot().printTree(" ", domainSetup.getAllTypes());
            boolean noTools = true;
            log.debug(line);
            log.debug("\tAnnotated tools:");
            log.debug(line);
            for (TaxonomyPredicate module : domainSetup.getAllModules().getModules()) {
                if (!(module instanceof Module)) continue;
                log.debug(module.toString());
                noTools = false;
            }
            if (noTools) {
                log.debug("\tNo annotated tools.");
            }
            log.debug(line);
            log.debug("\tConstraints:");
            log.debug(line);
            for (ConstraintTemplateData constr : domainSetup.getUnformattedConstr()) {
                log.debug(domainSetup.getConstraintFactory().getDescription(constr));
            }
            if (domainSetup.getUnformattedConstr().isEmpty()) {
                log.debug("\tNo constraints.");
            }
            log.debug(line);
            boolean bl = true;
            for (Type input : runConfig.getProgramInputs()) {
                void var4_9;
                log.debug((int)(++var4_9) + ". program input is " + input.toShortString());
            }
            log.debug(line);
            boolean bl2 = true;
            for (Type output : runConfig.getProgramOutputs()) {
                void var4_11;
                log.debug((int)(++var4_11) + ". program output is " + output.toShortString());
            }
            log.debug(line);
        }
    }

    public static void printHeader(Integer argument, String ... title) {
        String line = "-------------------------------------------------------------";
        String arg = argument == null ? "" : " " + argument;
        log.info(line);
        log.info("\t" + title[0] + arg);
        if (title.length > 1) {
            log.info("\t" + title[1] + arg);
        }
        log.info(line);
    }

    public static <E> Collection<E> safe(Collection<E> currList) {
        return currList == null ? Collections.emptyList() : currList;
    }

    public static <E> E safeGet(List<E> currList, int index) {
        if (currList == null || index < 0 || currList.size() <= index) {
            return null;
        }
        return currList.get(index);
    }

    public static <E> void safeSet(List<E> list, int index, E element) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (list.size() == index) {
            list.add(element);
        } else if (list.size() >= index) {
            list.set(index, element);
        }
        if (list.size() < index) {
            for (int i = list.size(); i < index; ++i) {
                list.add(null);
            }
            list.add(element);
        }
    }

    public static int countNewLines(String inputString) throws IOException {
        try (InputStream stream = IOUtils.toInputStream((String)inputString, (Charset)StandardCharsets.UTF_8);){
            int i;
            byte[] c = new byte[1024];
            int readChars = stream.read(c);
            if (readChars == -1) {
                int n = 1;
                return n;
            }
            int count = 0;
            while (readChars == 1024) {
                i = 0;
                while (i < 1024) {
                    if (c[i++] != 10) continue;
                    ++count;
                }
                readChars = stream.read(c);
            }
            while (readChars != -1) {
                for (i = 0; i < readChars; ++i) {
                    if (c[i] != 10) continue;
                    ++count;
                }
                readChars = stream.read(c);
            }
            int n = count == 0 ? 1 : count;
            return n;
        }
    }

    public static void timerStart(String timerID, Boolean debugMode) {
        if (Boolean.TRUE.equals(debugMode)) {
            timers.put(timerID, System.currentTimeMillis());
        } else {
            timers.put(timerID, -1L);
        }
    }

    public static long timerTimeLeft(String timerID, long timeout) {
        if (timers.get(timerID) == -1L) {
            return 0L;
        }
        long elapsedTimeMs = System.currentTimeMillis() - timers.get(timerID);
        return timeout - elapsedTimeMs;
    }

    public static void timerRestartAndPrint(String timerID, String printString) {
        if (timers.get(timerID) == -1L) {
            return;
        }
        long printTime = System.currentTimeMillis() - timers.get(timerID);
        log.info(printString + " setup time: " + (float)printTime / 1000.0f + " sec.");
        timers.put(timerID, System.currentTimeMillis());
    }

    public static long timerPrintSolutions(String timerID, int solutionsFound) {
        if (timers.get(timerID) == -1L) {
            return -1L;
        }
        long printTime = System.currentTimeMillis() - timers.get(timerID);
        log.info("APE found " + solutionsFound + " solutions.");
        log.info("Total APE runtime: \t\t" + (float)printTime / 1000.0f + " sec.");
        log.info("Total encoding time: \t\t" + SATSynthesisEngine.encodingTime / 1000.0 + " sec.");
        log.info("Total SAT solving time: \t" + SATSynthesisEngine.satSolvingTime / 1000.0 + " sec.");
        return printTime;
    }

    public static void timerPrintText(String timerID, String text) {
        if (timers.get(timerID) == -1L) {
            return;
        }
        long printTime = System.currentTimeMillis() - timers.get(timerID);
        log.info(text + " Running time: " + (float)printTime / 1000.0f + " sec.");
    }

    public static String convertCNF2humanReadable(InputStream temp_sat_input, SATAtomMappings mappings) {
        StringBuilder humanReadable = new StringBuilder();
        Scanner scanner = new Scanner(temp_sat_input);
        scanner.nextLine();
        while (scanner.hasNextInt()) {
            SLTLxAtomVar varAtom;
            SLTLxAtom atom;
            int intAtom = scanner.nextInt();
            if (intAtom == 0) {
                humanReadable.append("\n");
                continue;
            }
            if (intAtom > -3 & intAtom < 3) {
                if (intAtom == 1 || intAtom == -2) {
                    humanReadable.append("true ");
                    continue;
                }
                humanReadable.append("false ");
                continue;
            }
            if (intAtom > 0) {
                atom = mappings.findOriginal(intAtom);
                if (atom == null) {
                    varAtom = mappings.findOriginalVar(intAtom);
                    humanReadable.append(varAtom.toString()).append(" ");
                    continue;
                }
                humanReadable.append(atom.toString()).append(" ");
                continue;
            }
            if (intAtom >= 0) continue;
            atom = mappings.findOriginal(-intAtom);
            if (atom == null) {
                varAtom = mappings.findOriginalVar(-intAtom);
                if (varAtom == null) {
                    log.error("Error: Could not find atom for " + intAtom);
                    continue;
                }
                humanReadable.append("-").append(varAtom.toString()).append(" ");
                continue;
            }
            humanReadable.append("-").append(atom.toString()).append(" ");
        }
        scanner.close();
        return humanReadable.toString();
    }

    public static String removeLastChar(String str) {
        if (str != null && str.length() > 0) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    public static String removeNLastChar(String str, int n) {
        if (str != null && str.length() > 0) {
            str = str.substring(0, str.length() - n);
        }
        return str;
    }

    public static String getLabelFromList(SortedSet<TaxonomyPredicate> relatedPredicates, LogicOperation logicOp) {
        StringBuilder abstractLabel = new StringBuilder(logicOp.toStringSign());
        for (TaxonomyPredicate label : relatedPredicates) {
            abstractLabel.append(label.getPredicateLabel()).append(logicOp.toStringSign());
        }
        return abstractLabel.toString();
    }

    public static void printWarning(String message, Object ... params) {
        log.warn("\u001b[35mWARNING: " + String.format(message, params) + "\u001b[0m");
    }

    public static void disableErr() {
        System.setErr(nullStream);
    }

    public static void enableErr() {
        System.setErr(original);
    }

    public static JSONObject clone(JSONObject original) {
        return new JSONObject(original, JSONObject.getNames((JSONObject)original));
    }

    public static int countLines(File cnfEncoding) {
        int lines = 0;
        try (BufferedReader b = new BufferedReader(new FileReader(cnfEncoding));){
            while (b.readLine() != null) {
                ++lines;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return lines;
    }

    public static void printMemoryStatus(boolean debugMode) {
        if (!debugMode) {
            return;
        }
        double currMemMB = (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L / 1024L;
        double totalMemMB = Runtime.getRuntime().totalMemory() / 1024L / 1024L;
        double oneCharValueMB = 100.0;
        int currMemChars = (int)Math.ceil(currMemMB / oneCharValueMB);
        int totalMemChars = (int)Math.ceil(totalMemMB / oneCharValueMB);
        StringBuilder memoryStatus = new StringBuilder();
        IntStream.range(0, currMemChars).forEach(step -> memoryStatus.append("#"));
        IntStream.range(currMemChars, totalMemChars).forEach(step -> memoryStatus.append(" "));
        log.info("\n[" + memoryStatus.toString() + "]\t" + totalMemMB + "\tMB \r");
    }

    public static Set<Pair<PredicateLabel>> getUniquePairs(Collection<? extends PredicateLabel> set) {
        HashSet<Pair<PredicateLabel>> pairs = new HashSet<Pair<PredicateLabel>>();
        set.stream().forEach(ele1 -> set.stream().filter(ele2 -> ele1.compareTo(ele2) < 0).forEach(ele2 -> pairs.add(new Pair<PredicateLabel>((PredicateLabel)ele1, (PredicateLabel)ele2))));
        return pairs;
    }

    public static <T> Set<Pair<T>> getUniquePairs(Collection<T> set1, Collection<T> set2) {
        HashSet pairs = new HashSet();
        set1.stream().forEach(ele1 -> set2.stream().forEach(ele2 -> pairs.add(new Pair<Object>(ele1, ele2))));
        return pairs;
    }
}

