/*
 * Decompiled with CFR 0.152.
 */
package nl.uu.cs.ape;

import guru.nidi.graphviz.attribute.Rank;
import guru.nidi.graphviz.engine.Format;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.SortedSet;
import nl.uu.cs.ape.APEInterface;
import nl.uu.cs.ape.configuration.APEConfigException;
import nl.uu.cs.ape.configuration.APECoreConfig;
import nl.uu.cs.ape.configuration.APERunConfig;
import nl.uu.cs.ape.configuration.tags.validation.ValidationResults;
import nl.uu.cs.ape.constraints.ConstraintTemplate;
import nl.uu.cs.ape.domain.APEDimensionsException;
import nl.uu.cs.ape.domain.APEDomainSetup;
import nl.uu.cs.ape.domain.OWLReader;
import nl.uu.cs.ape.models.enums.SynthesisFlag;
import nl.uu.cs.ape.models.logic.constructs.TaxonomyPredicate;
import nl.uu.cs.ape.solver.minisat.SATSynthesisEngine;
import nl.uu.cs.ape.solver.solutionStructure.SolutionWorkflow;
import nl.uu.cs.ape.solver.solutionStructure.SolutionsList;
import nl.uu.cs.ape.solver.solutionStructure.cwl.DefaultCWLCreator;
import nl.uu.cs.ape.utils.APEFiles;
import nl.uu.cs.ape.utils.APEUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class APE
implements APEInterface {
    private static final Logger log = LoggerFactory.getLogger(APE.class);
    private final APECoreConfig config;
    private APEDomainSetup apeDomainSetup;

    public APE(String configPath) throws IOException, OWLOntologyCreationException {
        this.config = new APECoreConfig(configPath);
        boolean setupSucc = this.setupDomain();
        if (!setupSucc) {
            throw new APEConfigException("Error setting up the domain.");
        }
    }

    public APE(JSONObject configObject) throws IOException, OWLOntologyCreationException {
        this.config = new APECoreConfig(configObject);
        boolean setupSucc = this.setupDomain();
        if (!setupSucc) {
            throw new APEConfigException("Error in setting up the domain.");
        }
    }

    public APE(APECoreConfig config) throws IOException, OWLOntologyCreationException {
        this.config = config;
        boolean setupSucc = this.setupDomain();
        if (!setupSucc) {
            throw new APEConfigException("Error in setting up the domain.");
        }
    }

    private boolean setupDomain() throws APEDimensionsException, IOException, OWLOntologyCreationException {
        boolean succRun = true;
        this.apeDomainSetup = new APEDomainSetup(this.config);
        OWLReader owlReader = new OWLReader(this.apeDomainSetup, this.config.getOntologyFile());
        boolean ontologyRead = owlReader.readOntology();
        if (!ontologyRead) {
            log.warn("Error occurred while reading the provided ontology.");
            return false;
        }
        succRun &= this.apeDomainSetup.annotateToolFromJson(APEFiles.readFileToJSONObject(this.config.getToolAnnotationsFile()));
        this.apeDomainSetup.initializeConstraints();
        return succRun &= this.apeDomainSetup.trimTaxonomy();
    }

    @Override
    public Collection<ConstraintTemplate> getConstraintTemplates() {
        return this.apeDomainSetup.getConstraintFactory().getConstraintTemplates();
    }

    @Override
    public APECoreConfig getConfig() {
        return this.config;
    }

    @Override
    public APEDomainSetup getDomainSetup() {
        return this.apeDomainSetup;
    }

    @Override
    public SortedSet<TaxonomyPredicate> getTaxonomySubclasses(String taxonomyElementID) {
        SortedSet<TaxonomyPredicate> elements = null;
        TaxonomyPredicate root = this.apeDomainSetup.getAllTypes().get(taxonomyElementID);
        if (root != null) {
            elements = this.apeDomainSetup.getAllTypes().getElementsFromSubTaxonomy(root);
        } else {
            root = this.apeDomainSetup.getAllModules().get(taxonomyElementID);
            if (root != null) {
                elements = this.apeDomainSetup.getAllModules().getElementsFromSubTaxonomy(root);
            }
        }
        if (root == null) {
            return this.getTaxonomySubclasses(APEUtils.createClassIRI(taxonomyElementID, this.apeDomainSetup.getOntologyPrefixIRI()));
        }
        return elements;
    }

    @Override
    public TaxonomyPredicate getTaxonomyElement(String taxonomyElementID) {
        TaxonomyPredicate element = this.apeDomainSetup.getAllTypes().get(taxonomyElementID);
        if (element == null) {
            element = this.apeDomainSetup.getAllModules().get(taxonomyElementID);
        }
        if (element == null) {
            return this.getTaxonomyElement(APEUtils.createClassIRI(taxonomyElementID, this.apeDomainSetup.getOntologyPrefixIRI()));
        }
        return element;
    }

    @Override
    public SolutionsList runSynthesis(JSONObject configObject) throws IOException, APEConfigException {
        return this.runSynthesis(configObject, this.getDomainSetup());
    }

    @Override
    public SolutionsList runSynthesis(String runConfigPath) throws IOException, JSONException, APEConfigException {
        JSONObject configObject = APEFiles.readFileToJSONObject(new File(runConfigPath));
        return this.runSynthesis(configObject, this.getDomainSetup());
    }

    @Override
    public SolutionsList runSynthesis(APERunConfig runConfig) throws IOException, JSONException {
        runConfig.getApeDomainSetup().clearConstraints();
        return this.executeSynthesis(runConfig);
    }

    private SolutionsList runSynthesis(JSONObject runConfigJson, APEDomainSetup apeDomainSetup) throws IOException, JSONException, APEConfigException {
        apeDomainSetup.clearConstraints();
        APERunConfig runConfig = new APERunConfig(runConfigJson, apeDomainSetup);
        return this.executeSynthesis(runConfig);
    }

    private SolutionsList executeSynthesis(APERunConfig runConfig) throws IOException, JSONException {
        int solutionLength;
        SolutionsList allSolutions = new SolutionsList(runConfig);
        this.apeDomainSetup.updateConstraints(runConfig.getConstraintsJSON());
        APEUtils.debugPrintout(runConfig, this.apeDomainSetup);
        String globalTimerID = "globalTimer";
        APEUtils.timerStart(globalTimerID, true);
        for (solutionLength = runConfig.getSolutionLength().getMin(); allSolutions.getNumberOfSolutions() < allSolutions.getMaxNumberOfSolutions() && solutionLength <= runConfig.getSolutionLength().getMax() && APEUtils.timerTimeLeft(globalTimerID, runConfig.getTimeoutMs()) > 0L; ++solutionLength) {
            SATSynthesisEngine implSynthesis = new SATSynthesisEngine(this.apeDomainSetup, allSolutions, runConfig, solutionLength);
            APEUtils.printHeader(implSynthesis.getSolutionSize(), "Workflow discovery - length");
            if (!implSynthesis.synthesisEncoding()) {
                log.error("Internal error in problem encoding.");
                return null;
            }
            allSolutions.addSolutions(implSynthesis.synthesisExecution());
            implSynthesis.deleteTempFiles();
            allSolutions.addNoSolutionsForLength(solutionLength, allSolutions.getNumberOfSolutions());
        }
        if (allSolutions.getNumberOfSolutions() >= allSolutions.getMaxNumberOfSolutions() - 1) {
            allSolutions.setFlag(SynthesisFlag.NONE);
        } else if (APEUtils.timerTimeLeft(globalTimerID, runConfig.getTimeoutMs()) <= 0L) {
            allSolutions.setFlag(SynthesisFlag.TIMEOUT);
        } else if (allSolutions.getNumberOfSolutions() == 0) {
            allSolutions.setFlag(SynthesisFlag.UNSAT);
        } else if (solutionLength >= runConfig.getSolutionLength().getMax()) {
            allSolutions.setFlag(SynthesisFlag.MAX_LENGTH);
        } else {
            allSolutions.setFlag(SynthesisFlag.UNKNOWN);
        }
        log.info(allSolutions.getFlag().getMessage());
        long runTimeMS = APEUtils.timerPrintSolutions(globalTimerID, allSolutions.getNumberOfSolutions());
        allSolutions.setSolvingTime(runTimeMS);
        return allSolutions;
    }

    public static ValidationResults validate(JSONObject config) {
        ValidationResults results = APECoreConfig.validate(config);
        if (results.hasFails()) {
            return results;
        }
        try {
            APE ape = new APE(config);
            results.add(APERunConfig.validate(config, ape.getDomainSetup()));
        }
        catch (IOException | OWLOntologyCreationException ignored) {
            results.add("ape_setup", "Configuration should be used to setup APE.", false);
        }
        return results;
    }

    public static boolean writeSolutionToFile(SolutionsList allSolutions) throws IOException {
        StringBuilder solutions2write = new StringBuilder();
        for (int i = 0; i < allSolutions.size(); ++i) {
            solutions2write.append(allSolutions.get(i).getNativeSolution().getCompleteSolution()).append("\n");
        }
        APEFiles.write2file(solutions2write.toString(), allSolutions.getRunConfiguration().getSolutionDirPath2("solutions.txt").toFile(), false);
        return true;
    }

    public static boolean writeExecutableWorkflows(SolutionsList allSolutions) {
        Path executionsFolder = allSolutions.getRunConfiguration().getSolutionDirPath2Executables();
        Integer noExecutions = allSolutions.getRunConfiguration().getNoExecutions();
        if (executionsFolder == null || noExecutions == null || noExecutions == 0 || allSolutions.isEmpty()) {
            return false;
        }
        APEUtils.printHeader(null, "Executing first " + noExecutions + " solution");
        APEUtils.timerStart("executingWorkflows", true);
        File executeDir = executionsFolder.toFile();
        if (executeDir.isDirectory()) {
            APE.deleteExistingFiles(executeDir, SolutionWorkflow.getFileNamePrefix(), "sh");
        } else {
            executeDir.mkdir();
        }
        log.debug("Generating executable scripts.");
        allSolutions.getParallelStream().filter(solution -> solution.getIndex() < noExecutions).forEach(solution -> {
            try {
                File script = executionsFolder.resolve(solution.getFileName() + ".sh").toFile();
                APEFiles.write2file(solution.getScriptExecution(), script, false);
            }
            catch (IOException e) {
                log.error("Error occurred while writing an executable (workflow) script to the file system.");
                e.printStackTrace();
            }
        });
        APEUtils.timerPrintText("executingWorkflows", "Workflow executables have been generated.");
        return true;
    }

    public static boolean writeDataFlowGraphs(SolutionsList allSolutions) {
        return APE.writeDataFlowGraphs(allSolutions, Rank.RankDir.TOP_TO_BOTTOM);
    }

    public static boolean writeDataFlowGraphs(SolutionsList allSolutions, Rank.RankDir orientation) {
        Path graphsFolder = allSolutions.getRunConfiguration().getSolutionDirPath2Figures();
        Integer noGraphs = allSolutions.getRunConfiguration().getNoGraphs();
        if (graphsFolder == null || noGraphs == null || noGraphs == 0 || allSolutions.isEmpty()) {
            return false;
        }
        APEUtils.printHeader(null, "Generating graphical representation", "of the first " + noGraphs + " workflows");
        APEUtils.timerStart("drawingGraphs", true);
        File graphDir = graphsFolder.toFile();
        if (graphDir.isDirectory()) {
            APE.deleteExistingFiles(graphDir, SolutionWorkflow.getFileNamePrefix(), "png");
        } else {
            graphDir.mkdir();
        }
        log.debug("Generating data flow graphs (png).");
        allSolutions.getParallelStream().filter(solution -> solution.getIndex() < noGraphs).forEach(solution -> {
            try {
                String title = solution.getFileName();
                Path path = graphsFolder.resolve(title);
                solution.getDataflowGraph(title, orientation).write2File(path.toFile(), Format.PNG, allSolutions.getRunConfiguration().getDebugMode());
            }
            catch (IOException e) {
                log.error("Error occurred while data flow graphs (png) to the file system.");
                e.printStackTrace();
            }
        });
        APEUtils.timerPrintText("drawingGraphs", "Graphical files have been generated.");
        return true;
    }

    public static boolean writeTavernaDesignGraphs(SolutionsList allSolutions) {
        return APE.writeTavernaDesignGraphs(allSolutions, Format.PNG);
    }

    public static boolean writeTavernaDesignGraphs(SolutionsList allSolutions, Format format) {
        Path graphsFolder = allSolutions.getRunConfiguration().getSolutionDirPath2Figures();
        Integer noGraphs = allSolutions.getRunConfiguration().getNoGraphs();
        if (graphsFolder == null || noGraphs == null || noGraphs == 0 || allSolutions.isEmpty()) {
            return false;
        }
        APEUtils.printHeader(null, "Generating graphical representation", "of the first " + noGraphs + " workflows");
        APEUtils.timerStart("drawingGraphs", true);
        File graphDir = graphsFolder.toFile();
        if (graphDir.isDirectory()) {
            APE.deleteExistingFiles(graphDir, SolutionWorkflow.getFileNamePrefix(), format.fileExtension);
        } else {
            graphDir.mkdir();
        }
        log.debug("Generating data flow graphs (png).");
        allSolutions.getParallelStream().filter(solution -> solution.getIndex() < noGraphs).forEach(solution -> {
            try {
                String title = solution.getFileName();
                Path path = graphsFolder.resolve(title);
                solution.getTavernaStyleGraph(title).write2File(path.toFile(), format, allSolutions.getRunConfiguration().getDebugMode());
            }
            catch (IOException e) {
                log.error("Error occurred while data flow graphs (png) to the file system.");
                e.printStackTrace();
            }
        });
        APEUtils.timerPrintText("drawingGraphs", "Graphical files have been generated.");
        return true;
    }

    public static boolean writeControlFlowGraphs(SolutionsList allSolutions) {
        return APE.writeControlFlowGraphs(allSolutions, Rank.RankDir.LEFT_TO_RIGHT);
    }

    public static boolean writeControlFlowGraphs(SolutionsList allSolutions, Rank.RankDir orientation) {
        Path graphsFolder = allSolutions.getRunConfiguration().getSolutionDirPath2Figures();
        Integer noGraphs = allSolutions.getRunConfiguration().getNoGraphs();
        if (graphsFolder == null || noGraphs == null || noGraphs == 0 || allSolutions.isEmpty()) {
            return false;
        }
        APEUtils.printHeader(null, "Generating graphical representation", "of the first " + noGraphs + " workflows");
        APEUtils.timerStart("drawingGraphs", true);
        File graphDir = graphsFolder.toFile();
        if (graphDir.isDirectory()) {
            APE.deleteExistingFiles(graphDir, SolutionWorkflow.getFileNamePrefix(), "png");
        } else {
            graphDir.mkdir();
        }
        log.debug("Generating control flow graphs (png).");
        allSolutions.getParallelStream().filter(solution -> solution.getIndex() < noGraphs).forEach(solution -> {
            try {
                String title = solution.getFileName();
                Path path = graphsFolder.resolve(title);
                solution.getControlflowGraph(title, orientation).write2File(path.toFile(), Format.PNG, allSolutions.getRunConfiguration().getDebugMode());
            }
            catch (IOException e) {
                log.error("Error occurred while writing control flow graphs (png) to the file system.");
                e.printStackTrace();
            }
        });
        APEUtils.timerPrintText("drawingGraphs", "Graphical files have been generated.");
        return true;
    }

    public static boolean writeCWLWorkflows(SolutionsList allSolutions) {
        if (allSolutions.isEmpty()) {
            return false;
        }
        Path cwlFolder = allSolutions.getRunConfiguration().getSolutionDirPath2CWL();
        int noCWLFiles = allSolutions.getRunConfiguration().getNoCWL();
        if (cwlFolder == null || noCWLFiles == 0 || allSolutions.isEmpty()) {
            return false;
        }
        String timerID = "writingCWL";
        APEUtils.printHeader(null, String.format("Writing the first %o solution(s) to CWL files", noCWLFiles));
        APEUtils.timerStart("writingCWL", true);
        File cwlDir = cwlFolder.toFile();
        if (cwlDir.isDirectory()) {
            APE.deleteExistingFiles(cwlDir, SolutionWorkflow.getFileNamePrefix(), "cwl");
        } else {
            cwlDir.mkdir();
        }
        log.debug("Generating CWL files.");
        allSolutions.getParallelStream().filter(solution -> solution.getIndex() < noCWLFiles).forEach(solution -> {
            try {
                String titleCWL = solution.getFileName() + ".cwl";
                File script = cwlFolder.resolve(titleCWL).toFile();
                DefaultCWLCreator cwlCreator = new DefaultCWLCreator((SolutionWorkflow)solution);
                APEFiles.write2file(cwlCreator.generate(), script, false);
            }
            catch (IOException e) {
                log.error("Error occurred while writing a CWL file to the file system.");
                e.printStackTrace();
            }
        });
        String titleInputs = "input.yml";
        File inputScipt = cwlFolder.resolve(titleInputs).toFile();
        DefaultCWLCreator cwlCreator = new DefaultCWLCreator(allSolutions.get(0));
        try {
            APEFiles.write2file(cwlCreator.generateCWLWorkflowInputs(), inputScipt, false);
        }
        catch (IOException e) {
            log.error("Error occurred while writing a CWL input file (yml) to the file system.");
            e.printStackTrace();
        }
        APEUtils.timerPrintText("writingCWL", "CWL files have been generated.");
        return true;
    }

    private static void deleteExistingFiles(File dirName, String filePrefix, String fileExtension) {
        File[] oldFiles = dirName.listFiles((dir, fileName) -> fileName.toLowerCase().startsWith(filePrefix.toLowerCase()) && fileName.toLowerCase().endsWith(fileExtension.toLowerCase()));
        if (oldFiles != null) {
            Arrays.stream(oldFiles).forEach(f -> {
                try {
                    Files.delete(f.toPath());
                }
                catch (IOException e) {
                    log.warn("Failed to delete file {}.", (Object)f.getName());
                }
            });
        }
    }
}

