/*
 * Decompiled with CFR 0.152.
 */
package nl.uu.cs.ape;

import guru.nidi.graphviz.engine.Format;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import nl.uu.cs.ape.APE;
import nl.uu.cs.ape.configuration.APEConfigException;
import nl.uu.cs.ape.configuration.APECoreConfig;
import nl.uu.cs.ape.configuration.APERunConfig;
import nl.uu.cs.ape.domain.BioToolsAPI;
import nl.uu.cs.ape.solver.solutionStructure.SolutionsList;
import nl.uu.cs.ape.utils.APEFiles;
import nl.uu.cs.ape.utils.APEUtils;
import org.apache.commons.io.FileUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalRun {
    private static final Logger log = LoggerFactory.getLogger(LocalRun.class);
    private static String localRepo = "/Users/vedran/git/APE_repo/APE_UseCases/";

    public static void main(String[] args) throws JSONException, APEConfigException, IOException, OWLOntologyCreationException {
        LocalRun.exampleLocal("wombat");
    }

    private static void getWombatBioTools() throws IOException {
        String root = "/Users/vedran/git/Workflomics_repo/domain-annotations/WombatP_tools/";
        String toolNames = "tools.json";
        String annotationFile = "bio.tools_new.json";
        BioToolsAPI.fetchToolSet(root + toolNames, root + annotationFile);
    }

    private static void exampleURL(String domain) throws JSONException, APEConfigException, IOException {
        HashMap<String, String> examples = new HashMap<String, String>();
        examples.put("proteomics", "https://raw.githubusercontent.com/Workflomics/domain-annotations/main/MassSpectometry/config.json");
        LocalRun.runAPE((String)examples.get(domain));
    }

    private static void exampleLocal(String domain) throws JSONException, APEConfigException, IOException {
        HashMap<String, String> examples = new HashMap<String, String>();
        examples.put("proteomics", "/Users/vedran/git/APE_repo/APE_UseCases/MassSpectometry/No1/config_original.json");
        examples.put("gmt", "/Users/vedran/git/APE_repo/APE_UseCases/GeoGMT/E0/config.json");
        examples.put("tmp", "/Users/vedran/Desktop/steven_example/config.json");
        examples.put("wombat", "/Users/vedran/git/Workflomics_repo/domain-annotations/WombatP_tools/config.json");
        LocalRun.runAPE((String)examples.get(domain));
    }

    private static JSONObject setupLocalPaths(String pathToFile) throws IOException {
        File runConfigFile = APEFiles.readPathToFile(pathToFile);
        String runConfigString = FileUtils.readFileToString((File)runConfigFile, (Charset)StandardCharsets.UTF_8);
        runConfigString = runConfigString.replace("./", localRepo);
        return new JSONObject(runConfigString);
    }

    public static void runAPE(String pathToFile) throws JSONException, APEConfigException, IOException {
        SolutionsList solutions;
        JSONObject configurationJson = LocalRun.setupLocalPaths(pathToFile);
        int solutionsNo = 13;
        APECoreConfig coreConfig = new APECoreConfig(configurationJson);
        APE apeFramework = null;
        try {
            apeFramework = new APE(coreConfig);
        }
        catch (IOException | APEConfigException | JSONException | OWLOntologyCreationException e) {
            log.error("Error in setting up the APE framework:");
            log.error(e.getMessage());
            return;
        }
        try {
            APERunConfig runConfig = new APERunConfig(configurationJson, apeFramework.getDomainSetup());
            runConfig.setMaxNoSolutions(solutionsNo);
            runConfig.setNoGraphs(solutionsNo);
            runConfig.setNoCWL(solutionsNo);
            solutions = apeFramework.runSynthesis(runConfig);
        }
        catch (APEConfigException e) {
            log.error("Error in synthesis execution. APE configuration error:");
            log.error(e.getMessage());
            return;
        }
        catch (JSONException e) {
            log.error("Error in synthesis execution. Bad JSON formatting (APE configuration or constriants JSON). ");
            log.error(e.getMessage());
            return;
        }
        catch (IOException e) {
            log.error("Error in synthesis execution.");
            log.error(e.getMessage());
            return;
        }
        if (solutions.isEmpty()) {
            log.info("UNSAT");
        } else {
            try {
                APE.writeSolutionToFile(solutions);
                APE.writeTavernaDesignGraphs(solutions, Format.PNG);
                APE.writeTavernaDesignGraphs(solutions, Format.SVG);
                APE.writeCWLWorkflows(solutions);
            }
            catch (IOException e) {
                log.error("Error in writing the solutions. to the file system.");
                e.printStackTrace();
            }
        }
    }

    private static APECoreConfig generateCoreConfig(String configFilePath) throws IOException, JSONException {
        File configFile = APEFiles.readPathToFile(configFilePath);
        JSONObject configJson = APEFiles.readFileToJSONObject(configFile);
        String ontologyURL = configJson.getString("ontology_path");
        File ontology = APEFiles.readPathToFile(ontologyURL);
        String ontologyPrefixIRI = configJson.getString("ontologyPrefixIRI");
        String toolTaxonomyRoot = configJson.getString("toolsTaxonomyRoot");
        List<String> dataDimensionsTaxonomyRoots = APEUtils.getListFromJsonList(configJson.getJSONArray("dataDimensionsTaxonomyRoots"), String.class);
        String toolAnnotationsURL = configJson.getString("tool_annotations_path");
        File toolAnnotations = APEFiles.readPathToFile(toolAnnotationsURL);
        boolean strictToolAnnotations = configJson.getBoolean("strict_tool_annotations");
        APECoreConfig coreConfig = new APECoreConfig(ontology, ontologyPrefixIRI, toolTaxonomyRoot, dataDimensionsTaxonomyRoots, toolAnnotations, strictToolAnnotations);
        return coreConfig;
    }
}

