/*
 * Decompiled with CFR 0.152.
 */
package nl.uu.cs.ape;

import guru.nidi.graphviz.attribute.Rank;
import java.io.File;
import java.io.IOException;
import nl.uu.cs.ape.APE;
import nl.uu.cs.ape.configuration.APEConfigException;
import nl.uu.cs.ape.configuration.APERunConfig;
import nl.uu.cs.ape.solver.solutionStructure.SolutionsList;
import nl.uu.cs.ape.utils.APEFiles;
import org.json.JSONException;
import org.json.JSONObject;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger log = LoggerFactory.getLogger(Main.class);

    public static void main(String[] args) {
        SolutionsList solutions;
        String path;
        int solutionsNo = -1;
        if (args.length == 1) {
            path = args[0];
        } else if (args.length == 2) {
            path = args[0];
            try {
                solutionsNo = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException e) {
                log.error("Second parameter is not an integer.");
            }
        } else {
            path = "./config.json";
        }
        if (!APEFiles.isValidReadFile(path)) {
            log.error("Bad path.");
            return;
        }
        APE apeFramework = null;
        try {
            apeFramework = new APE(path);
        }
        catch (IOException | APEConfigException | JSONException | OWLOntologyCreationException e) {
            log.error("Error in setting up the APE framework:");
            log.error(e.getMessage());
            return;
        }
        try {
            JSONObject runConfigJson = APEFiles.readFileToJSONObject(new File(path));
            APERunConfig runConfig = new APERunConfig(runConfigJson, apeFramework.getDomainSetup());
            if (solutionsNo > 0) {
                runConfig.setMaxNoSolutions(solutionsNo);
            }
            solutions = apeFramework.runSynthesis(runConfig);
        }
        catch (APEConfigException e) {
            log.error("Error in synthesis execution. APE configuration error:");
            log.error(e.getMessage());
            return;
        }
        catch (JSONException e) {
            log.error("Error in synthesis execution. Bad JSON formatting (APE configuration or constriants JSON). ");
            log.error(e.getMessage());
            return;
        }
        catch (IOException e) {
            log.error("Error in synthesis execution.");
            log.error(e.getMessage());
            return;
        }
        if (solutions.isEmpty()) {
            log.info("The problem is UNSAT.");
        } else {
            try {
                APE.writeSolutionToFile(solutions);
                APE.writeDataFlowGraphs(solutions, Rank.RankDir.TOP_TO_BOTTOM);
                APE.writeExecutableWorkflows(solutions);
                APE.writeCWLWorkflows(solutions);
            }
            catch (IOException e) {
                log.error("Error in writing the solutions. to the file system.");
                e.printStackTrace();
            }
        }
    }
}

