/*
 * Decompiled with CFR 0.152.
 */
package nl.uu.cs.ape.automaton;

import java.util.ArrayList;
import java.util.List;
import nl.uu.cs.ape.automaton.Automaton;
import nl.uu.cs.ape.automaton.State;
import nl.uu.cs.ape.models.enums.AtomType;

public class ModuleAutomaton
implements Automaton {
    private List<State> moduleStates = new ArrayList<State>();

    public ModuleAutomaton(int automataBound, int inputBranching, int outputBranching) {
        automataBound = Math.max(automataBound, 1);
        for (int i = 1; i <= automataBound; ++i) {
            State tmpState = new State(AtomType.MODULE, null, i, inputBranching, outputBranching);
            this.moduleStates.add(tmpState);
        }
    }

    public void addState(State state) {
        this.moduleStates.add(state);
    }

    public int size() {
        return this.moduleStates.size();
    }

    public State get(int i) {
        return this.moduleStates.get(i);
    }

    public State getSafe(int i) {
        return i < this.moduleStates.size() ? this.moduleStates.get(i) : null;
    }

    @Override
    public List<State> getAllStates() {
        return this.moduleStates;
    }

    public State getState(int typeDependantStateNumber) {
        return this.get(typeDependantStateNumber);
    }
}

