/*
 * Decompiled with CFR 0.152.
 */
package nl.uu.cs.ape.automaton;

import nl.uu.cs.ape.automaton.StateInterface;
import nl.uu.cs.ape.models.enums.AtomType;
import nl.uu.cs.ape.models.logic.constructs.PredicateLabel;

public class State
implements PredicateLabel,
StateInterface {
    private final String stateName;
    private final int localStateNumber;
    private final int typeDependantStateNumber;
    private final int absoluteStateNumber;
    private final AtomType workflowStateType;

    public State(AtomType workflowStateType, Integer blockNumber, int stateNumber, int inputBranching, int outputBranching) {
        this.stateName = AtomType.getStringShortcut(workflowStateType, blockNumber, stateNumber);
        this.localStateNumber = stateNumber;
        this.typeDependantStateNumber = State.calculateAutomatonStateNumber(blockNumber, stateNumber, inputBranching, outputBranching, workflowStateType);
        this.absoluteStateNumber = State.calculateAbsStateNumber(blockNumber, stateNumber, inputBranching, outputBranching, workflowStateType);
        this.workflowStateType = workflowStateType;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.absoluteStateNumber;
        result = 31 * result + (this.stateName == null ? 0 : this.stateName.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        State other = (State)obj;
        if (this.absoluteStateNumber != other.absoluteStateNumber) {
            return false;
        }
        return !(this.stateName == null ? other.stateName != null : !this.stateName.equals(other.stateName));
    }

    @Override
    public int compareTo(PredicateLabel other) {
        if (!(other instanceof State)) {
            return this.getPredicateID().compareTo(other.getPredicateID());
        }
        State otherState = (State)other;
        int diff = 0;
        diff = Integer.compare(this.absoluteStateNumber, otherState.absoluteStateNumber);
        if (diff != 0) {
            return diff;
        }
        return this.getPredicateID().compareTo(otherState.getPredicateID());
    }

    @Override
    public String getPredicateID() {
        return this.stateName;
    }

    @Override
    public String getPredicateLabel() {
        return this.stateName;
    }

    @Override
    public String getPredicateLongLabel() {
        return this.stateName;
    }

    public int getLocalStateNumber() {
        return this.localStateNumber;
    }

    public int getTypeDependantStateNumber() {
        return this.typeDependantStateNumber;
    }

    @Override
    public int getAbsoluteStateNumber() {
        return this.absoluteStateNumber;
    }

    public AtomType getWorkflowStateType() {
        return this.workflowStateType;
    }

    private static int calculateAbsStateNumber(Integer blockNumber, int stateNumber, int inputBranching, int outputBranching, AtomType typeOfTheState) {
        int absOrderNumber = -1;
        if (typeOfTheState == AtomType.MEMORY_TYPE) {
            absOrderNumber = blockNumber * (inputBranching + outputBranching) + blockNumber + stateNumber;
        } else if (typeOfTheState == AtomType.USED_TYPE) {
            absOrderNumber = blockNumber * (inputBranching + outputBranching) + blockNumber + outputBranching + stateNumber;
        } else if (typeOfTheState == AtomType.MODULE) {
            absOrderNumber = stateNumber * (inputBranching + outputBranching) * 2 + stateNumber - 1;
        }
        return absOrderNumber;
    }

    private static int calculateAutomatonStateNumber(Integer blockNumber, int stateNumber, int inputBranching, int outputBranching, AtomType typeOfTheState) {
        int orderNumber = 0;
        if (typeOfTheState == AtomType.MEMORY_TYPE) {
            orderNumber = blockNumber * outputBranching + stateNumber + 1;
        } else if (typeOfTheState == AtomType.USED_TYPE) {
            orderNumber = blockNumber * inputBranching + stateNumber;
        } else if (typeOfTheState == AtomType.MODULE) {
            orderNumber = stateNumber - 1;
        }
        return orderNumber;
    }
}

