/*
 * Decompiled with CFR 0.152.
 */
package nl.uu.cs.ape.automaton;

import java.util.ArrayList;
import java.util.List;
import nl.uu.cs.ape.automaton.Automaton;
import nl.uu.cs.ape.automaton.Block;
import nl.uu.cs.ape.automaton.State;
import nl.uu.cs.ape.models.enums.AtomType;

public class TypeAutomaton
implements Automaton {
    private List<Block> memoryTypesAutomaton = new ArrayList<Block>();
    private List<Block> usedTypesAutomaton = new ArrayList<Block>();
    private State nullState;

    public TypeAutomaton(int automataBound, int inputBranching, int outputBranching) {
        this.nullState = new State(null, null, -1, inputBranching, outputBranching);
        automataBound = automataBound < 1 ? 1 : automataBound;
        for (int i = 0; i <= automataBound; ++i) {
            Block tmpMemoryTypeBlock = new Block(i);
            for (int j = 0; j < outputBranching; ++j) {
                State tmpMemoryState = new State(AtomType.MEMORY_TYPE, i, j, inputBranching, outputBranching);
                tmpMemoryTypeBlock.addState(tmpMemoryState);
            }
            this.memoryTypesAutomaton.add(tmpMemoryTypeBlock);
            Block tmpUsedTypesBlock = new Block(i);
            for (int j = 0; j < inputBranching; ++j) {
                State tmpUsedState = new State(AtomType.USED_TYPE, i, j, inputBranching, outputBranching);
                tmpUsedTypesBlock.addState(tmpUsedState);
            }
            this.usedTypesAutomaton.add(tmpUsedTypesBlock);
        }
    }

    public List<Block> getUsedTypesBlocks() {
        return this.usedTypesAutomaton;
    }

    public List<Block> getMemoryTypesBlocks() {
        return this.memoryTypesAutomaton;
    }

    public List<Block> getAllBlocks() {
        ArrayList<Block> allBlocks = new ArrayList<Block>(this.usedTypesAutomaton);
        allBlocks.addAll(this.memoryTypesAutomaton);
        return allBlocks;
    }

    public State getNullState() {
        return this.nullState;
    }

    public boolean addUsedTypesBlock(Block block) {
        return this.usedTypesAutomaton.add(block);
    }

    public boolean addMemoryTypesBlock(Block block) {
        return this.memoryTypesAutomaton.add(block);
    }

    public Block getWorkflowInputBlock() {
        Block tmp;
        try {
            tmp = this.getMemoryTypesBlock(0);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
        return tmp;
    }

    public Block getWorkflowOutputBlock() {
        Block tmp;
        try {
            tmp = this.usedTypesAutomaton.get(this.usedTypesAutomaton.size() - 1);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
        return tmp;
    }

    public Block getLastToolOutputBlock() {
        Block tmp;
        try {
            tmp = this.getMemoryTypesBlock(this.memoryTypesAutomaton.size() - 1);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
        return tmp;
    }

    public Block getUsedTypesBlock(int i) {
        return this.usedTypesAutomaton.get(i);
    }

    public Block getMemoryTypesBlock(int i) {
        return this.memoryTypesAutomaton.get(i);
    }

    public List<State> getMemoryStatesUntilBlockNo(int maxBlockNo) {
        ArrayList<State> untilStates = new ArrayList<State>();
        for (int i = 0; i <= maxBlockNo && i < this.usedTypesAutomaton.size(); ++i) {
            Block currBlock = this.getMemoryTypesBlock(i);
            for (State currState : currBlock.getStates()) {
                untilStates.add(currState);
            }
        }
        return untilStates;
    }

    public List<State> getAllStatesUntilBlockNo(int maxBlockNo) {
        ArrayList<State> untilStates = new ArrayList<State>();
        for (int i = 0; i <= maxBlockNo && i < this.usedTypesAutomaton.size(); ++i) {
            Block currBlock = this.usedTypesAutomaton.get(i);
            for (State currState : currBlock.getStates()) {
                untilStates.add(currState);
            }
            currBlock = this.memoryTypesAutomaton.get(i);
            for (State currState : currBlock.getStates()) {
                untilStates.add(currState);
            }
        }
        return untilStates;
    }

    public List<State> getAllMemoryStatesUntilBlockNo(int maxBlockNo) {
        ArrayList<State> untilStates = new ArrayList<State>();
        for (int i = 0; i <= maxBlockNo && i < this.usedTypesAutomaton.size(); ++i) {
            Block currBlock = this.memoryTypesAutomaton.get(i);
            for (State currState : currBlock.getStates()) {
                untilStates.add(currState);
            }
        }
        return untilStates;
    }

    public List<State> getMemoryStatesAfterBlockNo(int minBlockNo) {
        ArrayList<State> afterStates = new ArrayList<State>();
        for (int i = minBlockNo + 1; i < this.memoryTypesAutomaton.size(); ++i) {
            Block currBlock = this.getMemoryTypesBlock(i);
            for (State currState : currBlock.getStates()) {
                afterStates.add(currState);
            }
        }
        return afterStates;
    }

    public List<State> getUsedStatesAfterBlockNo(int minBlockNo) {
        ArrayList<State> afterStates = new ArrayList<State>();
        for (int i = minBlockNo + 1; i < this.usedTypesAutomaton.size(); ++i) {
            Block currBlock = this.usedTypesAutomaton.get(i);
            for (State currState : currBlock.getStates()) {
                afterStates.add(currState);
            }
        }
        return afterStates;
    }

    @Override
    public List<State> getAllStates() {
        ArrayList<State> allStates = new ArrayList<State>();
        for (Block currBlock : this.getAllBlocks()) {
            for (State currState : currBlock.getStates()) {
                allStates.add(currState);
            }
        }
        return allStates;
    }

    public List<State> getAllMemoryTypesStates() {
        ArrayList<State> allMemoryStates = new ArrayList<State>();
        for (Block currBlock : this.getMemoryTypesBlocks()) {
            for (State currState : currBlock.getStates()) {
                allMemoryStates.add(currState);
            }
        }
        return allMemoryStates;
    }

    public List<State> getAllUsedTypesStates() {
        ArrayList<State> allUsedStates = new ArrayList<State>();
        for (Block currBlock : this.getUsedTypesBlocks()) {
            for (State currState : currBlock.getStates()) {
                allUsedStates.add(currState);
            }
        }
        return allUsedStates;
    }

    public int getLength() {
        return this.memoryTypesAutomaton.size();
    }
}

