/*
 * Decompiled with CFR 0.152.
 */
package nl.uu.cs.ape.configuration;

import nl.uu.cs.ape.configuration.tags.validation.ValidationResults;
import org.json.JSONObject;

public class APEConfigException
extends RuntimeException {
    public APEConfigException(String message) {
        super(message);
    }

    public static APEConfigException invalidValue(String tag, Object value, String info) {
        return new APEConfigException(String.format("'%s' is not a valid value for tag '%s', %s", value, tag, info));
    }

    public static APEConfigException invalidValue(String tag, JSONObject config, String info) {
        return new APEConfigException(String.format("'%s' is not a valid value for tag '%s', %s", config.get(tag), tag, info));
    }

    public static APEConfigException missingTag(String tag) {
        return new APEConfigException(String.format("Tag '%s' is not provided, cannot setup the configuration.", tag));
    }

    public static <T> APEConfigException cannotParse(String tag, Object value, Class<T> expectedType, String info) {
        return new APEConfigException(String.format("Value '%s' cannot be parsed to type '%s' for tag '%s', %s", value, expectedType.getSimpleName(), tag, info));
    }

    public static APEConfigException requiredValidationTag(String tag, String requiredTag, String info) {
        return new APEConfigException(String.format("Cannot parse tag '%s' without '%s', %s", tag, requiredTag, info));
    }

    public static APEConfigException pathNotFound(String tag, String path) {
        return new APEConfigException(String.format("Provided path '%s' for tag '%s' does not exist.", path, tag));
    }

    public static APEConfigException notAFile(String tag, String path) {
        return new APEConfigException(String.format("Provided path '%s' for tag '%s' is not a file.", path, tag));
    }

    public static APEConfigException notADirectory(String tag, String path) {
        return new APEConfigException(String.format("Provided path '%s' for tag '%s' is not a directory.", path, tag));
    }

    public static APEConfigException missingPermission(String tag, String path, Object missingPermission) {
        return new APEConfigException(String.format("You are missing [%s] permission for path '%s' for tag '%s'", missingPermission, path, tag));
    }

    public static APEConfigException ruleViolations(ValidationResults validationResults) {
        StringBuilder sb = new StringBuilder();
        validationResults.getFails().forEach(fail -> sb.append(String.format("Tag '%s' is incorrect: %s%n", fail.getTag(), fail.getRuleDescription())));
        return new APEConfigException(sb.toString());
    }

    public static APEConfigException workflowIODataTypeNotInDomain(String typeID) {
        return new APEConfigException(String.format("Data type '%s'used to annotate workflow input/output is not defined in the taxonomy.", typeID));
    }
}

