/*
 * Decompiled with CFR 0.152.
 */
package nl.uu.cs.ape.configuration;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Provider;
import nl.uu.cs.ape.configuration.APEConfigException;
import nl.uu.cs.ape.configuration.tags.APEConfigTag;
import nl.uu.cs.ape.configuration.tags.APEConfigTagFactory;
import nl.uu.cs.ape.configuration.tags.APEConfigTags;
import nl.uu.cs.ape.configuration.tags.validation.ValidationResults;
import nl.uu.cs.ape.domain.APEDimensionsException;
import nl.uu.cs.ape.domain.OWLReader;
import nl.uu.cs.ape.utils.APEFiles;
import nl.uu.cs.ape.utils.APEUtils;
import org.apache.commons.io.FileExistsException;
import org.apache.commons.io.FileUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;

public class APECoreConfig {
    public final APEConfigTag<File> ONTOLOGY = new APEConfigTagFactory.TAGS.ONTOLOGY();
    public final APEConfigTag<String> ONTOLOGY_PREFIX = new APEConfigTagFactory.TAGS.ONTOLOGY_PREFIX();
    public final APEConfigTag<String> TOOL_ONTOLOGY_ROOT = new APEConfigTagFactory.TAGS.TOOL_ONTOLOGY_ROOT((Provider<String>)((Provider)this.ONTOLOGY_PREFIX::getValue));
    public final APEConfigTag<List<String>> DIMENSIONS_ONTOLOGY = new APEConfigTagFactory.TAGS.DIMENSIONS_ONTOLOGY((Provider<String>)((Provider)this.ONTOLOGY_PREFIX::getValue));
    public final APEConfigTag<File> TOOL_ANNOTATIONS = new APEConfigTagFactory.TAGS.TOOL_ANNOTATIONS();
    public final APEConfigTag<Boolean> STRICT_TOOL_ANNOTATIONS = new APEConfigTagFactory.TAGS.STRICT_TOOL_ANNOTATIONS();
    private final APEConfigTag<?>[] all_tags = new APEConfigTag[]{this.ONTOLOGY_PREFIX, this.ONTOLOGY, this.TOOL_ONTOLOGY_ROOT, this.DIMENSIONS_ONTOLOGY, this.TOOL_ANNOTATIONS, this.STRICT_TOOL_ANNOTATIONS};
    public static final APEConfigTags TAGS = new APEConfigTags(new APEConfigTagFactory.TAGS.ONTOLOGY_PREFIX(), new APEConfigTagFactory.TAGS.ONTOLOGY(), new APEConfigTagFactory.TAGS.TOOL_ONTOLOGY_ROOT(null), new APEConfigTagFactory.TAGS.DIMENSIONS_ONTOLOGY(null), new APEConfigTagFactory.TAGS.TOOL_ANNOTATIONS(), new APEConfigTagFactory.TAGS.STRICT_TOOL_ANNOTATIONS());

    public APECoreConfig(File ontology, String ontologyPrefixIRI, String toolTaxonomyRoot, List<String> dataDimensionRoots, File toolAnnotations, boolean strictToolAnnotations) {
        this.ONTOLOGY.setValue(ontology);
        this.ONTOLOGY_PREFIX.setValue(ontologyPrefixIRI);
        this.TOOL_ONTOLOGY_ROOT.setValue(APEUtils.createClassIRI(toolTaxonomyRoot, this.getOntologyPrefixIRI()));
        this.DIMENSIONS_ONTOLOGY.setValue(dataDimensionRoots.stream().map(subTaxonomy -> APEUtils.createClassIRI(subTaxonomy, this.getOntologyPrefixIRI())).collect(Collectors.toList()));
        this.TOOL_ANNOTATIONS.setValue(toolAnnotations);
        this.STRICT_TOOL_ANNOTATIONS.setValue(strictToolAnnotations);
    }

    public APECoreConfig(String configPath) throws IOException, JSONException, APEConfigException {
        if (configPath == null) {
            throw new NullPointerException("The provided core configuration file path is null.");
        }
        this.coreConfigSetup(APEFiles.readPathToJSONObject(configPath));
    }

    public APECoreConfig(File config) throws IOException, JSONException, APEConfigException {
        this.coreConfigSetup(new JSONObject(FileUtils.readFileToString((File)config, (Charset)StandardCharsets.UTF_8)));
    }

    public APECoreConfig(JSONObject configObject) throws JSONException, APEConfigException {
        this.coreConfigSetup(configObject);
    }

    private void coreConfigSetup(JSONObject coreConfiguration) throws JSONException, APEConfigException {
        if (coreConfiguration == null) {
            throw new APEConfigException("Cannot set up the core configuration, because the JSONObject is initialized to NULL. The configuration file might not have been parsed correctly.");
        }
        for (APEConfigTag<?> tag : this.all_tags) {
            tag.setValueFromConfig(coreConfiguration);
        }
    }

    private APECoreConfig() {
    }

    public static ValidationResults validate(JSONObject json) {
        APECoreConfig dummy = new APECoreConfig();
        ValidationResults results = new ValidationResults();
        for (APEConfigTag<?> tag : dummy.all_tags) {
            results.add(tag.validateConfig(json));
            if (results.hasFails()) {
                return results;
            }
            tag.setValueFromConfig(json);
        }
        return results;
    }

    public static boolean validateOntology(File ontologyFile, String ontologyPrefixIRI, String toolTaxonomyRoot, List<String> dataDimensionRoots) throws APEDimensionsException, OWLOntologyCreationException, FileExistsException {
        return OWLReader.verifyOntology(ontologyFile, ontologyPrefixIRI, toolTaxonomyRoot, dataDimensionRoots);
    }

    public File getOntologyFile() {
        return this.ONTOLOGY.getValue();
    }

    public void setOntologyFile(File ontology) {
        this.ONTOLOGY.setValue(ontology);
    }

    public String getOntologyPrefixIRI() {
        return this.ONTOLOGY_PREFIX.getValue();
    }

    public String getToolTaxonomyRoot() {
        return this.TOOL_ONTOLOGY_ROOT.getValue();
    }

    public List<String> getDataDimensionRoots() {
        return this.DIMENSIONS_ONTOLOGY.getValue();
    }

    public File getToolAnnotationsFile() {
        return this.TOOL_ANNOTATIONS.getValue();
    }

    public void setToolAnnotationsFile(File toolAnnotations) {
        this.TOOL_ANNOTATIONS.setValue(toolAnnotations);
    }

    public boolean getUseStrictToolAnnotations() {
        return this.STRICT_TOOL_ANNOTATIONS.getValue();
    }
}

