/*
 * Decompiled with CFR 0.152.
 */
package nl.uu.cs.ape.configuration;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import javax.inject.Provider;
import nl.uu.cs.ape.configuration.APEConfigException;
import nl.uu.cs.ape.configuration.tags.APEConfigDependentTag;
import nl.uu.cs.ape.configuration.tags.APEConfigTag;
import nl.uu.cs.ape.configuration.tags.APEConfigTagFactory;
import nl.uu.cs.ape.configuration.tags.APEConfigTags;
import nl.uu.cs.ape.configuration.tags.validation.ValidationResults;
import nl.uu.cs.ape.domain.APEDomainSetup;
import nl.uu.cs.ape.models.Range;
import nl.uu.cs.ape.models.Type;
import nl.uu.cs.ape.models.enums.ConfigEnum;
import nl.uu.cs.ape.models.enums.SolverType;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class APERunConfig {
    private final APEConfigTag<JSONArray> CONSTRAINTS_FILE = new APEConfigTagFactory.TAGS.CONSTRAINTS_FILE();
    private final APEConfigTag<JSONArray> CONSTRAINTS_CONTENT = new APEConfigTagFactory.TAGS.CONSTRAINTS_CONTENT();
    private final APEConfigTag<Path> SOLUTION_DIR_PATH = new APEConfigTagFactory.TAGS.SOLUTION_DIR_PATH();
    private final APEConfigTag<Range> SOLUTION_LENGTH_RANGE = new APEConfigTagFactory.TAGS.SOLUTION_LENGTH_RANGE();
    private final APEConfigTag<Integer> NO_SOLUTIONS = new APEConfigTagFactory.TAGS.NO_SOLUTIONS();
    private final APEConfigTag<Integer> NO_EXECUTIONS = new APEConfigTagFactory.TAGS.NO_EXECUTIONS();
    private final APEConfigTag<Integer> NO_GRAPHS = new APEConfigTagFactory.TAGS.NO_GRAPHS();
    private final APEConfigTag<Integer> NO_CWL = new APEConfigTagFactory.TAGS.NO_CWL();
    private final APEConfigTag<ConfigEnum> USE_WORKFLOW_INPUT = new APEConfigTagFactory.TAGS.USE_WORKFLOW_INPUT();
    private final APEConfigTag<ConfigEnum> USE_ALL_GENERATED_DATA = new APEConfigTagFactory.TAGS.USE_ALL_GENERATED_DATA();
    private final APEConfigTag<Boolean> DEBUG_MODE = new APEConfigTagFactory.TAGS.DEBUG_MODE();
    public final APEConfigTag<Integer> TIMEOUT_SEC = new APEConfigTagFactory.TAGS.TIMEOUT_SEC();
    private final APEConfigTag<Boolean> TOOL_SEQ_REPEAT = new APEConfigTagFactory.TAGS.TOOL_SEQ_REPEAT();
    private final APEConfigDependentTag.One<List<Type>, APEDomainSetup> PROGRAM_INPUTS = new APEConfigTagFactory.TAGS.PROGRAM_INPUTS((Provider<APEDomainSetup>)((Provider)this::getApeDomainSetup));
    private final APEConfigDependentTag.One<List<Type>, APEDomainSetup> PROGRAM_OUTPUTS = new APEConfigTagFactory.TAGS.PROGRAM_OUTPUTS((Provider<APEDomainSetup>)((Provider)this::getApeDomainSetup));
    private final APEConfigTag<?>[] all_tags = new APEConfigTag[]{this.CONSTRAINTS_FILE, this.CONSTRAINTS_CONTENT, this.SOLUTION_DIR_PATH, this.SOLUTION_LENGTH_RANGE, this.NO_SOLUTIONS, this.NO_EXECUTIONS, this.NO_GRAPHS, this.NO_CWL, this.USE_WORKFLOW_INPUT, this.USE_ALL_GENERATED_DATA, this.DEBUG_MODE, this.TIMEOUT_SEC, this.TOOL_SEQ_REPEAT, this.PROGRAM_OUTPUTS, this.PROGRAM_INPUTS};
    public static final APEConfigTags TAGS = new APEConfigTags(new APEConfigTagFactory.TAGS.CONSTRAINTS_FILE(), new APEConfigTagFactory.TAGS.CONSTRAINTS_CONTENT(), new APEConfigTagFactory.TAGS.SOLUTION_DIR_PATH(), new APEConfigTagFactory.TAGS.SOLUTION_LENGTH_RANGE(), new APEConfigTagFactory.TAGS.NO_SOLUTIONS(), new APEConfigTagFactory.TAGS.NO_EXECUTIONS(), new APEConfigTagFactory.TAGS.NO_GRAPHS(), new APEConfigTagFactory.TAGS.NO_CWL(), new APEConfigTagFactory.TAGS.USE_WORKFLOW_INPUT(), new APEConfigTagFactory.TAGS.USE_ALL_GENERATED_DATA(), new APEConfigTagFactory.TAGS.DEBUG_MODE(), new APEConfigTagFactory.TAGS.TIMEOUT_SEC(), new APEConfigTagFactory.TAGS.TOOL_SEQ_REPEAT(), new APEConfigTagFactory.TAGS.PROGRAM_OUTPUTS(null), new APEConfigTagFactory.TAGS.PROGRAM_INPUTS(null));
    private APEDomainSetup apeDomainSetup;
    private SolverType solverType = SolverType.SAT;
    public static final String EXECUTABLES_FOLDER_NAME = "Executables";
    public static final String FIGURES_FOLDER_NAME = "Figures";
    public static final String CWL_FOLDER_NAME = "CWL";
    public static final String EXECUTABLE_CWL_FOLDER_NAME = "CWL_executables";

    private APERunConfig(Builder builder) {
        if (builder.apeDomainSetup == null) {
            throw new APEConfigException("Domain setup provided cannot have null value.");
        }
        this.apeDomainSetup = builder.apeDomainSetup;
        this.setConstraintsJSON(builder.constraintsJSON);
        this.setSolutionLength(builder.solutionMinLength, builder.solutionMaxLength);
        this.setMaxNoSolutions(builder.maxNoSolutions);
        this.setToolSeqRepeat(builder.toolSeqRepeat);
        this.setSolutionPath(builder.solutionDirPath);
        this.setNoExecutions(builder.noExecutions);
        this.setNoGraphs(builder.noGraphs);
        this.setNoCWL(builder.noCWL);
        this.setUseWorkflowInput(builder.useWorkflowInput);
        this.setUseAllGeneratedData(builder.useAllGeneratedData);
        this.setDebugMode(builder.debugMode);
        this.setTimeoutSec(builder.timeoutSec);
        this.setProgramInputs(builder.programInputs);
        this.setProgramOutputs(builder.programOutputs);
    }

    private APERunConfig(APEDomainSetup setup) {
        this.apeDomainSetup = setup;
    }

    public static ValidationResults validate(JSONObject json, APEDomainSetup setup) {
        APERunConfig dummy = new APERunConfig(setup);
        ValidationResults results = new ValidationResults();
        for (APEConfigTag<?> tag : dummy.all_tags) {
            results.add(tag.validateConfig(json));
            if (results.hasFails()) {
                return results;
            }
            tag.setValueFromConfig(json);
        }
        return results;
    }

    public APERunConfig(JSONObject runConfiguration, APEDomainSetup apeDomainSetup) throws IOException, JSONException, APEConfigException {
        if (runConfiguration == null) {
            throw new APEConfigException("Cannot set up the run configuration, because the JSONObject is initialized to NULL. The configuration file might not have been parsed correctly.");
        }
        if (apeDomainSetup == null) {
            throw new APEConfigException("Domain setup provided cannot have null value.");
        }
        this.apeDomainSetup = apeDomainSetup;
        for (APEConfigTag<?> tag : this.all_tags) {
            tag.setValueFromConfig(runConfiguration);
        }
    }

    public static ISolutionMinLengthStage builder() {
        return new Builder();
    }

    public JSONArray getConstraintsJSON() {
        return this.CONSTRAINTS_CONTENT.getValue() != null ? this.CONSTRAINTS_CONTENT.getValue() : this.CONSTRAINTS_FILE.getValue();
    }

    public void setConstraintsJSON(JSONArray constraintsJSON) {
        this.CONSTRAINTS_CONTENT.setValue(constraintsJSON);
    }

    public boolean getAllowToolSeqRepeat() {
        return this.TOOL_SEQ_REPEAT.getValue();
    }

    public void setToolSeqRepeat(boolean toolSeqRepeat) {
        this.TOOL_SEQ_REPEAT.setValue(toolSeqRepeat);
    }

    public Path getSolutionDirPath() {
        return this.SOLUTION_DIR_PATH.getValue();
    }

    public Path getSolutionDirPath2(String relativePath) {
        if (relativePath.startsWith("/") || relativePath.startsWith("\\")) {
            return this.getSolutionDirPath().resolve(relativePath.substring(1));
        }
        return this.getSolutionDirPath().resolve(relativePath);
    }

    public Path getSolutionDirPath2Executables() {
        return this.getSolutionDirPath2(EXECUTABLES_FOLDER_NAME);
    }

    public Path getSolutionDirPath2Figures() {
        return this.getSolutionDirPath2(FIGURES_FOLDER_NAME);
    }

    public Path getSolutionDirPath2CWL() {
        return this.getSolutionDirPath2(CWL_FOLDER_NAME);
    }

    public Path getSolutionDirPath2ExecutableCWL() {
        return this.getSolutionDirPath2(EXECUTABLE_CWL_FOLDER_NAME);
    }

    public void setSolutionPath(String solutionPath) {
        this.SOLUTION_DIR_PATH.setValue(Paths.get(solutionPath, new String[0]));
    }

    public Range getSolutionLength() {
        return this.SOLUTION_LENGTH_RANGE.getValue();
    }

    public int getMaxNoSolutions() {
        return this.NO_SOLUTIONS.getValue();
    }

    public void setMaxNoSolutions(int maxNoSolutions) {
        this.NO_SOLUTIONS.setValue(maxNoSolutions);
    }

    public int getNoExecutions() {
        return this.NO_EXECUTIONS.getValue();
    }

    public void setNoExecutions(int noExecutions) {
        this.NO_EXECUTIONS.setValue(noExecutions);
    }

    public int getNoGraphs() {
        return this.NO_GRAPHS.getValue();
    }

    public void setNoGraphs(int noGraphs) {
        this.NO_GRAPHS.setValue(noGraphs);
    }

    public int getNoCWL() {
        return this.NO_CWL.getValue();
    }

    public void setNoCWL(int noCWL) {
        this.NO_CWL.setValue(noCWL);
    }

    public List<Type> getProgramInputs() {
        return (List)this.PROGRAM_INPUTS.getValue();
    }

    public void setProgramInputs(List<Type> programInputs) {
        this.PROGRAM_INPUTS.setValue(programInputs);
    }

    public List<Type> getProgramOutputs() {
        return (List)this.PROGRAM_OUTPUTS.getValue();
    }

    public void setProgramOutputs(List<Type> programOutputs) {
        this.PROGRAM_OUTPUTS.setValue(programOutputs);
    }

    public ConfigEnum getUseWorkflowInput() {
        return this.USE_WORKFLOW_INPUT.getValue();
    }

    public void setUseWorkflowInput(ConfigEnum useWorkflowInput) {
        this.USE_WORKFLOW_INPUT.setValue(useWorkflowInput);
    }

    public ConfigEnum getUseAllGeneratedData() {
        return this.USE_ALL_GENERATED_DATA.getValue();
    }

    public void setUseAllGeneratedData(ConfigEnum useAllGeneratedData) {
        this.USE_ALL_GENERATED_DATA.setValue(useAllGeneratedData);
    }

    public int getTimeoutSec() {
        return this.TIMEOUT_SEC.getValue();
    }

    public int getTimeoutMs() {
        return this.TIMEOUT_SEC.getValue() * 1000;
    }

    public void setTimeoutSec(int timeoutSec) {
        this.TIMEOUT_SEC.setValue(timeoutSec);
    }

    public boolean getDebugMode() {
        return this.DEBUG_MODE.getValue();
    }

    public void setDebugMode(boolean debugMode) {
        this.DEBUG_MODE.setValue(debugMode);
    }

    public void setSolutionLength(int solutionMinLength, int solutionMaxLength) {
        this.SOLUTION_LENGTH_RANGE.setValue(Range.of(solutionMinLength, solutionMaxLength));
    }

    public SolverType getSolverType() {
        return this.solverType;
    }

    public void setSolverType(SolverType solverType) {
        this.solverType = solverType;
    }

    public APEDomainSetup getApeDomainSetup() {
        return this.apeDomainSetup;
    }

    public static final class Builder
    implements ISolutionMinLengthStage,
    ISolutionMaxLengthStage,
    IMaxNoSolutionsStage,
    IApeDomainSetupStage,
    IBuildStage {
        private int solutionMinLength;
        private int solutionMaxLength;
        private int maxNoSolutions;
        private APEDomainSetup apeDomainSetup;
        private JSONArray constraintsJSON;
        private boolean toolSeqRepeat;
        private String solutionDirPath;
        private int noExecutions;
        private int noGraphs;
        private int noCWL;
        private int noExecutableCWL;
        private List<Type> programInputs = Collections.emptyList();
        private List<Type> programOutputs = Collections.emptyList();
        private ConfigEnum useWorkflowInput;
        private ConfigEnum useAllGeneratedData;
        private boolean debugMode;
        private int timeoutSec;

        private Builder() {
        }

        @Override
        public ISolutionMaxLengthStage withSolutionMinLength(int solutionMinLength) {
            this.solutionMinLength = solutionMinLength;
            return this;
        }

        @Override
        public IMaxNoSolutionsStage withSolutionMaxLength(int solutionMaxLength) {
            this.solutionMaxLength = solutionMaxLength;
            return this;
        }

        @Override
        public IApeDomainSetupStage withMaxNoSolutions(int maxNoSolutions) {
            this.maxNoSolutions = maxNoSolutions;
            return this;
        }

        @Override
        public IBuildStage withApeDomainSetup(APEDomainSetup apeDomainSetup) {
            this.apeDomainSetup = apeDomainSetup;
            return this;
        }

        @Override
        public IBuildStage withConstraintsJSON(JSONArray constraintsJSON) {
            this.constraintsJSON = constraintsJSON;
            return this;
        }

        @Override
        public IBuildStage withToolSeqRepeat(boolean toolSeqRepeat) {
            this.toolSeqRepeat = toolSeqRepeat;
            return this;
        }

        @Override
        public IBuildStage withSolutionDirPath(String solutionDirPath) {
            this.solutionDirPath = solutionDirPath;
            return this;
        }

        @Override
        public IBuildStage withNoExecutions(int noExecutions) {
            this.noExecutions = noExecutions;
            return this;
        }

        @Override
        public IBuildStage withNoGraphs(int noGraphs) {
            this.noGraphs = noGraphs;
            return this;
        }

        @Override
        public IBuildStage withNoCWL(int noCWL) {
            this.noCWL = noCWL;
            return this;
        }

        @Override
        public IBuildStage withNoExecutableCWL(int noExecutableCWL) {
            this.noExecutableCWL = noExecutableCWL;
            return this;
        }

        @Override
        public IBuildStage withProgramInputs(List<Type> programInputs) {
            this.programInputs = programInputs;
            return this;
        }

        @Override
        public IBuildStage withProgramOutputs(List<Type> programOutputs) {
            this.programOutputs = programOutputs;
            return this;
        }

        @Override
        public IBuildStage withUseWorkflowInput(ConfigEnum useWorkflowInput) {
            this.useWorkflowInput = useWorkflowInput;
            return this;
        }

        @Override
        public IBuildStage withUseAllGeneratedData(ConfigEnum useAllGeneratedData) {
            this.useAllGeneratedData = useAllGeneratedData;
            return this;
        }

        @Override
        public IBuildStage withDebugMode(boolean debugMode) {
            this.debugMode = debugMode;
            return this;
        }

        @Override
        public IBuildStage withTimeoutSec(int timeout) {
            this.timeoutSec = timeout;
            return this;
        }

        @Override
        public APERunConfig build() {
            return new APERunConfig(this);
        }
    }

    public static interface IBuildStage {
        public IBuildStage withConstraintsJSON(JSONArray var1);

        public IBuildStage withToolSeqRepeat(boolean var1);

        public IBuildStage withSolutionDirPath(String var1);

        public IBuildStage withNoExecutions(int var1);

        public IBuildStage withNoGraphs(int var1);

        public IBuildStage withNoCWL(int var1);

        public IBuildStage withNoExecutableCWL(int var1);

        public IBuildStage withProgramInputs(List<Type> var1);

        public IBuildStage withProgramOutputs(List<Type> var1);

        public IBuildStage withUseWorkflowInput(ConfigEnum var1);

        public IBuildStage withUseAllGeneratedData(ConfigEnum var1);

        public IBuildStage withDebugMode(boolean var1);

        public IBuildStage withTimeoutSec(int var1);

        public APERunConfig build();
    }

    public static interface IApeDomainSetupStage {
        public IBuildStage withApeDomainSetup(APEDomainSetup var1);
    }

    public static interface IMaxNoSolutionsStage {
        public IApeDomainSetupStage withMaxNoSolutions(int var1);
    }

    public static interface ISolutionMaxLengthStage {
        public IMaxNoSolutionsStage withSolutionMaxLength(int var1);
    }

    public static interface ISolutionMinLengthStage {
        public ISolutionMaxLengthStage withSolutionMinLength(int var1);
    }
}

