/*
 * Decompiled with CFR 0.152.
 */
package nl.uu.cs.ape.configuration.tags.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nl.uu.cs.ape.configuration.tags.validation.ValidationResult;
import org.json.JSONArray;

public class ValidationResults {
    private final List<ValidationResult> results = new ArrayList<ValidationResult>();

    public ValidationResults() {
    }

    public ValidationResults(Collection<ValidationResult> results) {
        this.results.addAll(results);
    }

    public List<ValidationResult> list() {
        return new ArrayList<ValidationResult>(this.results);
    }

    public Stream<ValidationResult> stream() {
        return new ArrayList<ValidationResult>(this.results).stream();
    }

    public void add(String tag, String ruleDescription, boolean success) {
        this.results.add(new ValidationResult(tag, ruleDescription, success));
    }

    public void add(ValidationResults results) {
        this.results.addAll(results.list());
    }

    public List<ValidationResult> getFails() {
        return this.results.stream().filter(ValidationResult::isFail).collect(Collectors.toList());
    }

    public List<ValidationResult> getSuccesses() {
        return this.results.stream().filter(ValidationResult::isSuccess).collect(Collectors.toList());
    }

    public boolean hasFails() {
        return this.results.stream().anyMatch(ValidationResult::isFail);
    }

    public boolean success() {
        return !this.hasFails();
    }

    public JSONArray toJSONArray() {
        return new JSONArray((Collection)this.results.stream().map(ValidationResult::toJSON).collect(Collectors.toList()));
    }

    public String toString() {
        return this.toJSONArray().toString(2);
    }
}

