/*
 * Decompiled with CFR 0.152.
 */
package nl.uu.cs.ape.constraints;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.uu.cs.ape.automaton.ModuleAutomaton;
import nl.uu.cs.ape.automaton.TypeAutomaton;
import nl.uu.cs.ape.constraints.ConstraintTemplate;
import nl.uu.cs.ape.constraints.ConstraintTemplateParameter;
import nl.uu.cs.ape.domain.APEDomainSetup;
import nl.uu.cs.ape.models.AbstractModule;
import nl.uu.cs.ape.models.AllModules;
import nl.uu.cs.ape.models.AllTypes;
import nl.uu.cs.ape.models.ConstraintTemplateData;
import nl.uu.cs.ape.models.SATAtomMappings;
import nl.uu.cs.ape.models.enums.AtomType;
import nl.uu.cs.ape.models.logic.constructs.TaxonomyPredicate;
import nl.uu.cs.ape.models.templateFormulas.SLTLxTemplateFinally;
import nl.uu.cs.ape.models.templateFormulas.SLTLxTemplateFormula;
import nl.uu.cs.ape.models.templateFormulas.SLTLxTemplateGlobally;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstraintFactory {
    private static final Logger log = LoggerFactory.getLogger(ConstraintFactory.class);
    private Map<String, ConstraintTemplate> constraintTemplates = new HashMap<String, ConstraintTemplate>();

    public Collection<ConstraintTemplate> getConstraintTemplates() {
        return this.constraintTemplates.values();
    }

    public ConstraintTemplate getConstraintTemplate(String constraintID) {
        return this.constraintTemplates.get(constraintID);
    }

    public boolean addConstraintTemplate(ConstraintTemplate constraintTemplate) {
        if (this.constraintTemplates.put(constraintTemplate.getConstraintID(), constraintTemplate) != null) {
            log.warn("Duplicate constraint ID: " + constraintTemplate.getConstraintID() + ". Please change the ID in order to be able to use the constraint template.");
            return false;
        }
        return true;
    }

    public String printConstraintsCodes() {
        StringBuilder templates = new StringBuilder("{\n  \"constraints\": [\n");
        for (ConstraintTemplate currConstr : this.constraintTemplates.values()) {
            templates.append(currConstr.printConstraintCode());
        }
        templates.append("    ]\n}");
        return templates.toString();
    }

    public boolean initializeConstraints(AllModules allModules, AllTypes allTypes) {
        AbstractModule rootModule = allModules.getRootModule();
        List<TaxonomyPredicate> rootTypes = allTypes.getDataTaxonomyDimensions();
        ConstraintTemplateParameter moduleParameter = new ConstraintTemplateParameter(Arrays.asList(rootModule));
        ConstraintTemplateParameter typeParameter = new ConstraintTemplateParameter(rootTypes);
        List<ConstraintTemplateParameter> moduleParam1 = Arrays.asList(moduleParameter);
        List<ConstraintTemplateParameter> moduleParam2 = Arrays.asList(moduleParameter, moduleParameter);
        List<ConstraintTemplateParameter> typeParam1 = Arrays.asList(typeParameter);
        List<ConstraintTemplateParameter> typeParam2 = Arrays.asList(typeParameter, typeParameter);
        List<ConstraintTemplateParameter> moduleNlabel = Arrays.asList(moduleParameter, typeParameter);
        ConstraintTemplate currTemplate = new ConstraintIfThenModule("ite_m", moduleParam2, "If 1st operation is used, then 2nd operation must be used subsequently.");
        this.addConstraintTemplate(currTemplate);
        currTemplate = new ConstraintIfThenNotModule("itn_m", moduleParam2, "If 1st operation is used, then 2nd operation cannot be used subsequently.");
        this.addConstraintTemplate(currTemplate);
        currTemplate = new ConstraintDependModule("depend_m", moduleParam2, "If 1st operation is used, then we must have used 2nd operation prior to it.");
        this.addConstraintTemplate(currTemplate);
        currTemplate = new Constraint_nextModule("next_m", moduleParam2, "If 1st operation is used, then 2nd operation must be used as the next operation in the sequence.");
        this.addConstraintTemplate(currTemplate);
        currTemplate = new Constraint_prevModule("prev_m", moduleParam2, "If 1st operation is used, then we must have used 2nd operation as a previous operation in the sequence.");
        this.addConstraintTemplate(currTemplate);
        currTemplate = new ConstraintUseModule("use_m", moduleParam1, "Use operation in the solution.");
        this.addConstraintTemplate(currTemplate);
        currTemplate = new ConstraintNotUseModule("nuse_m", moduleParam1, "Do not use operation in the solution.");
        this.addConstraintTemplate(currTemplate);
        currTemplate = new Constraint_lastModule("last_m", moduleParam1, "Use operation as the last operation in the solution.");
        this.addConstraintTemplate(currTemplate);
        currTemplate = new ConstraintUseType("use_t", typeParam1, "Use type in the solution.");
        this.addConstraintTemplate(currTemplate);
        currTemplate = new ConstraintNotUseType("nuse_t", typeParam1, "Do not use type in the solution.");
        this.addConstraintTemplate(currTemplate);
        currTemplate = new ConstraintIfUseThenType("use_ite_t", typeParam2, "If 1st data is used, then 2nd data must be used subsequently.");
        this.addConstraintTemplate(currTemplate);
        currTemplate = new ConstraintIfUseThenNotType("use_itn_t", typeParam2, "If 1st data is used, then 2nd data cannot be used subsequently.");
        this.addConstraintTemplate(currTemplate);
        currTemplate = new ConstraintUseModuleWithInput("operationInput", moduleNlabel, "Use the operation with an input of the given type.");
        this.addConstraintTemplate(currTemplate);
        currTemplate = new ConstraintUseModuleWithOutput("operationOutput", moduleNlabel, "Use the operation to generate an output of the given type.");
        this.addConstraintTemplate(currTemplate);
        currTemplate = new Constraint_connectedModules("connected_op", moduleParam2, "1st operation should generate an output used by the 2nd operation.");
        this.addConstraintTemplate(currTemplate);
        currTemplate = new ConstraintNot_connectedModules("not_connected_op", moduleParam2, "1st operation should never generate an output used by the 2nd operation.");
        this.addConstraintTemplate(currTemplate);
        currTemplate = new ConstraintNot_repeatModules("not_repeat_op", moduleParam1, "No operation that belongs to the subtree should be repeated over.");
        this.addConstraintTemplate(currTemplate);
        return true;
    }

    public String getDescription(ConstraintTemplateData constr) {
        ConstraintTemplate currTmpl = this.constraintTemplates.get(constr.getConstraintID());
        List<TaxonomyPredicate> params = constr.getParameters();
        String description = currTmpl.getDescription();
        for (int i = 0; i < params.size(); ++i) {
            description = description.replace("${parameter_" + (i + 1) + "}", "'" + params.get(i).getPredicateLabel() + "'");
        }
        return description;
    }

    public ConstraintTemplateData generateConstraintTemplateData(String constraintID, List<TaxonomyPredicate> parameters) {
        if (this.isGoodConstraintFormat(constraintID, parameters)) {
            return new ConstraintTemplateData(constraintID, parameters);
        }
        return null;
    }

    public boolean isGoodConstraintFormat(String constraintID, List<TaxonomyPredicate> parameters) {
        return true;
    }

    public class ConstraintIfThenModule
    extends ConstraintTemplate {
        protected ConstraintIfThenModule(String id, List<ConstraintTemplateParameter> parameterTypes, String description) {
            super(id, parameterTypes, description);
        }

        @Override
        public String getConstraint(List<TaxonomyPredicate> parameters, APEDomainSetup domainSetup, ModuleAutomaton moduleAutomaton, TypeAutomaton typeAutomaton, SATAtomMappings mappings) {
            if (parameters.size() != this.getNoOfParameters()) {
                super.throwParametersError(parameters.size());
                return null;
            }
            return SLTLxTemplateFormula.iteModule(parameters.get(0), parameters.get(1), moduleAutomaton, mappings);
        }
    }

    public class ConstraintIfThenNotModule
    extends ConstraintTemplate {
        protected ConstraintIfThenNotModule(String id, List<ConstraintTemplateParameter> parametersNo, String description) {
            super(id, parametersNo, description);
        }

        @Override
        public String getConstraint(List<TaxonomyPredicate> parameters, APEDomainSetup domainSetup, ModuleAutomaton moduleAutomaton, TypeAutomaton typeAutomaton, SATAtomMappings mappings) {
            if (parameters.size() != this.getNoOfParameters()) {
                super.throwParametersError(parameters.size());
                return null;
            }
            return SLTLxTemplateFormula.itnModule(parameters.get(0), parameters.get(1), moduleAutomaton, mappings);
        }
    }

    public class ConstraintDependModule
    extends ConstraintTemplate {
        protected ConstraintDependModule(String id, List<ConstraintTemplateParameter> parameterTypes, String description) {
            super(id, parameterTypes, description);
        }

        @Override
        public String getConstraint(List<TaxonomyPredicate> parameters, APEDomainSetup domainSetup, ModuleAutomaton moduleAutomaton, TypeAutomaton typeAutomaton, SATAtomMappings mappings) {
            if (parameters.size() != this.getNoOfParameters()) {
                super.throwParametersError(parameters.size());
                return null;
            }
            return SLTLxTemplateFormula.dependModule(parameters.get(0), parameters.get(1), moduleAutomaton, mappings);
        }
    }

    public class Constraint_nextModule
    extends ConstraintTemplate {
        protected Constraint_nextModule(String id, List<ConstraintTemplateParameter> parametersNo, String description) {
            super(id, parametersNo, description);
        }

        @Override
        public String getConstraint(List<TaxonomyPredicate> parameters, APEDomainSetup domainSetup, ModuleAutomaton moduleAutomaton, TypeAutomaton typeAutomaton, SATAtomMappings mappings) {
            if (parameters.size() != this.getNoOfParameters()) {
                super.throwParametersError(parameters.size());
                return null;
            }
            return SLTLxTemplateFormula.nextModule(parameters.get(0), parameters.get(1), moduleAutomaton, mappings);
        }
    }

    public class Constraint_prevModule
    extends ConstraintTemplate {
        protected Constraint_prevModule(String id, List<ConstraintTemplateParameter> parametersNo, String description) {
            super(id, parametersNo, description);
        }

        @Override
        public String getConstraint(List<TaxonomyPredicate> parameters, APEDomainSetup domainSetup, ModuleAutomaton moduleAutomaton, TypeAutomaton typeAutomaton, SATAtomMappings mappings) {
            if (parameters.size() != this.getNoOfParameters()) {
                super.throwParametersError(parameters.size());
                return null;
            }
            return SLTLxTemplateFormula.prevModule(parameters.get(0), parameters.get(1), moduleAutomaton, mappings);
        }
    }

    public class ConstraintUseModule
    extends ConstraintTemplate {
        protected ConstraintUseModule(String id, List<ConstraintTemplateParameter> parametersNo, String description) {
            super(id, parametersNo, description);
        }

        @Override
        public String getConstraint(List<TaxonomyPredicate> parameters, APEDomainSetup domainSetup, ModuleAutomaton moduleAutomaton, TypeAutomaton typeAutomaton, SATAtomMappings mappings) {
            if (parameters.size() != this.getNoOfParameters()) {
                super.throwParametersError(parameters.size());
                return null;
            }
            SLTLxTemplateFinally formula = new SLTLxTemplateFinally(parameters.get(0));
            return formula.getCNF(moduleAutomaton, null, AtomType.MODULE, mappings);
        }
    }

    public class ConstraintNotUseModule
    extends ConstraintTemplate {
        protected ConstraintNotUseModule(String id, List<ConstraintTemplateParameter> parametersNo, String description) {
            super(id, parametersNo, description);
        }

        @Override
        public String getConstraint(List<TaxonomyPredicate> parameters, APEDomainSetup domainSetup, ModuleAutomaton moduleAutomaton, TypeAutomaton typeAutomaton, SATAtomMappings mappings) {
            if (parameters.size() != this.getNoOfParameters()) {
                super.throwParametersError(parameters.size());
                return null;
            }
            SLTLxTemplateGlobally formula = new SLTLxTemplateGlobally(false, parameters.get(0));
            return formula.getCNF(moduleAutomaton, null, AtomType.MODULE, mappings);
        }
    }

    public class Constraint_lastModule
    extends ConstraintTemplate {
        protected Constraint_lastModule(String id, List<ConstraintTemplateParameter> parametersNo, String description) {
            super(id, parametersNo, description);
        }

        @Override
        public String getConstraint(List<TaxonomyPredicate> parameters, APEDomainSetup domainSetup, ModuleAutomaton moduleAutomaton, TypeAutomaton typeAutomaton, SATAtomMappings mappings) {
            if (parameters.size() != this.getNoOfParameters()) {
                super.throwParametersError(parameters.size());
                return null;
            }
            return SLTLxTemplateFormula.useAsLastModule(parameters.get(0), moduleAutomaton, mappings);
        }
    }

    public class ConstraintUseType
    extends ConstraintTemplate {
        protected ConstraintUseType(String id, List<ConstraintTemplateParameter> parametersNo, String description) {
            super(id, parametersNo, description);
        }

        @Override
        public String getConstraint(List<TaxonomyPredicate> parameters, APEDomainSetup domainSetup, ModuleAutomaton moduleAutomaton, TypeAutomaton typeAutomaton, SATAtomMappings mappings) {
            if (parameters.size() != this.getNoOfParameters()) {
                super.throwParametersError(parameters.size());
                return null;
            }
            SLTLxTemplateFinally formula = new SLTLxTemplateFinally(parameters.get(0));
            return formula.getCNF(null, typeAutomaton.getUsedTypesBlocks(), AtomType.USED_TYPE, mappings);
        }
    }

    public class ConstraintNotUseType
    extends ConstraintTemplate {
        protected ConstraintNotUseType(String id, List<ConstraintTemplateParameter> parametersNo, String description) {
            super(id, parametersNo, description);
        }

        @Override
        public String getConstraint(List<TaxonomyPredicate> parameters, APEDomainSetup domainSetup, ModuleAutomaton moduleAutomaton, TypeAutomaton typeAutomaton, SATAtomMappings mappings) {
            if (parameters.size() != this.getNoOfParameters()) {
                super.throwParametersError(parameters.size());
                return null;
            }
            SLTLxTemplateGlobally formula = new SLTLxTemplateGlobally(false, parameters.get(0));
            return formula.getCNF(null, typeAutomaton.getUsedTypesBlocks(), AtomType.USED_TYPE, mappings);
        }
    }

    public class ConstraintIfUseThenType
    extends ConstraintTemplate {
        protected ConstraintIfUseThenType(String id, List<ConstraintTemplateParameter> parametersNo, String description) {
            super(id, parametersNo, description);
        }

        @Override
        public String getConstraint(List<TaxonomyPredicate> parameters, APEDomainSetup domainSetup, ModuleAutomaton moduleAutomaton, TypeAutomaton typeAutomaton, SATAtomMappings mappings) {
            if (parameters.size() != this.getNoOfParameters()) {
                super.throwParametersError(parameters.size());
                return null;
            }
            return SLTLxTemplateFormula.iteType(parameters.get(0), parameters.get(1), AtomType.USED_TYPE, typeAutomaton.getUsedTypesBlocks(), mappings);
        }
    }

    public class ConstraintIfUseThenNotType
    extends ConstraintTemplate {
        protected ConstraintIfUseThenNotType(String id, List<ConstraintTemplateParameter> parametersNo, String description) {
            super(id, parametersNo, description);
        }

        @Override
        public String getConstraint(List<TaxonomyPredicate> parameters, APEDomainSetup domainSetup, ModuleAutomaton moduleAutomaton, TypeAutomaton typeAutomaton, SATAtomMappings mappings) {
            if (parameters.size() != this.getNoOfParameters()) {
                super.throwParametersError(parameters.size());
                return null;
            }
            return SLTLxTemplateFormula.itnType(parameters.get(0), parameters.get(1), AtomType.USED_TYPE, typeAutomaton.getUsedTypesBlocks(), mappings);
        }
    }

    public class ConstraintUseModuleWithInput
    extends ConstraintTemplate {
        protected ConstraintUseModuleWithInput(String id, List<ConstraintTemplateParameter> parametersNo, String description) {
            super(id, parametersNo, description);
        }

        @Override
        public String getConstraint(List<TaxonomyPredicate> parameters, APEDomainSetup domainSetup, ModuleAutomaton moduleAutomaton, TypeAutomaton typeAutomaton, SATAtomMappings mappings) {
            if (parameters.size() != this.getNoOfParameters()) {
                super.throwParametersError(parameters.size());
                return null;
            }
            return SLTLxTemplateFormula.useModuleInput(parameters.get(0), parameters.get(1), moduleAutomaton, typeAutomaton, mappings);
        }
    }

    public class ConstraintUseModuleWithOutput
    extends ConstraintTemplate {
        protected ConstraintUseModuleWithOutput(String id, List<ConstraintTemplateParameter> parametersNo, String description) {
            super(id, parametersNo, description);
        }

        @Override
        public String getConstraint(List<TaxonomyPredicate> parameters, APEDomainSetup domainSetup, ModuleAutomaton moduleAutomaton, TypeAutomaton typeAutomaton, SATAtomMappings mappings) {
            if (parameters.size() != this.getNoOfParameters()) {
                super.throwParametersError(parameters.size());
                return null;
            }
            return SLTLxTemplateFormula.useModuleOutput(parameters.get(0), parameters.get(1), moduleAutomaton, typeAutomaton, mappings);
        }
    }

    public class Constraint_connectedModules
    extends ConstraintTemplate {
        protected Constraint_connectedModules(String id, List<ConstraintTemplateParameter> parameterTypes, String description) {
            super(id, parameterTypes, description);
        }

        @Override
        public String getConstraint(List<TaxonomyPredicate> parameters, APEDomainSetup domainSetup, ModuleAutomaton moduleAutomaton, TypeAutomaton typeAutomaton, SATAtomMappings mappings) {
            if (parameters.size() != this.getNoOfParameters()) {
                super.throwParametersError(parameters.size());
                return null;
            }
            return SLTLxTemplateFormula.connectedModules(parameters.get(0), parameters.get(1), moduleAutomaton, typeAutomaton, mappings);
        }
    }

    public class ConstraintNot_connectedModules
    extends ConstraintTemplate {
        protected ConstraintNot_connectedModules(String id, List<ConstraintTemplateParameter> parameterTypes, String description) {
            super(id, parameterTypes, description);
        }

        @Override
        public String getConstraint(List<TaxonomyPredicate> parameters, APEDomainSetup domainSetup, ModuleAutomaton moduleAutomaton, TypeAutomaton typeAutomaton, SATAtomMappings mappings) {
            if (parameters.size() != this.getNoOfParameters()) {
                super.throwParametersError(parameters.size());
                return null;
            }
            return SLTLxTemplateFormula.notConnectedModules(parameters.get(0), parameters.get(1), moduleAutomaton, typeAutomaton, mappings);
        }
    }

    public class ConstraintNot_repeatModules
    extends ConstraintTemplate {
        protected ConstraintNot_repeatModules(String id, List<ConstraintTemplateParameter> parametersNo, String description) {
            super(id, parametersNo, description);
        }

        @Override
        public String getConstraint(List<TaxonomyPredicate> parameters, APEDomainSetup domainSetup, ModuleAutomaton moduleAutomaton, TypeAutomaton typeAutomaton, SATAtomMappings mappings) {
            if (parameters.size() != this.getNoOfParameters()) {
                super.throwParametersError(parameters.size());
                return null;
            }
            return SLTLxTemplateFormula.notRepeatModules(parameters.get(0), domainSetup, moduleAutomaton, typeAutomaton, mappings);
        }
    }

    public class ConstraintNotGenType
    extends ConstraintTemplate {
        protected ConstraintNotGenType(String id, List<ConstraintTemplateParameter> parametersNo, String description) {
            super(id, parametersNo, description);
        }

        @Override
        public String getConstraint(List<TaxonomyPredicate> parameters, APEDomainSetup domainSetup, ModuleAutomaton moduleAutomaton, TypeAutomaton typeAutomaton, SATAtomMappings mappings) {
            if (parameters.size() != this.getNoOfParameters()) {
                super.throwParametersError(parameters.size());
                return null;
            }
            SLTLxTemplateGlobally formula = new SLTLxTemplateGlobally(false, parameters.get(0));
            return formula.getCNF(moduleAutomaton, typeAutomaton.getMemoryTypesBlocks(), AtomType.MEMORY_TYPE, mappings);
        }
    }

    public class ConstraintIf_genThenType
    extends ConstraintTemplate {
        protected ConstraintIf_genThenType(String id, List<ConstraintTemplateParameter> parametersNo, String description) {
            super(id, parametersNo, description);
        }

        @Override
        public String getConstraint(List<TaxonomyPredicate> parameters, APEDomainSetup domainSetup, ModuleAutomaton moduleAutomaton, TypeAutomaton typeAutomaton, SATAtomMappings mappings) {
            if (parameters.size() != this.getNoOfParameters()) {
                super.throwParametersError(parameters.size());
                return null;
            }
            return SLTLxTemplateFormula.iteType(parameters.get(0), parameters.get(1), AtomType.MEMORY_TYPE, typeAutomaton.getMemoryTypesBlocks(), mappings);
        }
    }

    public class ConstraintIf_genThenNotType
    extends ConstraintTemplate {
        protected ConstraintIf_genThenNotType(String id, List<ConstraintTemplateParameter> parametersNo, String description) {
            super(id, parametersNo, description);
        }

        @Override
        public String getConstraint(List<TaxonomyPredicate> parameters, APEDomainSetup domainSetup, ModuleAutomaton moduleAutomaton, TypeAutomaton typeAutomaton, SATAtomMappings mappings) {
            if (parameters.size() != this.getNoOfParameters()) {
                super.throwParametersError(parameters.size());
                return null;
            }
            return SLTLxTemplateFormula.itnType(parameters.get(0), parameters.get(1), AtomType.MEMORY_TYPE, typeAutomaton.getMemoryTypesBlocks(), mappings);
        }
    }

    public class ConstraintGenType
    extends ConstraintTemplate {
        protected ConstraintGenType(String id, List<ConstraintTemplateParameter> parametersNo, String description) {
            super(id, parametersNo, description);
        }

        @Override
        public String getConstraint(List<TaxonomyPredicate> parameters, APEDomainSetup domainSetup, ModuleAutomaton moduleAutomaton, TypeAutomaton typeAutomaton, SATAtomMappings mappings) {
            if (parameters.size() != this.getNoOfParameters()) {
                super.throwParametersError(parameters.size());
                return null;
            }
            SLTLxTemplateFinally formula = new SLTLxTemplateFinally(parameters.get(0));
            return formula.getCNF(moduleAutomaton, typeAutomaton.getMemoryTypesBlocks(), AtomType.MEMORY_TYPE, mappings);
        }
    }
}

