/*
 * Decompiled with CFR 0.152.
 */
package nl.uu.cs.ape.constraints;

import java.util.List;
import nl.uu.cs.ape.automaton.ModuleAutomaton;
import nl.uu.cs.ape.automaton.TypeAutomaton;
import nl.uu.cs.ape.constraints.ConstraintTemplateParameter;
import nl.uu.cs.ape.domain.APEDomainSetup;
import nl.uu.cs.ape.models.SATAtomMappings;
import nl.uu.cs.ape.models.logic.constructs.TaxonomyPredicate;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConstraintTemplate {
    private static final Logger log = LoggerFactory.getLogger(ConstraintTemplate.class);
    String constraintID;
    String description;
    List<ConstraintTemplateParameter> parameters;

    protected ConstraintTemplate(String id, List<ConstraintTemplateParameter> parameters, String description) {
        this.constraintID = id;
        this.parameters = parameters;
        this.description = description;
    }

    public void setConstraintID(String constraintID) {
        this.constraintID = constraintID;
    }

    public String getDescription() {
        return this.description;
    }

    public int getNoOfParameters() {
        return this.parameters.size();
    }

    public String getConstraintID() {
        return this.constraintID;
    }

    public List<ConstraintTemplateParameter> getParameters() {
        return this.parameters;
    }

    public ConstraintTemplateParameter getParameter(int index) {
        return this.parameters.get(index);
    }

    public abstract String getConstraint(List<TaxonomyPredicate> var1, APEDomainSetup var2, ModuleAutomaton var3, TypeAutomaton var4, SATAtomMappings var5);

    public String printConstraintCode() {
        return this.toJSON().toString(3) + ",\n";
    }

    public JSONObject toJSON() {
        JSONObject currJson = new JSONObject();
        currJson.put("id", (Object)this.constraintID);
        currJson.put("label", (Object)this.description);
        JSONArray params = new JSONArray();
        for (ConstraintTemplateParameter param : this.parameters) {
            params.put((Object)param.toJSON());
        }
        currJson.put("parameters", (Object)params);
        return currJson;
    }

    public void throwParametersError(int givenParameters) {
        log.error("Error in the constraints file.\nConstraint: " + this.description + "\nExpected number of parameters: " + this.parameters.size() + ".\nProvided number of parameters: " + givenParameters);
    }
}

