/*
 * Decompiled with CFR 0.152.
 */
package nl.uu.cs.ape.domain;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import nl.uu.cs.ape.configuration.APECoreConfig;
import nl.uu.cs.ape.configuration.ToolAnnotationTag;
import nl.uu.cs.ape.constraints.ConstraintFactory;
import nl.uu.cs.ape.constraints.ConstraintFormatException;
import nl.uu.cs.ape.constraints.ConstraintTemplate;
import nl.uu.cs.ape.constraints.ConstraintTemplateParameter;
import nl.uu.cs.ape.domain.APEDimensionsException;
import nl.uu.cs.ape.models.AbstractModule;
import nl.uu.cs.ape.models.AllModules;
import nl.uu.cs.ape.models.AllTypes;
import nl.uu.cs.ape.models.AuxiliaryPredicate;
import nl.uu.cs.ape.models.ConstraintTemplateData;
import nl.uu.cs.ape.models.Module;
import nl.uu.cs.ape.models.Type;
import nl.uu.cs.ape.models.logic.constructs.TaxonomyPredicate;
import nl.uu.cs.ape.utils.APEUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class APEDomainSetup {
    private static final Logger log = LoggerFactory.getLogger(APEDomainSetup.class);
    private Set<String> emptyTools = new HashSet<String>();
    private Set<String> wrongToolIO = new HashSet<String>();
    private Set<String> wrongToolTax = new HashSet<String>();
    private AllModules allModules;
    private AllTypes allTypes;
    private String ontologyPrefixIRI;
    private ConstraintFactory constraintFactory = new ConstraintFactory();
    private List<ConstraintTemplateData> unformattedConstr = new ArrayList<ConstraintTemplateData>();
    private List<AuxiliaryPredicate> helperPredicates = new ArrayList<AuxiliaryPredicate>();
    private List<String> constraintsSLTLx = new ArrayList<String>();
    private int maxNoToolInputs = 0;
    private int maxNoToolOutputs = 0;
    private boolean useStrictToolAnnotations;
    private static final String CONSTR_JSON_TAG = "constraints";
    private static final String CONSTR_ID_TAG = "constraintid";
    private static final String CONSTR_SLTLx = "formula";
    private static final String CONSTR_PARAM_JSON_TAG = "parameters";
    private static final String TOOLS_JSON_TAG = "functions";

    public APEDomainSetup(APECoreConfig config) {
        this.allModules = new AllModules(config);
        this.allTypes = new AllTypes(config);
        this.ontologyPrefixIRI = config.getOntologyPrefixIRI();
        this.useStrictToolAnnotations = config.getUseStrictToolAnnotations();
    }

    public AllModules getAllModules() {
        return this.allModules;
    }

    public void addConstraintData(ConstraintTemplateData constr) {
        this.unformattedConstr.add(constr);
    }

    public void addSLTLxConstraint(String formulaSLTLx) {
        this.constraintsSLTLx.add(formulaSLTLx);
    }

    public List<ConstraintTemplateData> getUnformattedConstr() {
        return this.unformattedConstr;
    }

    public List<String> getSLTLxConstraints() {
        return this.constraintsSLTLx;
    }

    public void clearConstraints() {
        this.unformattedConstr.clear();
        this.constraintsSLTLx.clear();
    }

    public AllTypes getAllTypes() {
        return this.allTypes;
    }

    public ConstraintFactory getConstraintFactory() {
        return this.constraintFactory;
    }

    public void initializeConstraints() {
        this.constraintFactory.initializeConstraints(this.allModules, this.allTypes);
    }

    public boolean trimTaxonomy() {
        boolean succRun = true;
        succRun &= this.allModules.trimTaxonomy();
        return succRun &= this.allTypes.trimTaxonomy();
    }

    public ConstraintTemplate getConstraintTemplate(String constraintID) {
        return this.constraintFactory.getConstraintTemplate(constraintID);
    }

    public void updateConstraints(JSONArray constraintsJSONArray) throws ConstraintFormatException {
        if (constraintsJSONArray == null) {
            return;
        }
        String constraintID = null;
        int currNode = 0;
        List<JSONObject> constraints = APEUtils.getListFromJsonList(constraintsJSONArray, JSONObject.class);
        for (JSONObject jsonConstraint : APEUtils.safe(constraints)) {
            ++currNode;
            try {
                constraintID = jsonConstraint.getString(CONSTR_ID_TAG);
                ConstraintTemplate currConstrTemplate = this.getConstraintFactory().getConstraintTemplate(constraintID);
                if (currConstrTemplate == null) {
                    if (constraintID.equals("SLTLx")) {
                        String formulaSLTLx = jsonConstraint.getString(CONSTR_SLTLx);
                        if (formulaSLTLx == null) {
                            throw ConstraintFormatException.wrongNumberOfParameters(this.getConstrErrorMsg(currNode, constraintID));
                        }
                        this.addSLTLxConstraint(formulaSLTLx);
                        continue;
                    }
                    throw ConstraintFormatException.wrongConstraintID(this.getConstrErrorMsg(currNode, constraintID));
                }
                List<ConstraintTemplateParameter> currTemplateParameters = currConstrTemplate.getParameters();
                List<JSONObject> jsonConstParam = APEUtils.getListFromJson(jsonConstraint, CONSTR_PARAM_JSON_TAG, JSONObject.class);
                if (currTemplateParameters.size() != jsonConstParam.size()) {
                    throw ConstraintFormatException.wrongNumberOfParameters(this.getConstrErrorMsg(currNode, constraintID));
                }
                int paramNo = 0;
                ArrayList<TaxonomyPredicate> constraintParameters = new ArrayList<TaxonomyPredicate>();
                for (JSONObject jsonParam : jsonConstParam) {
                    ConstraintTemplateParameter taxInstanceFromJson = currTemplateParameters.get(paramNo++);
                    TaxonomyPredicate currParameter = taxInstanceFromJson.readConstraintParameterFromJson(jsonParam, this);
                    constraintParameters.add(currParameter);
                }
                ConstraintTemplateData currConstr = this.getConstraintFactory().generateConstraintTemplateData(constraintID, constraintParameters);
                if (constraintParameters.stream().anyMatch(Objects::isNull)) {
                    throw ConstraintFormatException.wrongParameter(this.getConstrErrorMsg(currNode, constraintID));
                }
                this.addConstraintData(currConstr);
            }
            catch (JSONException e) {
                throw ConstraintFormatException.badFormat(this.getConstrErrorMsg(currNode, constraintID));
            }
        }
    }

    private String getConstrErrorMsg(int currNode, String constraintID) {
        return String.format("Error at constraint no: %d, constraint ID: %s", currNode, constraintID);
    }

    public boolean annotateToolFromJson(JSONObject toolAnnotationsFile) throws IOException, JSONException {
        int currModule = 0;
        for (JSONObject jsonModule : APEUtils.safe(APEUtils.getListFromJson(toolAnnotationsFile, TOOLS_JSON_TAG, JSONObject.class))) {
            ++currModule;
            this.updateModuleFromJson(jsonModule);
        }
        if (currModule == 0) {
            log.warn("No tools were annotated in the current domain.");
            return false;
        }
        return true;
    }

    private boolean updateModuleFromJson(JSONObject jsonModule) throws JSONException, APEDimensionsException {
        List<Type> outputs;
        List<Type> inputs;
        String moduleIRI = APEUtils.createClassIRI(jsonModule.getString(ToolAnnotationTag.ID.toString()), this.ontologyPrefixIRI);
        if (this.allModules.get(moduleIRI) != null) {
            moduleIRI = moduleIRI + "[tool]";
        }
        String moduleLabel = jsonModule.getString(ToolAnnotationTag.LABEL.toString());
        Set<String> taxonomyParentModules = new HashSet<String>(APEUtils.getListFromJson(jsonModule, ToolAnnotationTag.TAXONOMY_OPERATIONS.toString(), String.class));
        taxonomyParentModules = APEUtils.createIRIsFromLabels(taxonomyParentModules, this.ontologyPrefixIRI);
        ArrayList<String> toRemove = new ArrayList<String>();
        for (String parentModule : taxonomyParentModules) {
            String parentModuleIRI = APEUtils.createClassIRI(parentModule, this.ontologyPrefixIRI);
            if (this.allModules.get(parentModuleIRI) != null) continue;
            log.warn("Tool '" + moduleIRI + "' annotation issue. Referenced '" + ToolAnnotationTag.TAXONOMY_OPERATIONS.toString() + "': '" + parentModuleIRI + "' cannot be found in the Tool Taxonomy.");
            this.wrongToolTax.add(moduleLabel);
            toRemove.add(parentModuleIRI);
        }
        taxonomyParentModules.removeAll(toRemove);
        if (taxonomyParentModules.isEmpty()) {
            log.warn("Tool '" + moduleIRI + "' annotation issue. None of the referenced '" + ToolAnnotationTag.TAXONOMY_OPERATIONS.toString() + "' can be found in the Tool Taxonomy.");
            taxonomyParentModules.add(this.allModules.getRootModuleID());
        }
        try {
            inputs = this.getToolInputsFromAnnotation(jsonModule);
            this.updateMaxNoToolInputs(inputs.size());
            outputs = this.getToolOutputsFromAnnotation(jsonModule);
            this.updateMaxNoToolOutputs(outputs.size());
            if (inputs.isEmpty() && outputs.isEmpty()) {
                this.emptyTools.add(moduleLabel);
                log.debug("Operation '' was not included as it has no (valid) inputs and outputs specified.");
                return false;
            }
        }
        catch (APEDimensionsException badDimension) {
            this.wrongToolIO.add(moduleLabel);
            log.warn("Operation '' was not included." + badDimension.getMessage());
            return false;
        }
        String cwlReference = this.getModuleImplementationFromAnnotation(jsonModule, ToolAnnotationTag.CWL_REFERENCE);
        String executionCode = this.getModuleImplementationFromAnnotation(jsonModule, ToolAnnotationTag.CODE);
        Module currModule = (Module)this.allModules.addPredicate(new Module(moduleLabel, moduleIRI, this.allModules.getRootModuleID(), cwlReference, executionCode));
        for (String parentModuleID : taxonomyParentModules) {
            AbstractModule parentModule = this.allModules.get(parentModuleID);
            if (parentModule == null) continue;
            parentModule.addSubPredicate(currModule);
            currModule.addParentPredicate(parentModule);
        }
        currModule.setModuleInput(inputs);
        currModule.setModuleOutput(outputs);
        currModule.setAsRelevantTaxonomyTerm(this.allModules);
        return currModule != null;
    }

    private List<Type> getToolInputsFromAnnotation(JSONObject jsonModule) throws APEDimensionsException {
        List<JSONObject> jsonModuleInput = APEUtils.getListFromJson(jsonModule, ToolAnnotationTag.INPUTS.toString(), JSONObject.class);
        ArrayList<Type> inputs = new ArrayList<Type>();
        for (JSONObject jsonInput : jsonModuleInput) {
            if (jsonInput.isEmpty()) continue;
            inputs.add(Type.taxonomyInstanceFromJson(jsonInput, this, false));
        }
        return inputs;
    }

    private List<Type> getToolOutputsFromAnnotation(JSONObject jsonModule) throws APEDimensionsException {
        List<JSONObject> jsonModuleOutput = APEUtils.getListFromJson(jsonModule, ToolAnnotationTag.OUTPUTS.toString(), JSONObject.class);
        ArrayList<Type> outputs = new ArrayList<Type>();
        for (JSONObject jsonOutput : jsonModuleOutput) {
            if (jsonOutput.isEmpty()) continue;
            outputs.add(Type.taxonomyInstanceFromJson(jsonOutput, this, true));
        }
        return outputs;
    }

    private String getModuleImplementationFromAnnotation(JSONObject jsonToolAnnotation, ToolAnnotationTag implementationType) {
        try {
            JSONObject implementationJson = jsonToolAnnotation.getJSONObject(ToolAnnotationTag.IMPLEMENTATION.toString());
            String implementation = implementationJson.getString(implementationType.toString());
            if (implementation.equals("")) {
                return null;
            }
            return implementation;
        }
        catch (JSONException e) {
            return null;
        }
    }

    public String getOntologyPrefixIRI() {
        return this.ontologyPrefixIRI;
    }

    public int getMaxNoToolInputs() {
        return this.maxNoToolInputs;
    }

    public void updateMaxNoToolInputs(int currNoInputs) {
        if (this.maxNoToolInputs < currNoInputs) {
            this.maxNoToolInputs = currNoInputs;
        }
    }

    public int getMaxNoToolOutputs() {
        return this.maxNoToolOutputs;
    }

    public void updateMaxNoToolOutputs(int currNoOutputs) {
        if (this.maxNoToolOutputs < currNoOutputs) {
            this.maxNoToolOutputs = currNoOutputs;
        }
    }

    public void addHelperPredicate(AuxiliaryPredicate helperPredicate) {
        this.helperPredicates.add(helperPredicate);
    }

    public boolean getUseStrictToolAnnotations() {
        return this.useStrictToolAnnotations;
    }

    public List<AuxiliaryPredicate> getHelperPredicates() {
        return this.helperPredicates;
    }
}

