/*
 * Decompiled with CFR 0.152.
 */
package nl.uu.cs.ape.domain;

import java.io.File;
import java.io.IOException;
import java.util.List;
import nl.uu.cs.ape.configuration.ToolAnnotationTag;
import nl.uu.cs.ape.utils.APEFiles;
import nl.uu.cs.ape.utils.APEUtils;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.io.FileUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BioToolsAPI {
    private static final Logger log = LoggerFactory.getLogger(BioToolsAPI.class);
    public static final OkHttpClient client = new OkHttpClient();

    public static void fetchToolSet(String listFilePath, String destinationFilePath) throws IOException {
        JSONArray bioToolsRAW = BioToolsAPI.readListOfTools(listFilePath);
        JSONObject apeToolAnnotation = BioToolsAPI.convertBioTools2Ape(bioToolsRAW);
        APEFiles.write2file(apeToolAnnotation.toString(4), new File(destinationFilePath), false);
    }

    public static JSONArray readListOfTools(String filePath) throws IOException {
        File toolList = new File(filePath);
        JSONArray toolListJson = new JSONArray(FileUtils.readFileToString((File)toolList, (String)"UTF-8"));
        return BioToolsAPI.fetchToolListFromBioTools(toolListJson);
    }

    public static JSONArray getToolsFromDomain(String domainName) throws IOException {
        JSONArray toolAnnotations = null;
        toolAnnotations = !domainName.equals("") ? BioToolsAPI.fetchToolsFromURI("https://bio.tools/api/t?domain=" + domainName + "&format=json") : BioToolsAPI.fetchToolsFromURI("https://bio.tools/api/t?format=json");
        return toolAnnotations;
    }

    public static JSONArray getToolsFromEDAMTopic(String topicName) throws IOException {
        JSONArray toolAnnotations = null;
        toolAnnotations = topicName != "" ? BioToolsAPI.fetchToolsFromURI("https://bio.tools/api/t?topicID=\"" + topicName + "\"&format=json") : BioToolsAPI.fetchToolsFromURI("https://bio.tools/api/t?format=json");
        return toolAnnotations;
    }

    private static JSONArray fetchToolListFromBioTools(JSONArray toolListJson) throws JSONException, IOException {
        JSONArray bioToolAnnotations = new JSONArray();
        for (int i = 0; i < toolListJson.length(); ++i) {
            String currTool = toolListJson.getString(i);
            Request request = new Request.Builder().url("https://bio.tools/api/" + currTool + "?format=json").build();
            try (Response response = client.newCall(request).execute();){
                if (!response.isSuccessful()) {
                    throw new IOException("Unexpected code when trying to fetch" + response);
                }
                JSONObject responseJson = new JSONObject(response.body().string());
                bioToolAnnotations.put(i, (Object)responseJson);
                continue;
            }
        }
        log.debug("The list of tools successfully fetched from bio.tools.");
        return bioToolAnnotations;
    }

    private static JSONArray fetchToolsFromURI(String url) throws JSONException, IOException {
        JSONArray bioToolAnnotations = new JSONArray();
        String next = "";
        int i = 1;
        while (next != null) {
            Request request = new Request.Builder().url(url + "&format=json" + next.replace('?', '&')).build();
            try (Response response = client.newCall(request).execute();){
                if (!response.isSuccessful()) {
                    throw new IOException("Unexpected code when trying to fetch" + response);
                }
                JSONObject responseJson = new JSONObject(response.body().string());
                JSONArray toolListJson = responseJson.getJSONArray("list");
                for (int j = 0; j < toolListJson.length(); ++j) {
                    JSONObject tool = toolListJson.getJSONObject(j);
                    bioToolAnnotations.put((Object)tool);
                }
                try {
                    next = responseJson.getString("next");
                }
                catch (JSONException e) {
                    next = null;
                }
            }
            log.trace("bio.tools: page " + i + " fetched.");
        }
        log.debug("All tools fetched from a given URL.");
        return bioToolAnnotations;
    }

    public static JSONObject convertBioTools2Ape(JSONArray bioToolsAnnotation) throws JSONException {
        JSONArray apeToolsAnnotations = new JSONArray();
        for (int i = 0; i < bioToolsAnnotation.length(); ++i) {
            JSONObject bioJsonTool = bioToolsAnnotation.getJSONObject(i);
            List<JSONObject> functions = APEUtils.getListFromJson(bioJsonTool, "function", JSONObject.class);
            int functionNo = 1;
            for (JSONObject function : functions) {
                JSONObject apeJsonTool = new JSONObject();
                apeJsonTool.put(ToolAnnotationTag.LABEL.toString(), (Object)bioJsonTool.getString("name"));
                apeJsonTool.put(ToolAnnotationTag.ID.toString(), (Object)(bioJsonTool.getString("biotoolsID") + functionNo++));
                JSONArray apeTaxonomyTerms = new JSONArray();
                JSONArray operations = function.getJSONArray("operation");
                for (int j = 0; j < operations.length(); ++j) {
                    JSONObject bioOperation = operations.getJSONObject(j);
                    apeTaxonomyTerms.put(bioOperation.get("uri"));
                }
                apeJsonTool.put(ToolAnnotationTag.TAXONOMY_OPERATIONS.toString(), (Object)apeTaxonomyTerms);
                JSONArray apeInputs = new JSONArray();
                JSONArray bioInputs = function.getJSONArray("input");
                for (int j = 0; j < bioInputs.length(); ++j) {
                    JSONObject bioInput = bioInputs.getJSONObject(j);
                    JSONObject apeInput = new JSONObject();
                    JSONArray apeInputTypes = new JSONArray();
                    JSONArray apeInputFormats = new JSONArray();
                    for (JSONObject bioType : APEUtils.getListFromJson(bioInput, "data", JSONObject.class)) {
                        apeInputTypes.put((Object)bioType.getString("uri"));
                    }
                    apeInput.put("data_0006", (Object)apeInputTypes);
                    for (JSONObject bioType : APEUtils.getListFromJson(bioInput, "format", JSONObject.class)) {
                        apeInputFormats.put((Object)bioType.getString("uri"));
                    }
                    apeInput.put("format_1915", (Object)apeInputFormats);
                    apeInputs.put((Object)apeInput);
                }
                apeJsonTool.put(ToolAnnotationTag.INPUTS.toString(), (Object)apeInputs);
                JSONArray apeOutputs = new JSONArray();
                JSONArray bioOutputs = function.getJSONArray("output");
                for (int j = 0; j < bioOutputs.length(); ++j) {
                    JSONObject bioOutput = bioOutputs.getJSONObject(j);
                    JSONObject apeOutput = new JSONObject();
                    JSONArray apeOutputTypes = new JSONArray();
                    JSONArray apeOutputFormats = new JSONArray();
                    for (JSONObject bioType : APEUtils.getListFromJson(bioOutput, "data", JSONObject.class)) {
                        apeOutputTypes.put((Object)bioType.getString("uri"));
                    }
                    apeOutput.put("data_0006", (Object)apeOutputTypes);
                    for (JSONObject bioType : APEUtils.getListFromJson(bioOutput, "format", JSONObject.class)) {
                        apeOutputFormats.put((Object)bioType.getString("uri"));
                    }
                    apeOutput.put("format_1915", (Object)apeOutputFormats);
                    apeOutputs.put((Object)apeOutput);
                }
                apeJsonTool.put(ToolAnnotationTag.OUTPUTS.toString(), (Object)apeOutputs);
                apeToolsAnnotations.put((Object)apeJsonTool);
            }
        }
        return new JSONObject().put("functions", (Object)apeToolsAnnotations);
    }

    private BioToolsAPI() {
    }
}

