/*
 * Decompiled with CFR 0.152.
 */
package nl.uu.cs.ape.domain;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import nl.uu.cs.ape.domain.APEDimensionsException;
import nl.uu.cs.ape.domain.APEDomainSetup;
import nl.uu.cs.ape.models.AbstractModule;
import nl.uu.cs.ape.models.AllModules;
import nl.uu.cs.ape.models.AllTypes;
import nl.uu.cs.ape.models.Type;
import nl.uu.cs.ape.models.enums.NodeType;
import nl.uu.cs.ape.models.logic.constructs.TaxonomyPredicate;
import org.apache.commons.io.FileExistsException;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.structural.StructuralReasonerFactory;
import org.semanticweb.owlapi.search.EntitySearcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OWLReader {
    private static final Logger log = LoggerFactory.getLogger(OWLReader.class);
    private final File ontologyFile;
    private final AllModules allModules;
    private final AllTypes allTypes;
    private Map<String, Set<String>> typeDimensions = new HashMap<String, Set<String>>();
    private OWLOntology ontology;
    private OWLDataFactory factory;
    private java.util.logging.Logger logger = java.util.logging.Logger.getLogger("OWLReader.class");
    private boolean useStrictToolAnnotations;

    public OWLReader(APEDomainSetup domain, File ontologyFile) {
        this.ontologyFile = ontologyFile;
        this.allModules = domain.getAllModules();
        this.allTypes = domain.getAllTypes();
        this.factory = OWLManager.getOWLDataFactory();
        this.useStrictToolAnnotations = domain.getUseStrictToolAnnotations();
    }

    public boolean readOntology() throws APEDimensionsException, OWLOntologyCreationException {
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        if (!this.ontologyFile.exists()) {
            this.logger.warning("Provided ontology does not exist.");
            return false;
        }
        this.ontology = manager.loadOntologyFromOntologyDocument(this.ontologyFile);
        StructuralReasonerFactory reasonerFactory = new StructuralReasonerFactory();
        OWLReasoner reasoner = reasonerFactory.createNonBufferingReasoner(this.ontology);
        String moduleRootIRI = this.allModules.getRootModuleID();
        OWLClass moduleRootClass = manager.getOWLDataFactory().getOWLClass(IRI.create((String)moduleRootIRI));
        if (!this.ontology.containsClassInSignature(IRI.create((String)moduleRootIRI))) {
            throw APEDimensionsException.notExistingDimension(String.format("Operation root %s does not exist in the ontology.", moduleRootIRI));
        }
        ArrayList<OWLClass> dimensionRootClasses = new ArrayList<OWLClass>();
        for (String dimensionIRI : this.allTypes.getDataTaxonomyDimensionIDs()) {
            OWLClass dimensionClass = manager.getOWLDataFactory().getOWLClass(IRI.create((String)dimensionIRI));
            if (!this.ontology.containsClassInSignature(IRI.create((String)dimensionIRI))) {
                throw APEDimensionsException.notExistingDimension(String.format("Data dimension %s does not exist in the ontology.", dimensionIRI));
            }
            dimensionRootClasses.add(dimensionClass);
        }
        this.exploreModuleOntologyRec(reasoner, moduleRootClass, null, null);
        dimensionRootClasses.forEach(typeClass -> this.typeDimensions.put(this.getIRI((OWLClass)typeClass), new HashSet()));
        dimensionRootClasses.forEach(typeClass -> this.exploreTypeOntologyRec(reasoner, (OWLClass)typeClass, null, null));
        String ovesrlap = this.dimensionsDisjoint(dimensionRootClasses);
        if (ovesrlap != null) {
            throw APEDimensionsException.dimensionsOverlap("The dimensions '" + ovesrlap + "' have common classes.");
        }
        return true;
    }

    public static boolean verifyOntology(File ontologyFile, String ontologyPrefixIRI, String toolTaxonomyRoot, List<String> dataDimensionRoots) throws APEDimensionsException, OWLOntologyCreationException, FileExistsException {
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        AllModules allModules = new AllModules(toolTaxonomyRoot);
        AllTypes allTypes = new AllTypes(dataDimensionRoots);
        OWLOntology ontology = null;
        if (!ontologyFile.exists()) {
            throw new FileExistsException("Ontology file does not exist.");
        }
        ontology = manager.loadOntologyFromOntologyDocument(ontologyFile);
        StructuralReasonerFactory reasonerFactory = new StructuralReasonerFactory();
        OWLReasoner reasoner = reasonerFactory.createNonBufferingReasoner(ontology);
        OWLDataFactory factory = OWLManager.getOWLDataFactory();
        String moduleRootIRI = allModules.getRootModuleID();
        OWLClass moduleRootClass = manager.getOWLDataFactory().getOWLClass(IRI.create((String)moduleRootIRI));
        if (!ontology.containsClassInSignature(IRI.create((String)moduleRootIRI))) {
            throw APEDimensionsException.notExistingDimension(String.format("Operation root %s does not exist in the ontology.", moduleRootIRI));
        }
        ArrayList<OWLClass> dimensionRootClasses = new ArrayList<OWLClass>();
        for (String dimensionIRI : allTypes.getDataTaxonomyDimensionIDs()) {
            OWLClass dimensionClass = manager.getOWLDataFactory().getOWLClass(IRI.create((String)dimensionIRI));
            if (!ontology.containsClassInSignature(IRI.create((String)dimensionIRI))) {
                throw APEDimensionsException.notExistingDimension(String.format("Data dimension %s does not exist in the ontology.", dimensionIRI));
            }
            dimensionRootClasses.add(dimensionClass);
        }
        return true;
    }

    private String dimensionsDisjoint(List<OWLClass> typeClasses) {
        if (typeClasses.size() < 2) {
            return null;
        }
        for (OWLClass class1 : typeClasses) {
            for (OWLClass class2 : typeClasses) {
                String classID2;
                String classID1 = this.getIRI(class1);
                if (classID1.equals(classID2 = this.getIRI(class2)) || Collections.disjoint((Collection)this.typeDimensions.get(classID1), (Collection)this.typeDimensions.get(classID2))) continue;
                return classID1 + " & " + classID2;
            }
        }
        return null;
    }

    private void exploreModuleOntologyRec(OWLReasoner reasoner, OWLClass currClass, OWLClass superClass, OWLClass rootClass) {
        OWLClass currRootClass;
        AbstractModule superModule = this.allModules.get(this.getIRI(superClass));
        NodeType currNodeType = NodeType.ABSTRACT;
        if (this.getIRI(currClass).equals(this.allModules.getRootModuleID())) {
            currNodeType = NodeType.ROOT;
            currRootClass = currClass;
        } else {
            currRootClass = rootClass;
        }
        TaxonomyPredicate currModule = null;
        try {
            currModule = this.allModules.addPredicate(new AbstractModule(this.getLabel(currClass), this.getIRI(currClass), this.getIRI(currRootClass), currNodeType));
        }
        catch (ExceptionInInitializerError e) {
            e.printStackTrace();
        }
        if (superModule != null && currModule != null) {
            superModule.addSubPredicate(currModule);
        }
        if (currNodeType != NodeType.ROOT) {
            currModule.addParentPredicate(superModule);
        }
        reasoner.getSubClasses((OWLClassExpression)currClass, true).entities().filter(child -> reasoner.isSatisfiable((OWLClassExpression)child)).forEach(child -> this.exploreModuleOntologyRec(reasoner, (OWLClass)child, currClass, currRootClass));
    }

    private void exploreTypeOntologyRec(OWLReasoner reasoner, OWLClass currClass, OWLClass superClass, OWLClass rootClass) {
        OWLClass currRoot;
        Type superType = null;
        Type currType = null;
        superType = this.allTypes.get(this.getIRI(superClass), this.getIRI(rootClass));
        NodeType currNodeType = NodeType.ABSTRACT;
        if (this.allTypes.getDataTaxonomyDimensionIDs().contains(this.getIRI(currClass))) {
            currNodeType = NodeType.ROOT;
            currRoot = currClass;
        } else {
            currRoot = rootClass;
        }
        currType = this.addNewTypeToAllTypes(this.getLabel(currClass), this.getIRI(currClass), this.getIRI(currRoot), currNodeType);
        if (superType != null && currType != null) {
            superType.addSubPredicate(currType);
        }
        if (currNodeType != NodeType.ROOT) {
            currType.addParentPredicate(superType);
        }
        List<OWLClass> subClasses = reasoner.getSubClasses((OWLClassExpression)currClass, true).entities().filter(arg_0 -> ((OWLReasoner)reasoner).isSatisfiable(arg_0)).collect(Collectors.toList());
        subClasses.forEach(child -> this.exploreTypeOntologyRec(reasoner, (OWLClass)child, currClass, currRoot));
        if (subClasses.isEmpty()) {
            currType.setNodePredicate(NodeType.LEAF);
        } else if (this.useStrictToolAnnotations) {
            Type artificialSubType = this.addNewTypeToAllTypes(this.getLabel(currClass) + "_p", this.getIRI(currClass) + "_plain", this.getIRI(currRoot), NodeType.ARTIFICIAL_LEAF);
            if (artificialSubType != null) {
                currType.addSubPredicate(artificialSubType);
                currType.setPlainType(artificialSubType);
                artificialSubType.addParentPredicate(currType);
                artificialSubType.setNodePredicate(NodeType.LEAF);
            } else {
                log.warn("Artificial predicate '" + this.getLabel(currClass) + "' was not created correctly.");
            }
        }
    }

    private Type addNewTypeToAllTypes(String classLabel, String classID, String rootID, NodeType currNodeType) {
        Type currType = null;
        try {
            currType = this.allTypes.addPredicate(new Type(classLabel, classID, rootID, currNodeType));
            this.typeDimensions.get(rootID).add(classID);
        }
        catch (ExceptionInInitializerError e) {
            e.printStackTrace();
        }
        return currType;
    }

    private String getLabel(OWLClass currClass) {
        if (currClass == null || currClass.isOWLNothing()) {
            return "N/A";
        }
        String classID = currClass.toStringID();
        Optional classLabel = EntitySearcher.getAnnotations((OWLEntity)currClass, (OWLOntology)this.ontology, (OWLAnnotationProperty)this.factory.getRDFSLabel()).findFirst();
        if (classLabel.isPresent()) {
            OWLAnnotationValue val = ((OWLAnnotation)classLabel.get()).getValue();
            if (val instanceof OWLLiteral) {
                return ((OWLLiteral)val).getLiteral();
            }
        } else if (classID.contains("#")) {
            String label = classID.substring(classID.indexOf(35) + 1);
            return label;
        }
        this.logger.fine("Class '" + classID + "' has no label.");
        return classID;
    }

    private String getIRI(OWLClass currClass) {
        if (currClass == null) {
            return "N/A";
        }
        return currClass.toStringID();
    }
}

