/*
 * Decompiled with CFR 0.152.
 */
package nl.uu.cs.ape.models;

import java.util.List;
import nl.uu.cs.ape.models.Type;
import nl.uu.cs.ape.models.enums.NodeType;
import nl.uu.cs.ape.models.logic.constructs.TaxonomyPredicate;
import nl.uu.cs.ape.utils.APEUtils;

public class AbstractModule
extends TaxonomyPredicate {
    private final String moduleName;
    private final String moduleID;

    public AbstractModule(String moduleName, String moduleID, String rootNode, NodeType nodeType) {
        super(rootNode, nodeType);
        this.moduleName = moduleName;
        this.moduleID = moduleID;
    }

    public AbstractModule(TaxonomyPredicate abstractModule, NodeType nodeType) {
        super(abstractModule, nodeType != null ? nodeType : abstractModule.getNodeType());
        this.moduleName = abstractModule.getPredicateLabel();
        this.moduleID = abstractModule.getPredicateID();
    }

    @Override
    public String getPredicateID() {
        return this.moduleID;
    }

    @Override
    public String getPredicateLabel() {
        return this.moduleName;
    }

    @Override
    public String getPredicateLongLabel() {
        if (this.moduleID.endsWith("[tool]")) {
            return APEUtils.removeNLastChar(this.moduleID, 6);
        }
        return this.moduleID;
    }

    public List<Type> getModuleInput() {
        return null;
    }

    public List<Type> getModuleOutput() {
        return null;
    }

    @Override
    public String getType() {
        return "abstract module";
    }
}

