/*
 * Decompiled with CFR 0.152.
 */
package nl.uu.cs.ape.models;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import nl.uu.cs.ape.configuration.APECoreConfig;
import nl.uu.cs.ape.models.AbstractModule;
import nl.uu.cs.ape.models.AllPredicates;
import nl.uu.cs.ape.models.Module;
import nl.uu.cs.ape.models.Pair;
import nl.uu.cs.ape.models.logic.constructs.PredicateLabel;
import nl.uu.cs.ape.models.logic.constructs.TaxonomyPredicate;
import nl.uu.cs.ape.utils.APEUtils;

public class AllModules
extends AllPredicates {
    public AllModules(APECoreConfig config) {
        super(Arrays.asList(config.getToolTaxonomyRoot()));
    }

    public AllModules(String moduleTaxonomyRoot) {
        super(Arrays.asList(moduleTaxonomyRoot));
    }

    public Collection<TaxonomyPredicate> getModules() {
        return this.getMappedPredicates().values();
    }

    @Override
    public AbstractModule addPredicate(TaxonomyPredicate module) throws ExceptionInInitializerError {
        TaxonomyPredicate tmpModule = this.getMappedPredicates().get(module.getPredicateID());
        if (module instanceof Module && tmpModule != null) {
            if (tmpModule instanceof Module) {
                return (Module)tmpModule;
            }
            Module newModule = new Module((Module)module, tmpModule);
            this.swapAbstractModule2Module(newModule, tmpModule);
            return newModule;
        }
        if (tmpModule != null) {
            return (AbstractModule)tmpModule;
        }
        if (module instanceof AbstractModule) {
            this.getMappedPredicates().put(module.getPredicateID(), module);
            return (AbstractModule)module;
        }
        throw new ExceptionInInitializerError(String.format("Type error. Only 'AbstractModule' StateInterface can be added to the set of all modules. '%s' is not a type", module.getPredicateID()));
    }

    public void swapAbstractModule2Module(Module newModule, TaxonomyPredicate oldModule) {
        this.getMappedPredicates().remove(oldModule.getPredicateID());
        this.getMappedPredicates().put(newModule.getPredicateID(), newModule);
    }

    @Override
    public AbstractModule get(String moduleID) {
        return (AbstractModule)super.get(moduleID);
    }

    public Set<Pair<PredicateLabel>> getSimplePairs() {
        HashSet<TaxonomyPredicate> iterator = new HashSet<TaxonomyPredicate>();
        for (TaxonomyPredicate module : this.getMappedPredicates().values()) {
            if (!module.isSimplePredicate()) continue;
            iterator.add(module);
        }
        return APEUtils.getUniquePairs(iterator);
    }

    public AbstractModule getRootModule() {
        return (AbstractModule)this.getRootPredicates().get(0);
    }

    public String getRootModuleID() {
        return this.getAllRootIDs().get(0);
    }

    public boolean existsModule(AbstractModule module) {
        return this.getMappedPredicates().containsKey(module.getPredicateID());
    }

    public boolean existsModule(String moduleID) {
        return this.getMappedPredicates().containsKey(moduleID);
    }

    @Override
    public Class<?> getPredicateClass() {
        return AbstractModule.class;
    }
}

