/*
 * Decompiled with CFR 0.152.
 */
package nl.uu.cs.ape.models;

import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeSet;
import nl.uu.cs.ape.domain.APEDomainSetup;
import nl.uu.cs.ape.models.AbstractModule;
import nl.uu.cs.ape.models.AuxiliaryPredicate;
import nl.uu.cs.ape.models.enums.LogicOperation;
import nl.uu.cs.ape.models.enums.NodeType;
import nl.uu.cs.ape.models.logic.constructs.TaxonomyPredicate;
import nl.uu.cs.ape.utils.APEUtils;

public class AuxModulePredicate
extends AbstractModule
implements AuxiliaryPredicate {
    private SortedSet<TaxonomyPredicate> containingPredicates;
    private final LogicOperation logicOp;

    private AuxModulePredicate(String moduleName, String moduleID, String rootNode, Collection<TaxonomyPredicate> containingPredicates, LogicOperation logicOp) {
        super(moduleName, moduleID, rootNode, NodeType.ABSTRACT);
        this.logicOp = logicOp;
        this.containingPredicates = new TreeSet<TaxonomyPredicate>();
        this.containingPredicates.addAll(containingPredicates);
    }

    public static AbstractModule generateAuxiliaryPredicate(SortedSet<TaxonomyPredicate> relatedPredicates, LogicOperation logicOp, APEDomainSetup domainSetup) {
        if (relatedPredicates.isEmpty()) {
            return null;
        }
        if (relatedPredicates.size() == 1) {
            return (AbstractModule)relatedPredicates.first();
        }
        String abstractLabel = APEUtils.getLabelFromList(relatedPredicates, logicOp);
        AuxModulePredicate newAbsType = (AuxModulePredicate)domainSetup.getAllModules().addPredicate(new AuxModulePredicate(abstractLabel, abstractLabel, relatedPredicates.first().getRootNodeID(), relatedPredicates, logicOp));
        if (newAbsType != null) {
            domainSetup.addHelperPredicate(newAbsType);
            newAbsType.setAsRelevantTaxonomyTerm(domainSetup.getAllModules());
        }
        return newAbsType;
    }

    @Override
    public LogicOperation getLogicOp() {
        return this.logicOp;
    }

    @Override
    public SortedSet<TaxonomyPredicate> getGeneralizedPredicates() {
        return this.containingPredicates;
    }
}

