/*
 * Decompiled with CFR 0.152.
 */
package nl.uu.cs.ape.models;

import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeSet;
import nl.uu.cs.ape.domain.APEDomainSetup;
import nl.uu.cs.ape.models.AuxiliaryPredicate;
import nl.uu.cs.ape.models.Type;
import nl.uu.cs.ape.models.enums.LogicOperation;
import nl.uu.cs.ape.models.enums.NodeType;
import nl.uu.cs.ape.models.logic.constructs.TaxonomyPredicate;
import nl.uu.cs.ape.utils.APEUtils;

public class AuxTypePredicate
extends Type
implements AuxiliaryPredicate {
    private SortedSet<TaxonomyPredicate> containingPredicates;
    private final LogicOperation logicOp;

    private AuxTypePredicate(String typeName, String typeID, String rootNode, NodeType nodeType, Collection<TaxonomyPredicate> containingPredicates, LogicOperation logicOp) {
        super(typeName, typeID, rootNode, nodeType);
        this.logicOp = logicOp;
        this.containingPredicates = new TreeSet<TaxonomyPredicate>();
        this.containingPredicates.addAll(containingPredicates);
    }

    public static Type generateAuxiliaryPredicate(SortedSet<TaxonomyPredicate> relatedPredicates, LogicOperation logicOp, APEDomainSetup domainSetup) {
        if (relatedPredicates.isEmpty()) {
            return null;
        }
        if (relatedPredicates.size() == 1) {
            return (Type)relatedPredicates.first();
        }
        String abstractLabel = APEUtils.getLabelFromList(relatedPredicates, logicOp);
        AuxTypePredicate newAbsType = (AuxTypePredicate)domainSetup.getAllTypes().addPredicate(new AuxTypePredicate(abstractLabel, abstractLabel, relatedPredicates.first().getRootNodeID(), NodeType.ABSTRACT, relatedPredicates, logicOp));
        if (newAbsType != null) {
            domainSetup.addHelperPredicate(newAbsType);
            newAbsType.setAsRelevantTaxonomyTerm(domainSetup.getAllTypes());
        }
        return newAbsType;
    }

    @Override
    public LogicOperation getLogicOp() {
        return this.logicOp;
    }

    @Override
    public SortedSet<TaxonomyPredicate> getGeneralizedPredicates() {
        return this.containingPredicates;
    }
}

