/*
 * Decompiled with CFR 0.152.
 */
package nl.uu.cs.ape.models;

import org.json.JSONObject;

public class Range {
    public static final String MIN_TAG = "min";
    public static final String MAX_TAG = "max";
    final int min;
    final int max;

    private Range(int min, int max) {
        this.min = min;
        this.max = max;
    }

    public static Range from(JSONObject json) {
        return new Range(json.getInt(MIN_TAG), json.getInt(MAX_TAG));
    }

    public static Range from(String json) {
        return Range.from(new JSONObject(json));
    }

    public static Range of(int minimum, int maximum) {
        return new Range(minimum, maximum);
    }

    public JSONObject toJSON() {
        return new JSONObject().put(MIN_TAG, this.min).put(MAX_TAG, this.max);
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public int getLength() {
        return this.max - this.min;
    }
}

