/*
 * Decompiled with CFR 0.152.
 */
package nl.uu.cs.ape.models.sltlxStruc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public class CNFClause {
    List<Integer> atoms = new ArrayList<Integer>();

    public CNFClause(List<Integer> atoms) {
        atoms.forEach(atom -> this.atoms.add((Integer)atom));
    }

    public CNFClause(Integer atom) {
        this.atoms.add(atom);
    }

    public static Set<String> conjunctClausesCollection(Set<Set<String>> facts) {
        HashSet<String> allClauses = new HashSet<String>();
        facts.forEach(col -> allClauses.addAll((Collection<String>)col));
        return allClauses;
    }

    public static Set<String> disjoinClausesCollection(Set<Set<String>> facts) {
        ArrayList clausesList = new ArrayList();
        Iterator<Set<String>> currDisjFact = facts.iterator();
        if (currDisjFact.hasNext()) {
            clausesList.addAll(currDisjFact.next());
            while (currDisjFact.hasNext()) {
                Collection newClauses = currDisjFact.next();
                ListIterator<String> allClausesIt = clausesList.listIterator();
                while (allClausesIt.hasNext()) {
                    String existingClause = (String)allClausesIt.next();
                    allClausesIt.remove();
                    for (String newClause : newClauses) {
                        allClausesIt.add(CNFClause.disjoin2Clauses(existingClause, newClause));
                    }
                }
            }
        }
        HashSet<String> allClauses = new HashSet<String>();
        allClauses.addAll(clausesList);
        return allClauses;
    }

    public static String disjoin2Clauses(String clause1, String clause2) {
        String clause1Cleaned = clause1.substring(0, clause1.indexOf("0\n"));
        return clause1Cleaned + clause2;
    }

    public Set<CNFClause> createCNFEncoding() {
        HashSet<CNFClause> clause = new HashSet<CNFClause>();
        clause.add(this);
        return clause;
    }

    public Set<CNFClause> createNegatedCNFEncoding() {
        HashSet<CNFClause> clauses = new HashSet<CNFClause>();
        for (int element : this.atoms) {
            clauses.add(new CNFClause(-element));
        }
        return clauses;
    }

    public Set<String> toCNF() {
        StringBuilder cnf = new StringBuilder();
        this.atoms.forEach(elem -> cnf.append(elem + " "));
        cnf.append("0\n");
        HashSet<String> clauses = new HashSet<String>();
        clauses.add(cnf.toString());
        return clauses;
    }

    public Set<String> toNegatedCNF() {
        HashSet<String> clauses = new HashSet<String>();
        this.atoms.forEach(elem -> clauses.add(-elem.intValue() + " 0\n"));
        return clauses;
    }
}

