/*
 * Decompiled with CFR 0.152.
 */
package nl.uu.cs.ape.models.sltlxStruc;

import java.util.Set;
import nl.uu.cs.ape.automaton.State;
import nl.uu.cs.ape.models.enums.AtomType;
import nl.uu.cs.ape.models.logic.constructs.PredicateLabel;
import nl.uu.cs.ape.models.sltlxStruc.CNFClause;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxFormula;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxVariableSubstitutionCollection;
import nl.uu.cs.ape.solver.minisat.SATSynthesisEngine;

public class SLTLxAtom
extends SLTLxFormula
implements Comparable<SLTLxAtom> {
    private final PredicateLabel predicate;
    private final State argumentState;
    private AtomType elementType;
    private CNFClause clause = null;

    public SLTLxAtom(AtomType elementType, PredicateLabel predicate, State usedInState) {
        this.predicate = predicate;
        this.argumentState = usedInState;
        this.elementType = elementType;
    }

    private SLTLxAtom(int mapping) {
        this.predicate = null;
        this.argumentState = null;
        this.clause = new CNFClause(mapping);
    }

    public PredicateLabel getPredicate() {
        return this.predicate;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.argumentState == null ? 0 : this.argumentState.hashCode());
        result = 31 * result + (this.elementType == null ? 0 : this.elementType.hashCode());
        result = 31 * result + (this.predicate == null ? 0 : this.predicate.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SLTLxAtom other = (SLTLxAtom)obj;
        if (this.argumentState == null ? other.argumentState != null : !this.argumentState.equals(other.argumentState)) {
            return false;
        }
        if (this.elementType != other.elementType) {
            return false;
        }
        return !(this.predicate == null ? other.predicate != null : !this.predicate.equals(other.predicate));
    }

    public State getUsedInStateArgument() {
        return this.argumentState;
    }

    public AtomType getWorkflowElementType() {
        return this.elementType;
    }

    public String toString() {
        if (this.elementType.isUnaryProperty()) {
            return this.predicate.getPredicateID() + "(" + this.argumentState.getPredicateID() + ")";
        }
        if (this.elementType.isBinaryRel()) {
            return this.elementType.toString() + "(" + this.predicate.getPredicateID() + "," + this.argumentState.getPredicateID() + ")";
        }
        return "SLTLxAtom_ERROR";
    }

    public boolean isWorkflowElementType(AtomType workflowElemType) {
        return this.getWorkflowElementType() == workflowElemType;
    }

    @Override
    public int compareTo(SLTLxAtom otherAtom) {
        int thisAtomState = this.getUsedInStateArgument().getAbsoluteStateNumber();
        int otherAtomState = otherAtom.getUsedInStateArgument().getAbsoluteStateNumber();
        int diff = 0;
        diff = Integer.compare(thisAtomState, otherAtomState);
        if (diff != 0) {
            return diff;
        }
        return this.getPredicate().compareTo(otherAtom.getPredicate());
    }

    public static SLTLxAtom getTrue() {
        return new SLTLxAtom(1);
    }

    public static SLTLxAtom getFalse() {
        return new SLTLxAtom(2);
    }

    @Override
    public Set<String> getCNFEncoding(int stateNo, SLTLxVariableSubstitutionCollection variableMapping, SATSynthesisEngine synthesisEngine) {
        if (this.clause == null) {
            int encoding = synthesisEngine.getMappings().add(this);
            this.clause = new CNFClause(encoding);
        }
        return this.clause.toCNF();
    }

    @Override
    public Set<String> getNegatedCNFEncoding(int stateNo, SLTLxVariableSubstitutionCollection variableMapping, SATSynthesisEngine synthesisEngine) {
        if (this.clause == null) {
            int encoding = synthesisEngine.getMappings().add(this);
            this.clause = new CNFClause(encoding);
        }
        return this.clause.toNegatedCNF();
    }
}

