/*
 * Decompiled with CFR 0.152.
 */
package nl.uu.cs.ape.models.sltlxStruc;

import java.util.Set;
import nl.uu.cs.ape.automaton.State;
import nl.uu.cs.ape.models.Pair;
import nl.uu.cs.ape.models.enums.AtomVarType;
import nl.uu.cs.ape.models.logic.constructs.PredicateLabel;
import nl.uu.cs.ape.models.sltlxStruc.CNFClause;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxFormula;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxVariable;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxVariableSubstitutionCollection;
import nl.uu.cs.ape.solver.minisat.SATSynthesisEngine;

public class SLTLxAtomVar
extends SLTLxFormula {
    private PredicateLabel firstArg;
    private SLTLxVariable secondArg;
    private AtomVarType elementType;
    private CNFClause clause = null;

    public SLTLxAtomVar(AtomVarType elementType, PredicateLabel firstArg, SLTLxVariable secondArg) {
        this.firstArg = firstArg;
        this.secondArg = secondArg;
        this.elementType = elementType;
    }

    public PredicateLabel getFirstArg() {
        return this.firstArg;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.secondArg == null ? 0 : this.secondArg.hashCode());
        result = 31 * result + (this.elementType == null ? 0 : this.elementType.hashCode());
        result = 31 * result + (this.firstArg == null ? 0 : this.firstArg.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SLTLxAtomVar other = (SLTLxAtomVar)obj;
        if (this.secondArg == null ? other.secondArg != null : !this.secondArg.equals(other.secondArg)) {
            return false;
        }
        if (this.elementType != other.elementType) {
            return false;
        }
        return !(this.firstArg == null ? other.firstArg != null : !this.firstArg.equals(other.firstArg));
    }

    public SLTLxVariable getSecondArg() {
        return this.secondArg;
    }

    public AtomVarType getWorkflowElementType() {
        return this.elementType;
    }

    public String toString() {
        if (this.elementType.isVarDataType()) {
            return this.firstArg.getPredicateID() + "(" + this.secondArg.getPredicateID() + ")";
        }
        if (this.elementType.isVarMemReference()) {
            return "[" + this.firstArg.getPredicateID() + "->" + this.secondArg.getPredicateID() + "]";
        }
        if (this.elementType.isBinaryRel()) {
            return this.elementType.toString() + "(" + this.firstArg.getPredicateID() + "," + this.secondArg.getPredicateID() + ")";
        }
        return "SLTLxAtomVar_ERROR";
    }

    public boolean isWorkflowElementType(AtomVarType workflowElemType) {
        return this.getWorkflowElementType() == workflowElemType;
    }

    @Override
    public Set<String> getCNFEncoding(int stateNo, SLTLxVariableSubstitutionCollection variableMapping, SATSynthesisEngine synthesisEngine) {
        if (this.clause == null) {
            this.substituteVariables(variableMapping, synthesisEngine);
            int encoding = synthesisEngine.getMappings().add(this);
            this.clause = new CNFClause(encoding);
        }
        return this.clause.toCNF();
    }

    @Override
    public Set<String> getNegatedCNFEncoding(int stateNo, SLTLxVariableSubstitutionCollection variableMapping, SATSynthesisEngine synthesisEngine) {
        if (this.clause == null) {
            this.substituteVariables(variableMapping, synthesisEngine);
            int encoding = synthesisEngine.getMappings().add(this);
            this.clause = new CNFClause(encoding);
        }
        return this.clause.toNegatedCNF();
    }

    private void substituteVariables(SLTLxVariableSubstitutionCollection variableMapping, SATSynthesisEngine synthesisEngine) {
        if (this.elementType.isVarDataType()) {
            this.secondArg = variableMapping.getVarSabstitute(this.secondArg);
            synthesisEngine.getVariableUsage().addDataType(this.firstArg, this.secondArg);
        } else if (this.elementType.isVarMemReference()) {
            this.secondArg = variableMapping.getVarSabstitute(this.secondArg);
            synthesisEngine.getVariableUsage().addMemoryReference((State)this.firstArg, this.secondArg);
        } else if (this.elementType.isBinaryRel() && !this.elementType.equals((Object)AtomVarType.VAR_VALUE)) {
            this.firstArg = variableMapping.getVarSabstitute((SLTLxVariable)this.firstArg);
            this.secondArg = variableMapping.getVarSabstitute(this.secondArg);
            synthesisEngine.getVariableUsage().addBinaryPred(new Pair<SLTLxVariable>((SLTLxVariable)this.firstArg, this.secondArg), this.elementType);
        } else if (this.elementType.equals((Object)AtomVarType.VAR_VALUE)) {
            this.secondArg = variableMapping.getVarSabstitute(this.secondArg);
        }
    }
}

