/*
 * Decompiled with CFR 0.152.
 */
package nl.uu.cs.ape.models.sltlxStruc;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import nl.uu.cs.ape.models.sltlxStruc.CNFClause;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxAtom;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxFormula;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxVariableSubstitutionCollection;
import nl.uu.cs.ape.solver.minisat.SATSynthesisEngine;

public class SLTLxDisjunction
extends SLTLxFormula {
    private Set<SLTLxFormula> disjointFacts = new HashSet<SLTLxFormula>();

    public SLTLxDisjunction(SLTLxFormula arg1, SLTLxFormula arg2) {
        if (arg1 != null) {
            this.disjointFacts.add(arg1);
        }
        if (arg2 != null) {
            this.disjointFacts.add(arg2);
        }
    }

    public SLTLxDisjunction(Collection<? extends SLTLxFormula> conjunctedFacts) {
        conjunctedFacts.forEach(fact -> {
            if (fact != null) {
                this.disjointFacts.add((SLTLxFormula)fact);
            }
        });
    }

    @Override
    public Set<String> getCNFEncoding(int stateNo, SLTLxVariableSubstitutionCollection variableMapping, SATSynthesisEngine synthesisEngine) {
        if (this.disjointFacts.isEmpty()) {
            return SLTLxAtom.getFalse().getCNFEncoding(stateNo, variableMapping, synthesisEngine);
        }
        HashSet<Set<String>> allClauses = new HashSet<Set<String>>();
        for (SLTLxFormula formula : this.disjointFacts) {
            allClauses.add(formula.getCNFEncoding(stateNo, variableMapping, synthesisEngine));
        }
        return CNFClause.disjoinClausesCollection(allClauses);
    }

    @Override
    public Set<String> getNegatedCNFEncoding(int stateNo, SLTLxVariableSubstitutionCollection variableMapping, SATSynthesisEngine synthesisEngine) {
        if (this.disjointFacts.isEmpty()) {
            return SLTLxAtom.getTrue().getCNFEncoding(stateNo, variableMapping, synthesisEngine);
        }
        HashSet<Set<String>> allClauses = new HashSet<Set<String>>();
        for (SLTLxFormula formula : this.disjointFacts) {
            allClauses.add(formula.getNegatedCNFEncoding(stateNo, variableMapping, synthesisEngine));
        }
        return CNFClause.conjunctClausesCollection(allClauses);
    }
}

