/*
 * Decompiled with CFR 0.152.
 */
package nl.uu.cs.ape.models.sltlxStruc;

import nl.uu.cs.ape.automaton.State;
import nl.uu.cs.ape.models.SATAtomMappings;
import nl.uu.cs.ape.models.enums.AtomType;
import nl.uu.cs.ape.models.logic.constructs.PredicateLabel;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxAtom;
import nl.uu.cs.ape.models.sltlxStruc.SLTLxAtomVar;

public class SLTLxLiteral
implements Comparable<SLTLxLiteral> {
    private Integer mappedAtom;
    private Boolean negated;
    private SLTLxAtom atom;
    private SLTLxAtomVar atomVar;

    public SLTLxLiteral(String mappedLiteral, SATAtomMappings atomMapping) {
        if (mappedLiteral.startsWith("-")) {
            this.negated = true;
            this.mappedAtom = Integer.parseInt(mappedLiteral.substring(1));
        } else {
            this.negated = false;
            this.mappedAtom = Integer.parseInt(mappedLiteral);
        }
        this.atom = atomMapping.findOriginal(this.mappedAtom);
        this.atomVar = atomMapping.findOriginalVar(this.mappedAtom);
    }

    public String toMappedString() {
        if (this.negated.booleanValue()) {
            return "-" + this.mappedAtom.toString();
        }
        return this.mappedAtom.toString();
    }

    public String toNegatedMappedString() {
        if (this.negated.booleanValue()) {
            return this.mappedAtom.toString();
        }
        return "-" + this.mappedAtom.toString();
    }

    public int toNegatedMappedInt() {
        if (this.negated.booleanValue()) {
            return this.mappedAtom;
        }
        return -this.mappedAtom.intValue();
    }

    public AtomType getWorkflowElementType() {
        return this.atom.getWorkflowElementType();
    }

    public boolean isWorkflowElementType(AtomType workflowElemType) {
        return this.atom.getWorkflowElementType() == workflowElemType;
    }

    public boolean isNegated() {
        return this.negated;
    }

    public State getUsedInStateArgument() {
        return this.atom.getUsedInStateArgument();
    }

    public SLTLxAtom getAtom() {
        return this.atom;
    }

    public PredicateLabel getPredicate() {
        return this.atom.getPredicate();
    }

    public int hashCode() {
        int prime = 31;
        int result = this.atom.hashCode();
        result = 31 * result + (this.negated == null ? 0 : this.negated.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SLTLxLiteral other = (SLTLxLiteral)obj;
        if (this.negated == null ? other.negated != null : !this.negated.equals(other.negated)) {
            return false;
        }
        return this.atom.equals(other.atom);
    }

    @Override
    public int compareTo(SLTLxLiteral otherLiteral) {
        int thisLiteralState = this.getUsedInStateArgument().getAbsoluteStateNumber();
        int otherLiteralState = otherLiteral.getUsedInStateArgument().getAbsoluteStateNumber();
        int diff = 0;
        diff = Integer.compare(thisLiteralState, otherLiteralState);
        if (diff != 0) {
            return diff;
        }
        return this.getPredicate().compareTo(otherLiteral.getPredicate());
    }

    public String toString() {
        if (this.atom != null) {
            if (this.negated.booleanValue()) {
                return "-" + this.atom.toString();
            }
            return this.atom.toString();
        }
        if (this.negated.booleanValue()) {
            return "-" + this.atomVar.toString();
        }
        return this.atomVar.toString();
    }
}

